/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.admin.std.server.OrderingMatchingRuleCfg;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.schema.GeneralizedTimeSyntax;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;

public class GeneralizedTimeOrderingMatchingRule
extends OrderingMatchingRule {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final long serialVersionUID = -6343622924726948145L;
    private static ReentrantLock dateFormatLock;
    private static SimpleDateFormat dateFormat;
    private static TimeZone utcTimeZone;

    public void initializeMatchingRule(OrderingMatchingRuleCfg configuration) throws ConfigException, InitializationException {
    }

    public String getName() {
        return "generalizedTimeOrderingMatch";
    }

    public String getOID() {
        return "2.5.13.28";
    }

    public String getDescription() {
        return null;
    }

    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.24";
    }

    public ByteString normalizeValue(ByteString value) throws DirectoryException {
        try {
            long timestamp = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(value);
            return new ASN1OctetString(GeneralizedTimeSyntax.format(timestamp));
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw de;
                }
                case WARN: {
                    ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, de.getErrorMessage(), de.getMessageID());
                    return new ASN1OctetString(value.value());
                }
            }
            return new ASN1OctetString(value.value());
        }
    }

    public int compareValues(ByteString value1, ByteString value2) {
        try {
            long time1 = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(value1);
            long time2 = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(value2);
            if (time1 == time2) {
                return 0;
            }
            if (time1 > time2) {
                return 1;
            }
            return -1;
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            return 0;
        }
    }

    public int compare(byte[] b1, byte[] b2) {
        return this.compareValues(new ASN1OctetString(b1), new ASN1OctetString(b2));
    }

    static {
        utcTimeZone = TimeZone.getTimeZone("UTC");
        dateFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'");
        dateFormat.setLenient(false);
        dateFormat.setTimeZone(utcTimeZone);
        dateFormatLock = new ReentrantLock();
    }
}

