/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.schema.GuideSyntax;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnhancedGuideSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.17");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.17", "EnhancedGuide");
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.18");
        if (this.defaultOrderingMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553603, "2.5.13.18", "EnhancedGuide");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.19");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.19", "EnhancedGuide");
        }
    }

    @Override
    public String getSyntaxName() {
        return "EnhancedGuide";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.21";
    }

    @Override
    public String getDescription() {
        return "Enhanced Guide";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString value, StringBuilder invalidReason) {
        String valueStr = StaticUtils.toLowerCase(value.stringValue());
        int sharpPos = valueStr.indexOf(35);
        if (sharpPos < 0) {
            int msgID = 6488277;
            invalidReason.append(MessageHandler.getMessage(msgID, valueStr));
            return false;
        }
        String ocName = valueStr.substring(0, sharpPos).trim();
        int ocLength = ocName.length();
        if (ocLength == 0) {
            int msgID = 6488278;
            invalidReason.append(MessageHandler.getMessage(msgID, valueStr));
            return false;
        }
        if (!StaticUtils.isValidSchemaElement(ocName, 0, ocLength, invalidReason)) {
            return false;
        }
        int lastSharpPos = valueStr.lastIndexOf(35);
        if (lastSharpPos == sharpPos) {
            int msgID = 6488282;
            invalidReason.append(MessageHandler.getMessage(msgID, valueStr));
            return false;
        }
        String scopeStr = valueStr.substring(lastSharpPos + 1).trim();
        if (!(scopeStr.equals("baseobject") || scopeStr.equals("onelevel") || scopeStr.equals("wholesubtree") || scopeStr.equals("subordinatesubtree"))) {
            if (scopeStr.length() == 0) {
                int msgID = 6488283;
                invalidReason.append(MessageHandler.getMessage(msgID, valueStr));
            } else {
                int msgID = 6488284;
                invalidReason.append(MessageHandler.getMessage(msgID, valueStr, scopeStr));
            }
            return false;
        }
        String criteria = valueStr.substring(sharpPos + 1, lastSharpPos).trim();
        int criteriaLength = criteria.length();
        if (criteriaLength == 0) {
            int msgID = 6488285;
            invalidReason.append(MessageHandler.getMessage(msgID, valueStr));
            return false;
        }
        return GuideSyntax.criteriaIsValid(criteria, valueStr, invalidReason);
    }
}

