/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Arrays;
import org.opends.server.admin.std.server.EqualityMatchingRuleCfg;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AcceptRejectWarn;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class DistinguishedNameEqualityMatchingRule
extends EqualityMatchingRule {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public void initializeMatchingRule(EqualityMatchingRuleCfg configuration) throws ConfigException, InitializationException {
    }

    public String getName() {
        return "distinguishedNameMatch";
    }

    public String getOID() {
        return "2.5.13.1";
    }

    public String getDescription() {
        return null;
    }

    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.12";
    }

    public ByteString normalizeValue(ByteString value) throws DirectoryException {
        DN dn;
        try {
            dn = DN.decode(value.stringValue());
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            if (DirectoryServer.getSyntaxEnforcementPolicy() == AcceptRejectWarn.REJECT) {
                throw de;
            }
            return this.bestEffortNormalize(StaticUtils.toLowerCase(value.stringValue()));
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            if (DirectoryServer.getSyntaxEnforcementPolicy() == AcceptRejectWarn.REJECT) {
                int msgID = 6488089;
                String message = MessageHandler.getMessage(msgID, value.stringValue(), String.valueOf(e));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
            }
            return this.bestEffortNormalize(StaticUtils.toLowerCase(value.stringValue()));
        }
        return new ASN1OctetString(dn.toNormalizedString());
    }

    private ByteString bestEffortNormalize(String lowerString) {
        int length = lowerString.length();
        StringBuilder buffer = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = lowerString.charAt(i);
            if (c == ' ') {
                if (i == 0) continue;
                char previous = lowerString.charAt(i - 1);
                if (previous == '\\') {
                    buffer.append(' ');
                    continue;
                }
                if (previous == ',') continue;
                if (i == length - 1) break;
                char next = lowerString.charAt(i + 1);
                if (next == ' ' || next == ',') continue;
                buffer.append(' ');
                continue;
            }
            buffer.append(c);
        }
        return new ASN1OctetString(buffer.toString());
    }

    public boolean areEqual(ByteString value1, ByteString value2) {
        return Arrays.equals(value1.value(), value2.value());
    }
}

