/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.List;
import org.opends.server.admin.std.server.SubstringMatchingRuleCfg;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseIgnoreIA5SubstringMatchingRule
extends SubstringMatchingRule {
    @Override
    public void initializeMatchingRule(SubstringMatchingRuleCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public String getName() {
        return "caseIgnoreIA5SubstringsMatch";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.109.114.3";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.58";
    }

    @Override
    public ByteString normalizeValue(ByteString value) throws DirectoryException {
        StringBuilder buffer = new StringBuilder();
        StaticUtils.toLowerCase(value.value(), buffer, true);
        int bufferLength = buffer.length();
        if (bufferLength == 0) {
            if (value.value().length > 0) {
                return new ASN1OctetString(" ");
            }
            return new ASN1OctetString();
        }
        boolean logged = false;
        block4: for (int pos = bufferLength - 1; pos > 0; --pos) {
            char c = buffer.charAt(pos);
            if (c == ' ') {
                if (buffer.charAt(pos - 1) != ' ') continue;
                buffer.delete(pos, pos + 1);
                continue;
            }
            if ((c & 0x7F) == c) continue;
            int msgID = 6422610;
            String message = MessageHandler.getMessage(msgID, value.stringValue(), Character.valueOf(c));
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                }
                case WARN: {
                    if (!logged) {
                        ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                        logged = true;
                    }
                    buffer.delete(pos, pos + 1);
                    continue block4;
                }
                default: {
                    buffer.delete(pos, pos + 1);
                }
            }
        }
        return new ASN1OctetString(buffer.toString());
    }

    @Override
    public ByteString normalizeSubstring(ByteString substring) throws DirectoryException {
        StringBuilder buffer = new StringBuilder();
        StaticUtils.toLowerCase(substring.value(), buffer, false);
        int bufferLength = buffer.length();
        if (bufferLength == 0) {
            if (substring.value().length > 0) {
                return new ASN1OctetString(" ");
            }
            return substring;
        }
        boolean logged = false;
        block4: for (int pos = bufferLength - 1; pos > 0; --pos) {
            char c = buffer.charAt(pos);
            if (c == ' ') {
                if (buffer.charAt(pos - 1) != ' ') continue;
                buffer.delete(pos, pos + 1);
                continue;
            }
            if ((c & 0x7F) == c) continue;
            int msgID = 6422610;
            String message = MessageHandler.getMessage(msgID, substring.stringValue(), Character.valueOf(c));
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                }
                case WARN: {
                    if (!logged) {
                        ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                        logged = true;
                    }
                    buffer.delete(pos, pos + 1);
                    continue block4;
                }
                default: {
                    buffer.delete(pos, pos + 1);
                }
            }
        }
        return new ASN1OctetString(buffer.toString());
    }

    @Override
    public boolean valueMatchesSubstring(ByteString value, ByteString subInitial, List<ByteString> subAnyElements, ByteString subFinal) {
        int pos;
        byte[] valueBytes = value.value();
        int valueLength = valueBytes.length;
        if (subInitial != null) {
            byte[] initialBytes = subInitial.value();
            int initialLength = initialBytes.length;
            if (initialLength > valueLength) {
                return false;
            }
            for (pos = 0; pos < initialLength; ++pos) {
                if (initialBytes[pos] == valueBytes[pos]) continue;
                return false;
            }
        }
        if (subAnyElements != null && !subAnyElements.isEmpty()) {
            for (ByteString element : subAnyElements) {
                byte[] anyBytes = element.value();
                int anyLength = anyBytes.length;
                int end = valueLength - anyLength;
                boolean match = false;
                while (pos <= end) {
                    if (anyBytes[0] == valueBytes[pos]) {
                        boolean subMatch = true;
                        for (int i = 1; i < anyLength; ++i) {
                            if (anyBytes[i] == valueBytes[pos + i]) continue;
                            subMatch = false;
                            break;
                        }
                        if (subMatch) {
                            match = subMatch;
                            break;
                        }
                    }
                    ++pos;
                }
                if (match) {
                    pos += anyLength;
                    continue;
                }
                return false;
            }
        }
        if (subFinal != null) {
            byte[] finalBytes = subFinal.value();
            int finalLength = finalBytes.length;
            if (valueLength - finalLength < pos) {
                return false;
            }
            pos = valueLength - finalLength;
            int i = 0;
            while (i < finalLength) {
                if (finalBytes[i] != valueBytes[pos]) {
                    return false;
                }
                ++i;
                ++pos;
            }
        }
        return true;
    }
}

