/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Arrays;
import org.opends.server.admin.std.server.EqualityMatchingRuleCfg;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class CaseIgnoreIA5EqualityMatchingRule
extends EqualityMatchingRule {
    public void initializeMatchingRule(EqualityMatchingRuleCfg configuration) throws ConfigException, InitializationException {
    }

    public String getName() {
        return "caseIgnoreIA5Match";
    }

    public String getOID() {
        return "1.3.6.1.4.1.1466.109.114.2";
    }

    public String getDescription() {
        return null;
    }

    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.26";
    }

    public ByteString normalizeValue(ByteString value) throws DirectoryException {
        StringBuilder buffer = new StringBuilder();
        StaticUtils.toLowerCase(value.value(), buffer, true);
        int bufferLength = buffer.length();
        if (bufferLength == 0) {
            if (value.value().length > 0) {
                return new ASN1OctetString(" ");
            }
            return new ASN1OctetString();
        }
        boolean logged = false;
        block4: for (int pos = bufferLength - 1; pos > 0; --pos) {
            char c = buffer.charAt(pos);
            if (c == ' ') {
                if (buffer.charAt(pos - 1) != ' ') continue;
                buffer.delete(pos, pos + 1);
                continue;
            }
            if ((c & 0x7F) == c) continue;
            int msgID = 6422610;
            String message = MessageHandler.getMessage(msgID, value.stringValue(), Character.valueOf(c));
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                }
                case WARN: {
                    if (!logged) {
                        ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                        logged = true;
                    }
                    buffer.delete(pos, pos + 1);
                    continue block4;
                }
                default: {
                    buffer.delete(pos, pos + 1);
                }
            }
        }
        return new ASN1OctetString(buffer.toString());
    }

    public boolean areEqual(ByteString value1, ByteString value2) {
        return Arrays.equals(value1.value(), value2.value());
    }
}

