/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.schema.PrintableString;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthPasswordSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private EqualityMatchingRule defaultEqualityMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("1.3.6.1.4.1.4203.1.2.2");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "authPasswordExactMatch", "AuthenticationPasswordSyntax");
        }
    }

    @Override
    public String getSyntaxName() {
        return "AuthenticationPasswordSyntax";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.4203.1.1.2";
    }

    @Override
    public String getDescription() {
        return "Authentication Password Syntax";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return null;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return null;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString value, StringBuilder invalidReason) {
        try {
            AuthPasswordSyntax.decodeAuthPassword(value.stringValue());
            return true;
        }
        catch (DirectoryException de) {
            invalidReason.append(de.getErrorMessage());
            return false;
        }
    }

    public static StringBuilder[] decodeAuthPassword(String authPasswordValue) throws DirectoryException {
        int msgID;
        char c;
        int pos;
        StringBuilder scheme = new StringBuilder();
        StringBuilder authInfo = new StringBuilder();
        StringBuilder authValue = new StringBuilder();
        int length = authPasswordValue.length();
        for (pos = 0; pos < length && authPasswordValue.charAt(pos) == ' '; ++pos) {
        }
        block5: while (pos < length) {
            c = authPasswordValue.charAt(pos);
            switch (c) {
                case '-': 
                case '.': 
                case '/': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': {
                    scheme.append(c);
                    ++pos;
                    break;
                }
                case ' ': 
                case '$': {
                    break block5;
                }
                default: {
                    int msgID2 = 6553843;
                    String message = MessageHandler.getMessage(msgID2, pos);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID2);
                }
            }
        }
        if (scheme.length() == 0) {
            msgID = 6553844;
            String message = MessageHandler.getMessage(msgID);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        while (pos < length && authPasswordValue.charAt(pos) == ' ') {
            ++pos;
        }
        if (pos < length && authPasswordValue.charAt(pos) == '$') {
            ++pos;
        } else {
            msgID = 6553845;
            String message = MessageHandler.getMessage(msgID);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        while (pos < length && authPasswordValue.charAt(pos) == ' ') {
            ++pos;
        }
        while (pos < length && (c = authPasswordValue.charAt(pos)) != ' ' && c != '$') {
            if (PrintableString.isPrintableCharacter(c)) {
                authInfo.append(c);
                ++pos;
                continue;
            }
            int msgID3 = 6553846;
            String message = MessageHandler.getMessage(msgID3, pos);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID3);
        }
        if (scheme.length() == 0) {
            msgID = 6553847;
            String message = MessageHandler.getMessage(msgID);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        while (pos < length && authPasswordValue.charAt(pos) == ' ') {
            ++pos;
        }
        if (pos < length && authPasswordValue.charAt(pos) == '$') {
            ++pos;
        } else {
            msgID = 6553848;
            String message = MessageHandler.getMessage(msgID);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        while (pos < length && authPasswordValue.charAt(pos) == ' ') {
            ++pos;
        }
        while (pos < length && (c = authPasswordValue.charAt(pos)) != ' ' && c != '$') {
            if (PrintableString.isPrintableCharacter(c)) {
                authValue.append(c);
                ++pos;
                continue;
            }
            int msgID4 = 6553861;
            String message = MessageHandler.getMessage(msgID4, pos);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID4);
        }
        if (scheme.length() == 0) {
            msgID = 6553862;
            String message = MessageHandler.getMessage(msgID);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        while (pos < length) {
            c = authPasswordValue.charAt(pos);
            if (c == ' ') {
                ++pos;
                continue;
            }
            int msgID5 = 6553863;
            String message = MessageHandler.getMessage(msgID5, pos);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID5);
        }
        return new StringBuilder[]{scheme, authInfo, authValue};
    }

    public static boolean isEncoded(ByteString value) {
        try {
            AuthPasswordSyntax.decodeAuthPassword(value.stringValue());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

