/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.io.IOException;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.replication.protocol.AckMessage;
import org.opends.server.replication.protocol.DoneMessage;
import org.opends.server.replication.protocol.EntryMessage;
import org.opends.server.replication.protocol.ErrorMessage;
import org.opends.server.replication.protocol.InitializeRequestMessage;
import org.opends.server.replication.protocol.InitializeTargetMessage;
import org.opends.server.replication.protocol.ProtocolSession;
import org.opends.server.replication.protocol.ReplServerInfoMessage;
import org.opends.server.replication.protocol.ReplicationMessage;
import org.opends.server.replication.protocol.RoutableMessage;
import org.opends.server.replication.protocol.UpdateMessage;
import org.opends.server.replication.protocol.WindowMessage;
import org.opends.server.replication.protocol.WindowProbe;
import org.opends.server.replication.server.ReplicationCache;
import org.opends.server.replication.server.ServerHandler;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;

public class ServerReader
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private short serverId;
    private ProtocolSession session;
    private ServerHandler handler;
    private ReplicationCache replicationCache;

    public ServerReader(ProtocolSession session, short serverId, ServerHandler handler, ReplicationCache replicationCache) {
        super(handler.toString() + " reader");
        this.session = session;
        this.serverId = serverId;
        this.handler = handler;
        this.replicationCache = replicationCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block35: {
            if (DebugLogger.debugEnabled()) {
                if (this.handler.isReplicationServer()) {
                    TRACER.debugInfo("Replication server reader starting " + this.serverId);
                } else {
                    TRACER.debugInfo("LDAP server reader starting " + this.serverId);
                }
            }
            try {
                while (true) {
                    RoutableMessage initializeMsg;
                    ReplicationMessage msg;
                    if ((msg = this.session.receive()) instanceof AckMessage) {
                        AckMessage ack = (AckMessage)msg;
                        this.handler.checkWindow();
                        this.replicationCache.ack(ack, this.serverId);
                        continue;
                    }
                    if (msg instanceof UpdateMessage) {
                        UpdateMessage update = (UpdateMessage)msg;
                        this.handler.decAndCheckWindow();
                        this.replicationCache.put(update, this.handler);
                        continue;
                    }
                    if (msg instanceof WindowMessage) {
                        WindowMessage windowMsg = (WindowMessage)msg;
                        this.handler.updateWindow(windowMsg);
                        continue;
                    }
                    if (msg instanceof InitializeRequestMessage) {
                        initializeMsg = (InitializeRequestMessage)msg;
                        this.handler.process(initializeMsg);
                        continue;
                    }
                    if (msg instanceof InitializeTargetMessage) {
                        initializeMsg = (InitializeTargetMessage)msg;
                        this.handler.process(initializeMsg);
                        continue;
                    }
                    if (msg instanceof EntryMessage) {
                        EntryMessage entryMsg = (EntryMessage)msg;
                        this.handler.process(entryMsg);
                        continue;
                    }
                    if (msg instanceof DoneMessage) {
                        DoneMessage doneMsg = (DoneMessage)msg;
                        this.handler.process(doneMsg);
                        continue;
                    }
                    if (msg instanceof ErrorMessage) {
                        ErrorMessage errorMsg = (ErrorMessage)msg;
                        this.handler.process(errorMsg);
                        continue;
                    }
                    if (msg instanceof WindowProbe) {
                        WindowProbe windowProbeMsg = (WindowProbe)msg;
                        this.handler.process(windowProbeMsg);
                        continue;
                    }
                    if (msg instanceof ReplServerInfoMessage) {
                        ReplServerInfoMessage infoMsg = (ReplServerInfoMessage)msg;
                        this.handler.setReplServerInfo(infoMsg);
                        continue;
                    }
                    if (msg == null) break;
                }
                int msgID = 15138868;
                String message = MessageHandler.getMessage(msgID, this.handler.toString());
                ErrorLogger.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            }
            catch (IOException e) {
                int msgID = 15138832;
                String message = MessageHandler.getMessage(msgID, this.handler.toString());
                ErrorLogger.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.NOTICE, message + ": " + e.getMessage(), msgID);
                try {
                    this.session.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                this.replicationCache.stopServer(this.handler);
                break block35;
            }
            catch (ClassNotFoundException e) {
                int msgID = 14942239;
                String message = MessageHandler.getMessage(msgID, this.handler.toString());
                ErrorLogger.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.NOTICE, message, msgID);
                break block35;
                catch (Exception e3) {
                    msgID = 15138869;
                    message = MessageHandler.getMessage(msgID, this.handler.toString());
                    ErrorLogger.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                    try {
                        this.session.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.replicationCache.stopServer(this.handler);
                    break block35;
                }
                finally {
                    try {
                        this.session.close();
                    }
                    catch (IOException e4) {}
                    this.replicationCache.stopServer(this.handler);
                }
            }
            try {
                this.session.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.replicationCache.stopServer(this.handler);
            return;
        }
        if (!DebugLogger.debugEnabled()) return;
        if (this.handler.isReplicationServer()) {
            TRACER.debugInfo("Replication server reader stopping " + this.serverId);
            return;
        }
        TRACER.debugInfo("LDAP server reader stopping " + this.serverId);
    }
}

