/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.File;
import java.io.UnsupportedEncodingException;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.replication.server.DbHandler;
import org.opends.server.replication.server.ReplicationDBException;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.util.StaticUtils;

public class ReplicationDbEnv {
    private Environment dbEnvironment = null;
    private Database stateDb = null;
    private ReplicationServer replicationServer = null;

    public ReplicationDbEnv(String path, ReplicationServer replicationServer) throws DatabaseException, ReplicationDBException {
        this.replicationServer = replicationServer;
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setAllowCreate(true);
        envConfig.setTransactional(true);
        envConfig.setConfigParam("je.cleaner.expunge", "true");
        envConfig.setConfigParam("je.maxMemory", "5000000");
        this.dbEnvironment = new Environment(new File(path), envConfig);
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setAllowCreate(true);
        dbConfig.setTransactional(true);
        this.stateDb = this.dbEnvironment.openDatabase(null, "changelogstate", dbConfig);
        this.start();
    }

    private void start() throws DatabaseException, ReplicationDBException {
        Cursor cursor = this.stateDb.openCursor(null, null);
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        try {
            OperationStatus status = cursor.getFirst(key, data, LockMode.DEFAULT);
            while (status == OperationStatus.SUCCESS) {
                try {
                    String stringData = new String(data.getData(), "UTF-8");
                    String[] str = stringData.split(" ", 2);
                    short serverId = new Short(str[0]);
                    DN baseDn = null;
                    try {
                        baseDn = DN.decode(str[1]);
                    }
                    catch (DirectoryException e) {
                        int msgID = 14942235;
                        String message = MessageHandler.getMessage(msgID, str[1]);
                        ErrorLogger.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                    }
                    DbHandler dbHandler = new DbHandler(serverId, baseDn, this.replicationServer, this);
                    this.replicationServer.getReplicationCache(baseDn).newDb(serverId, dbHandler);
                }
                catch (NumberFormatException e) {
                    throw new ReplicationDBException(0, "replicationServer state database has a wrong format");
                }
                catch (UnsupportedEncodingException e) {
                    throw new ReplicationDBException(0, "need UTF-8 support");
                }
                status = cursor.getNext(key, data, LockMode.DEFAULT);
            }
            cursor.close();
        }
        catch (DatabaseException dbe) {
            cursor.close();
            throw dbe;
        }
    }

    public Database getOrAddDb(Short serverId, DN baseDn) throws DatabaseException {
        try {
            String stringId = serverId.toString() + " " + baseDn.toNormalizedString();
            byte[] byteId = stringId.getBytes("UTF-8");
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setAllowCreate(true);
            dbConfig.setTransactional(true);
            Database db = this.dbEnvironment.openDatabase(null, stringId, dbConfig);
            DatabaseEntry key = new DatabaseEntry();
            key.setData(byteId);
            DatabaseEntry data = new DatabaseEntry();
            OperationStatus status = this.stateDb.get(null, key, data, LockMode.DEFAULT);
            if (status == OperationStatus.NOTFOUND) {
                Transaction txn = this.dbEnvironment.beginTransaction(null, null);
                try {
                    data.setData(byteId);
                    this.stateDb.put(txn, key, data);
                    txn.commitWriteNoSync();
                }
                catch (DatabaseException dbe) {
                    txn.abort();
                    throw dbe;
                }
            }
            return db;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public Transaction beginTransaction() throws DatabaseException {
        return this.dbEnvironment.beginTransaction(null, null);
    }

    public void shutdown() {
        try {
            this.stateDb.close();
            this.dbEnvironment.close();
        }
        catch (DatabaseException e) {
            int msgID = 14942236;
            String message = MessageHandler.getMessage(msgID) + StaticUtils.stackTraceToSingleLineString(e);
            ErrorLogger.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
        }
    }
}

