/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.replication.protocol.AckMessage;
import org.opends.server.replication.protocol.AddMsg;
import org.opends.server.replication.protocol.DeleteMsg;
import org.opends.server.replication.protocol.DoneMessage;
import org.opends.server.replication.protocol.EntryMessage;
import org.opends.server.replication.protocol.ErrorMessage;
import org.opends.server.replication.protocol.HeartbeatMessage;
import org.opends.server.replication.protocol.InitializeRequestMessage;
import org.opends.server.replication.protocol.InitializeTargetMessage;
import org.opends.server.replication.protocol.ModifyDNMsg;
import org.opends.server.replication.protocol.ModifyMsg;
import org.opends.server.replication.protocol.ReplServerInfoMessage;
import org.opends.server.replication.protocol.ReplServerStartMessage;
import org.opends.server.replication.protocol.ServerStartMessage;
import org.opends.server.replication.protocol.WindowMessage;
import org.opends.server.replication.protocol.WindowProbe;

public abstract class ReplicationMessage {
    static final byte MSG_TYPE_MODIFY_REQUEST = 1;
    static final byte MSG_TYPE_ADD_REQUEST = 2;
    static final byte MSG_TYPE_DELETE_REQUEST = 3;
    static final byte MSG_TYPE_MODIFYDN_REQUEST = 4;
    static final byte MSG_TYPE_ACK = 5;
    static final byte MSG_TYPE_SERVER_START = 6;
    static final byte MSG_TYPE_REPL_SERVER_START = 7;
    static final byte MSG_TYPE_WINDOW = 8;
    static final byte MSG_TYPE_HEARTBEAT = 9;
    static final byte MSG_TYPE_INITIALIZE_REQUEST = 10;
    static final byte MSG_TYPE_INITIALIZE_TARGET = 11;
    static final byte MSG_TYPE_ENTRY = 12;
    static final byte MSG_TYPE_DONE = 13;
    static final byte MSG_TYPE_ERROR = 14;
    static final byte MSG_TYPE_WINDOW_PROBE = 15;
    static final byte MSG_TYPE_REPL_SERVER_INFO = 16;

    public abstract byte[] getBytes() throws UnsupportedEncodingException;

    public static ReplicationMessage generateMsg(byte[] buffer) throws DataFormatException, UnsupportedEncodingException {
        ReplicationMessage msg = null;
        switch (buffer[0]) {
            case 1: {
                msg = new ModifyMsg(buffer);
                break;
            }
            case 2: {
                msg = new AddMsg(buffer);
                break;
            }
            case 3: {
                msg = new DeleteMsg(buffer);
                break;
            }
            case 4: {
                msg = new ModifyDNMsg(buffer);
                break;
            }
            case 5: {
                msg = new AckMessage(buffer);
                break;
            }
            case 6: {
                msg = new ServerStartMessage(buffer);
                break;
            }
            case 7: {
                msg = new ReplServerStartMessage(buffer);
                break;
            }
            case 8: {
                msg = new WindowMessage(buffer);
                break;
            }
            case 9: {
                msg = new HeartbeatMessage(buffer);
                break;
            }
            case 10: {
                msg = new InitializeRequestMessage(buffer);
                break;
            }
            case 11: {
                msg = new InitializeTargetMessage(buffer);
                break;
            }
            case 12: {
                msg = new EntryMessage(buffer);
                break;
            }
            case 13: {
                msg = new DoneMessage(buffer);
                break;
            }
            case 14: {
                msg = new ErrorMessage(buffer);
                break;
            }
            case 15: {
                msg = new WindowProbe(buffer);
                break;
            }
            case 16: {
                msg = new ReplServerInfoMessage(buffer);
                break;
            }
            default: {
                throw new DataFormatException("received message with unknown type");
            }
        }
        return msg;
    }

    protected int addByteArray(byte[] tail, byte[] resultByteArray, int pos) {
        int i = 0;
        while (i < tail.length) {
            resultByteArray[pos] = tail[i];
            ++i;
            ++pos;
        }
        resultByteArray[pos++] = 0;
        return pos;
    }

    protected int getNextLength(byte[] in, int pos) throws DataFormatException {
        int offset = pos;
        int length = 0;
        while (in[offset++] != 0) {
            if (offset >= in.length) {
                throw new DataFormatException("byte[] is not a valid modify msg");
            }
            ++length;
        }
        return length;
    }
}

