/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.protocol.StartMessage;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;

public class ReplServerStartMessage
extends StartMessage
implements Serializable {
    private static final long serialVersionUID = -5871385537169856856L;
    private String baseDn = null;
    private short serverId;
    private String serverURL;
    private ServerState serverState;
    private int windowSize;

    public ReplServerStartMessage(short serverId, String serverURL, DN baseDn, int windowSize, ServerState serverState, short protocolVersion) {
        super(protocolVersion);
        this.serverId = serverId;
        this.serverURL = serverURL;
        this.baseDn = baseDn != null ? baseDn.toNormalizedString() : null;
        this.windowSize = windowSize;
        this.serverState = serverState;
    }

    public ReplServerStartMessage(byte[] in) throws DataFormatException {
        super((byte)7, in);
        try {
            int pos = this.headerLength;
            int length = this.getNextLength(in, pos);
            this.baseDn = new String(in, pos, length, "UTF-8");
            pos += length + 1;
            length = this.getNextLength(in, pos);
            String serverIdString = new String(in, pos, length, "UTF-8");
            this.serverId = Short.valueOf(serverIdString);
            pos += length + 1;
            length = this.getNextLength(in, pos);
            this.serverURL = new String(in, pos, length, "UTF-8");
            pos += length + 1;
            length = this.getNextLength(in, pos);
            this.windowSize = Integer.valueOf(new String(in, pos, length, "UTF-8"));
            this.serverState = new ServerState(in, pos += length + 1, in.length - 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public short getServerId() {
        return this.serverId;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public DN getBaseDn() {
        if (this.baseDn == null) {
            return null;
        }
        try {
            return DN.decode(this.baseDn);
        }
        catch (DirectoryException e) {
            return null;
        }
    }

    public ServerState getServerState() {
        return this.serverState;
    }

    public byte[] getBytes() {
        try {
            byte[] byteDn = this.baseDn.getBytes("UTF-8");
            byte[] byteServerId = String.valueOf(this.serverId).getBytes("UTF-8");
            byte[] byteServerUrl = this.serverURL.getBytes("UTF-8");
            byte[] byteServerState = this.serverState.getBytes();
            byte[] byteWindowSize = String.valueOf(this.windowSize).getBytes("UTF-8");
            int length = byteDn.length + 1 + byteServerId.length + 1 + byteServerUrl.length + 1 + byteWindowSize.length + 1 + byteServerState.length + 1;
            byte[] resultByteArray = this.encodeHeader((byte)7, length);
            int pos = this.headerLength;
            pos = this.addByteArray(byteDn, resultByteArray, pos);
            pos = this.addByteArray(byteServerId, resultByteArray, pos);
            pos = this.addByteArray(byteServerUrl, resultByteArray, pos);
            pos = this.addByteArray(byteWindowSize, resultByteArray, pos);
            pos = this.addByteArray(byteServerState, resultByteArray, pos);
            return resultByteArray;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public int getWindowSize() {
        return this.windowSize;
    }
}

