/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.IOException;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.protocol.HeartbeatMessage;
import org.opends.server.replication.protocol.ProtocolSession;

public class HeartbeatThread
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static boolean heartbeatsDisabled = false;
    private ProtocolSession session;
    private long heartbeatInterval;
    private Boolean shutdown = false;

    public HeartbeatThread(String threadName, ProtocolSession session, long heartbeatInterval) {
        super(threadName);
        this.session = session;
        this.heartbeatInterval = heartbeatInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Heartbeat thread is starting, interval is %d", this.heartbeatInterval);
            }
            HeartbeatMessage heartbeatMessage = new HeartbeatMessage();
            while (!this.shutdown.booleanValue()) {
                long now = System.currentTimeMillis();
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugVerbose("Heartbeat thread awoke at %d, last message was sent at %d", now, this.session.getLastPublishTime());
                }
                if (now > this.session.getLastPublishTime() + this.heartbeatInterval && !heartbeatsDisabled) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugVerbose("Heartbeat sent at %d", now);
                    }
                    this.session.publish(heartbeatMessage);
                }
                try {
                    long sleepTime = this.session.getLastPublishTime() + this.heartbeatInterval - now;
                    if (sleepTime <= 0L) {
                        sleepTime = this.heartbeatInterval;
                    }
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugVerbose("Heartbeat thread sleeping for %d", sleepTime);
                    }
                    Boolean bl = this.shutdown;
                    synchronized (bl) {
                        if (!this.shutdown.booleanValue()) {
                            this.shutdown.wait(sleepTime);
                        }
                    }
                }
                catch (InterruptedException e) {
                }
            }
        }
        catch (IOException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Heartbeat thread could not send a heartbeat.");
            }
        }
        finally {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Heartbeat thread is exiting.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Boolean bl = this.shutdown;
        synchronized (bl) {
            this.shutdown.notifyAll();
            this.shutdown = true;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Going to notify Heartbeat thread.");
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning from Heartbeat shutdown.");
        }
    }

    public static void setHeartbeatsDisabled(boolean heartbeatsDisabled) {
        HeartbeatThread.heartbeatsDisabled = heartbeatsDisabled;
    }
}

