/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.replication.protocol.RoutableMessage;

public class ErrorMessage
extends RoutableMessage
implements Serializable {
    private static final long serialVersionUID = 2726389860247088266L;
    private int msgID;
    private String details = null;

    public ErrorMessage(short sender, short destination, int msgID, String details) {
        super(sender, destination);
        this.msgID = msgID;
        this.details = details;
    }

    public ErrorMessage(short destination, int msgID, String details) {
        super((short)-2, destination);
        this.msgID = msgID;
        this.details = details;
    }

    public ErrorMessage(byte[] in) throws DataFormatException {
        try {
            if (in[0] != 14) {
                throw new DataFormatException("input is not a valid InitializeMessage");
            }
            int pos = 1;
            int length = this.getNextLength(in, pos);
            String senderString = new String(in, pos, length, "UTF-8");
            this.senderID = Short.valueOf(senderString);
            pos += length + 1;
            length = this.getNextLength(in, pos);
            String serverIdString = new String(in, pos, length, "UTF-8");
            this.destination = Short.valueOf(serverIdString);
            pos += length + 1;
            length = this.getNextLength(in, pos);
            String msgIdString = new String(in, pos, length, "UTF-8");
            this.msgID = Integer.valueOf(msgIdString);
            pos += length + 1;
            length = this.getNextLength(in, pos);
            this.details = new String(in, pos, length, "UTF-8");
            pos += length + 1;
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public String getDetails() {
        return this.details;
    }

    public int getMsgID() {
        return this.msgID;
    }

    public byte[] getBytes() {
        try {
            byte[] byteSender = String.valueOf(this.senderID).getBytes("UTF-8");
            byte[] byteDestination = String.valueOf(this.destination).getBytes("UTF-8");
            byte[] byteErrMsgId = String.valueOf(this.msgID).getBytes("UTF-8");
            byte[] byteDetails = this.details.getBytes("UTF-8");
            int length = 1 + byteSender.length + 1 + byteDestination.length + 1 + byteErrMsgId.length + 1 + byteDetails.length + 1;
            byte[] resultByteArray = new byte[length];
            resultByteArray[0] = 14;
            int pos = 1;
            pos = this.addByteArray(byteSender, resultByteArray, pos);
            pos = this.addByteArray(byteDestination, resultByteArray, pos);
            pos = this.addByteArray(byteErrMsgId, resultByteArray, pos);
            pos = this.addByteArray(byteDetails, resultByteArray, pos);
            return resultByteArray;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

