/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ChangeNumberGenerator;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.plugin.PendingChange;
import org.opends.server.replication.protocol.AddMsg;
import org.opends.server.replication.protocol.DeleteMsg;
import org.opends.server.replication.protocol.ModifyDNMsg;
import org.opends.server.replication.protocol.OperationContext;
import org.opends.server.replication.protocol.UpdateMessage;
import org.opends.server.types.DN;

public class RemotePendingChanges {
    private SortedMap<ChangeNumber, PendingChange> pendingChanges = new TreeMap<ChangeNumber, PendingChange>();
    private SortedSet<PendingChange> dependentChanges = new TreeSet<PendingChange>();
    private ServerState state;
    private ChangeNumberGenerator changeNumberGenerator;

    public RemotePendingChanges(ChangeNumberGenerator changeNumberGenerator, ServerState state) {
        this.changeNumberGenerator = changeNumberGenerator;
        this.state = state;
    }

    public synchronized void putRemoteUpdate(UpdateMessage update) {
        ChangeNumber changeNumber = update.getChangeNumber();
        this.changeNumberGenerator.adjust(changeNumber);
        this.pendingChanges.put(changeNumber, new PendingChange(changeNumber, null, update));
    }

    public synchronized void commit(ChangeNumber changeNumber) {
        PendingChange curChange = (PendingChange)this.pendingChanges.get(changeNumber);
        if (curChange == null) {
            throw new NoSuchElementException();
        }
        curChange.setCommitted(true);
        ChangeNumber firstChangeNumber = this.pendingChanges.firstKey();
        PendingChange firstChange = (PendingChange)this.pendingChanges.get(firstChangeNumber);
        while (firstChange != null && firstChange.isCommitted()) {
            this.state.update(firstChangeNumber);
            this.pendingChanges.remove(firstChangeNumber);
            if (this.pendingChanges.isEmpty()) {
                firstChange = null;
                continue;
            }
            firstChangeNumber = this.pendingChanges.firstKey();
            firstChange = (PendingChange)this.pendingChanges.get(firstChangeNumber);
        }
    }

    public synchronized UpdateMessage getNextUpdate() {
        for (PendingChange change : this.dependentChanges) {
            if (!change.dependenciesIsCovered(this.state)) continue;
            this.dependentChanges.remove(change);
            return change.getMsg();
        }
        return null;
    }

    private void addDependency(PendingChange dependentChange, PendingChange pendingChange) {
        dependentChange.addDependency(pendingChange.getChangeNumber());
        this.dependentChanges.add(dependentChange);
    }

    public synchronized boolean checkDependencies(AddOperation op) {
        boolean hasDependencies = false;
        DN targetDn = op.getEntryDN();
        ChangeNumber changeNumber = OperationContext.getChangeNumber(op);
        PendingChange change = (PendingChange)this.pendingChanges.get(changeNumber);
        if (change == null) {
            return false;
        }
        for (PendingChange pendingChange : this.pendingChanges.values()) {
            UpdateMessage pendingMsg;
            if (!pendingChange.getChangeNumber().older(changeNumber).booleanValue() || (pendingMsg = pendingChange.getMsg()) == null) continue;
            if (pendingMsg instanceof DeleteMsg) {
                if (!pendingChange.getTargetDN().equals(targetDn)) continue;
                hasDependencies = true;
                this.addDependency(change, pendingChange);
                continue;
            }
            if (pendingMsg instanceof AddMsg) {
                if (!pendingChange.getTargetDN().isAncestorOf(targetDn)) continue;
                hasDependencies = true;
                this.addDependency(change, pendingChange);
                continue;
            }
            if (!(pendingMsg instanceof ModifyDNMsg)) continue;
            if (pendingChange.getTargetDN().equals(targetDn)) {
                hasDependencies = true;
                this.addDependency(change, pendingChange);
                continue;
            }
            ModifyDNMsg pendingModDn = (ModifyDNMsg)pendingChange.getMsg();
            if (!pendingModDn.newDNIsParent(targetDn)) continue;
            hasDependencies = true;
            this.addDependency(change, pendingChange);
        }
        return hasDependencies;
    }

    public synchronized boolean checkDependencies(ModifyOperation op) {
        boolean hasDependencies = false;
        DN targetDn = op.getEntryDN();
        ChangeNumber changeNumber = OperationContext.getChangeNumber(op);
        PendingChange change = (PendingChange)this.pendingChanges.get(changeNumber);
        if (change == null) {
            return false;
        }
        for (PendingChange pendingChange : this.pendingChanges.values()) {
            UpdateMessage pendingMsg;
            if (!pendingChange.getChangeNumber().older(changeNumber).booleanValue() || (pendingMsg = pendingChange.getMsg()) == null || !(pendingMsg instanceof AddMsg) || !pendingChange.getTargetDN().equals(targetDn)) continue;
            hasDependencies = true;
            this.addDependency(change, pendingChange);
        }
        return hasDependencies;
    }

    public synchronized boolean checkDependencies(ModifyDNMsg msg) {
        boolean hasDependencies = false;
        ChangeNumber changeNumber = msg.getChangeNumber();
        PendingChange change = (PendingChange)this.pendingChanges.get(changeNumber);
        if (change == null) {
            return false;
        }
        DN targetDn = change.getTargetDN();
        for (PendingChange pendingChange : this.pendingChanges.values()) {
            UpdateMessage pendingMsg;
            if (!pendingChange.getChangeNumber().older(changeNumber).booleanValue() || (pendingMsg = pendingChange.getMsg()) == null) continue;
            if (pendingMsg instanceof DeleteMsg) {
                if (!msg.newDNIsEqual(pendingChange.getTargetDN())) continue;
                hasDependencies = true;
                this.addDependency(change, pendingChange);
                continue;
            }
            if (pendingMsg instanceof AddMsg) {
                if (msg.newParentIsEqual(pendingChange.getTargetDN())) {
                    hasDependencies = true;
                    this.addDependency(change, pendingChange);
                }
                if (!pendingChange.getTargetDN().equals(targetDn)) continue;
                hasDependencies = true;
                this.addDependency(change, pendingChange);
                continue;
            }
            if (!(pendingMsg instanceof ModifyDNMsg) || !msg.newDNIsEqual(pendingChange.getTargetDN())) continue;
            hasDependencies = true;
            this.addDependency(change, pendingChange);
        }
        return hasDependencies;
    }

    public synchronized boolean checkDependencies(DeleteOperation op) {
        boolean hasDependencies = false;
        DN targetDn = op.getEntryDN();
        ChangeNumber changeNumber = OperationContext.getChangeNumber(op);
        PendingChange change = (PendingChange)this.pendingChanges.get(changeNumber);
        if (change == null) {
            return false;
        }
        for (PendingChange pendingChange : this.pendingChanges.values()) {
            UpdateMessage pendingMsg;
            if (!pendingChange.getChangeNumber().older(changeNumber).booleanValue() || (pendingMsg = pendingChange.getMsg()) == null) continue;
            if (pendingMsg instanceof DeleteMsg) {
                if (!pendingChange.getTargetDN().isDescendantOf(targetDn)) continue;
                hasDependencies = true;
                this.addDependency(change, pendingChange);
                continue;
            }
            if (pendingMsg instanceof AddMsg) {
                if (!pendingChange.getTargetDN().equals(targetDn)) continue;
                hasDependencies = true;
                this.addDependency(change, pendingChange);
                continue;
            }
            if (!(pendingMsg instanceof ModifyDNMsg) || !pendingChange.getTargetDN().isDescendantOf(targetDn)) continue;
            hasDependencies = true;
            this.addDependency(change, pendingChange);
        }
        return hasDependencies;
    }
}

