/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyOperationBasis;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ServerState;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.LDAPException;
import org.opends.server.types.ModificationType;
import org.opends.server.types.RawModification;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;

public class PersistentServerState
extends ServerState {
    private DN baseDn;
    private boolean savedStatus = true;
    private InternalClientConnection conn = InternalClientConnection.getRootConnection();
    private ASN1OctetString asn1BaseDn;
    protected static final String REPLICATION_STATE = "ds-sync-state";

    public PersistentServerState(DN baseDn) {
        this.baseDn = baseDn;
        this.asn1BaseDn = new ASN1OctetString(baseDn.toString());
        this.loadState();
    }

    public boolean update(ChangeNumber changeNumber) {
        this.savedStatus = false;
        return super.update(changeNumber);
    }

    public void save() {
        if (this.savedStatus) {
            return;
        }
        this.savedStatus = true;
        ResultCode resultCode = this.updateStateEntry();
        if (resultCode != ResultCode.SUCCESS) {
            this.savedStatus = false;
        }
    }

    public void loadState() {
        AttributeType synchronizationStateType;
        List<Attribute> attrs;
        LinkedList<SearchResultEntry> result;
        LDAPFilter filter;
        try {
            filter = LDAPFilter.decode("objectclass=*");
        }
        catch (LDAPException e) {
            return;
        }
        LinkedHashSet<String> attributes = new LinkedHashSet<String>(1);
        attributes.add(REPLICATION_STATE);
        InternalSearchOperation search = this.conn.processSearch(this.asn1BaseDn, SearchScope.BASE_OBJECT, DereferencePolicy.DEREF_ALWAYS, 0, 0, false, filter, attributes);
        if (search.getResultCode() != ResultCode.SUCCESS && search.getResultCode() != ResultCode.NO_SUCH_OBJECT) {
            int msgID = 14876687;
            String message = MessageHandler.getMessage(msgID, search.getResultCode().getResultCodeName(), search.toString(), search.getErrorMessage(), this.baseDn.toString());
            ErrorLogger.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
        }
        SearchResultEntry resultEntry = null;
        if (search.getResultCode() == ResultCode.SUCCESS && (resultEntry = (result = search.getSearchEntries()).getFirst()) != null && (attrs = resultEntry.getAttribute(synchronizationStateType = DirectoryServer.getAttributeType(REPLICATION_STATE))) != null) {
            Attribute attr = attrs.get(0);
            LinkedHashSet<AttributeValue> values = attr.getValues();
            for (AttributeValue value : values) {
                ChangeNumber changeNumber = new ChangeNumber(value.getStringValue());
                this.update(changeNumber);
            }
        }
    }

    private ResultCode updateStateEntry() {
        ArrayList<ASN1OctetString> values = this.toASN1ArrayList();
        if (values.size() == 0) {
            return ResultCode.SUCCESS;
        }
        LDAPAttribute attr = new LDAPAttribute(REPLICATION_STATE, values);
        LDAPModification mod = new LDAPModification(ModificationType.REPLACE, attr);
        ArrayList<RawModification> mods = new ArrayList<RawModification>(1);
        mods.add(mod);
        ModifyOperationBasis op = new ModifyOperationBasis((ClientConnection)this.conn, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), new ArrayList<Control>(0), this.asn1BaseDn, mods);
        op.setInternalOperation(true);
        op.setSynchronizationOperation(true);
        op.setDontSynchronize(true);
        op.run();
        ResultCode result = op.getResultCode();
        if (result != ResultCode.SUCCESS) {
            int msgID = 0xE3000E;
            String message = MessageHandler.getMessage(msgID, op.getResultCode().getResultCodeName(), op.toString(), op.getErrorMessage(), this.baseDn.toString(), Thread.currentThread().getStackTrace());
            ErrorLogger.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
        }
        return result;
    }
}

