/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.util.LinkedHashSet;
import java.util.Set;
import org.opends.server.core.DirectoryServer;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.plugin.HistKey;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistVal {
    private AttributeType attrType;
    private String attrString;
    private AttributeValue attributeValue;
    private ChangeNumber cn;
    private LinkedHashSet<String> options;
    private HistKey histKey;
    private String stringValue;

    public HistVal(String strVal) {
        String[] token = strVal.split(":", 4);
        this.options = new LinkedHashSet();
        if (token[0].contains(";")) {
            String[] optionsToken = token[0].split(";");
            for (int index = 1; index < optionsToken.length; ++index) {
                this.options.add(optionsToken[index]);
            }
            this.attrString = optionsToken[0];
        } else {
            this.attrString = token[0];
        }
        this.attrType = DirectoryServer.getSchema().getAttributeType(this.attrString);
        this.cn = new ChangeNumber(token[1]);
        this.histKey = HistKey.decodeKey(token[2]);
        this.stringValue = null;
        if (this.histKey != HistKey.DELATTR) {
            if (token.length == 4) {
                this.stringValue = token[3];
                this.attributeValue = new AttributeValue(this.attrType, this.stringValue);
            } else {
                this.attributeValue = null;
            }
        } else {
            this.stringValue = null;
            this.attributeValue = null;
        }
    }

    public String getAttrString() {
        return this.attrString;
    }

    public AttributeType getAttrType() {
        return this.attrType;
    }

    public ChangeNumber getCn() {
        return this.cn;
    }

    public HistKey getHistKey() {
        return this.histKey;
    }

    public Set<String> getOptions() {
        return this.options;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public AttributeValue getAttributeValue() {
        return this.attributeValue;
    }

    public Modification generateMod() {
        Modification mod;
        Attribute attr = new Attribute(this.attrType, this.attrString, this.options, null);
        if (this.histKey != HistKey.DELATTR) {
            LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>(1);
            values.add(this.attributeValue);
            attr.setValues(values);
        }
        switch (this.histKey) {
            case ADD: {
                mod = new Modification(ModificationType.ADD, attr);
                break;
            }
            case DEL: {
                mod = new Modification(ModificationType.DELETE, attr);
                break;
            }
            case REPL: {
                mod = new Modification(ModificationType.REPLACE, attr);
                break;
            }
            case DELATTR: {
                mod = new Modification(ModificationType.DELETE, attr);
                break;
            }
            default: {
                mod = null;
            }
        }
        return mod;
    }
}

