/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.io.IOException;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.protocol.ProtocolSession;

public class HeartbeatMonitor
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ProtocolSession session;
    private long heartbeatInterval;
    private boolean shutdown = false;

    public HeartbeatMonitor(String threadName, ProtocolSession session, long heartbeatInterval) {
        super(threadName);
        this.session = session;
        this.heartbeatInterval = heartbeatInterval;
    }

    public void shutdown() {
        this.shutdown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block13: {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Heartbeat monitor is starting, expected interval is %d", this.heartbeatInterval);
            }
            block7: while (true) {
                try {
                    while (!this.shutdown) {
                        long lastReceiveTime;
                        long now = System.currentTimeMillis();
                        if (now > (lastReceiveTime = this.session.getLastReceiveTime()) + 2L * this.heartbeatInterval) {
                            TRACER.debugInfo("Heartbeat monitor is closing the broker session because it could not detect a heartbeat.");
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugInfo("Heartbeat monitor is closing the broker session because it could not detect a heartbeat.");
                            }
                            this.session.close();
                            break block13;
                        }
                        try {
                            Thread.sleep(this.heartbeatInterval);
                            continue block7;
                        }
                        catch (InterruptedException e) {
                        }
                    }
                    break block13;
                }
                catch (IOException iOException) {
                    break block13;
                }
            }
            finally {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Heartbeat monitor is exiting.");
                }
            }
        }
    }
}

