/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.common;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.DataFormatException;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.replication.common.ChangeNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerState
implements Iterable<Short> {
    private HashMap<Short, ChangeNumber> list;

    public ServerState() {
        this.list = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ServerState serverState = this;
        synchronized (serverState) {
            this.list.clear();
        }
    }

    public ServerState(byte[] in, int pos, int endpos) throws DataFormatException {
        try {
            this.list = new HashMap();
            while (endpos > pos) {
                int length = this.getNextLength(in, pos);
                String serverIdString = new String(in, pos, length, "UTF-8");
                short serverId = Short.valueOf(serverIdString);
                pos += length + 1;
                length = this.getNextLength(in, pos);
                String cnString = new String(in, pos, length, "UTF-8");
                ChangeNumber cn = new ChangeNumber(cnString);
                pos += length + 1;
                this.list.put(serverId, cn);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    private int getNextLength(byte[] in, int pos) throws DataFormatException {
        int offset = pos;
        int length = 0;
        while (in[offset++] != 0) {
            if (offset >= in.length) {
                throw new DataFormatException("byte[] is not a valid modify msg");
            }
            ++length;
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(ChangeNumber changeNumber) {
        if (changeNumber == null) {
            return false;
        }
        ServerState serverState = this;
        synchronized (serverState) {
            Short id = changeNumber.getServerId();
            ChangeNumber oldCN = this.list.get(id);
            if (oldCN == null || changeNumber.newer(oldCN)) {
                this.list.put(id, changeNumber);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> toStringSet() {
        HashSet<String> set = new HashSet<String>();
        ServerState serverState = this;
        synchronized (serverState) {
            for (Short key : this.list.keySet()) {
                ChangeNumber change = this.list.get(key);
                Date date = new Date(change.getTime());
                set.add(change.toString() + " " + date.toString());
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ASN1OctetString> toASN1ArrayList() {
        ArrayList<ASN1OctetString> values = new ArrayList<ASN1OctetString>();
        ServerState serverState = this;
        synchronized (serverState) {
            for (Short id : this.list.keySet()) {
                ASN1OctetString value = new ASN1OctetString(this.list.get(id).toString());
                values.add(value);
            }
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        ServerState serverState = this;
        synchronized (serverState) {
            for (Short key : this.list.keySet()) {
                ChangeNumber change = this.list.get(key);
                buffer.append(" ");
                buffer.append(change);
            }
        }
        return buffer.toString();
    }

    public ChangeNumber getMaxChangeNumber(short serverId) {
        return this.list.get(serverId);
    }

    private int addByteArray(byte[] tail, byte[] resultByteArray, int pos) {
        int i = 0;
        while (i < tail.length) {
            resultByteArray[pos] = tail[i];
            ++i;
            ++pos;
        }
        resultByteArray[pos++] = 0;
        return pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() throws UnsupportedEncodingException {
        ServerState serverState = this;
        synchronized (serverState) {
            int length = 0;
            ArrayList<String> idList = new ArrayList<String>(this.list.size());
            for (short id : this.list.keySet()) {
                String temp = String.valueOf(id);
                idList.add(temp);
                length += temp.length() + 1;
            }
            ArrayList<String> cnList = new ArrayList<String>(this.list.size());
            for (ChangeNumber cn : this.list.values()) {
                String temp = cn.toString();
                cnList.add(temp);
                length += temp.length() + 1;
            }
            byte[] result = new byte[length];
            int pos = 0;
            for (int i = 0; i < this.list.size(); ++i) {
                String str = (String)idList.get(i);
                pos = this.addByteArray(str.getBytes("UTF-8"), result, pos);
                str = (String)cnList.get(i);
                pos = this.addByteArray(str.getBytes("UTF-8"), result, pos);
            }
            return result;
        }
    }

    @Override
    public Iterator<Short> iterator() {
        return this.list.keySet().iterator();
    }

    public boolean cover(ServerState covered) {
        for (ChangeNumber coveredChange : covered.list.values()) {
            ChangeNumber change = this.list.get(coveredChange.getServerId());
            if (change != null && !change.older(coveredChange).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

