/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.Entry;
import org.opends.server.types.LDAPException;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.util.Base64;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResultEntryProtocolOp
extends ProtocolOp {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private LinkedList<LDAPAttribute> attributes;
    private DN dn;

    public SearchResultEntryProtocolOp(DN dn) {
        this.dn = dn;
        this.attributes = new LinkedList();
    }

    public SearchResultEntryProtocolOp(DN dn, LinkedList<LDAPAttribute> attributes) {
        this.dn = dn;
        this.attributes = attributes == null ? new LinkedList() : attributes;
    }

    public SearchResultEntryProtocolOp(SearchResultEntry searchEntry) {
        this.dn = searchEntry.getDN();
        this.attributes = new LinkedList();
        Attribute ocAttr = searchEntry.getObjectClassAttribute();
        if (ocAttr != null) {
            this.attributes.add(new LDAPAttribute(ocAttr));
        }
        for (List<Attribute> attrList : searchEntry.getUserAttributes().values()) {
            for (Attribute a : attrList) {
                this.attributes.add(new LDAPAttribute(a));
            }
        }
        for (List<Attribute> attrList : searchEntry.getOperationalAttributes().values()) {
            for (Attribute a : attrList) {
                this.attributes.add(new LDAPAttribute(a));
            }
        }
    }

    public DN getDN() {
        return this.dn;
    }

    public void setDN(DN dn) {
        this.dn = dn;
    }

    public LinkedList<LDAPAttribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public byte getType() {
        return 100;
    }

    @Override
    public String getProtocolOpName() {
        return "Search Result Entry";
    }

    @Override
    public ASN1Element encode() {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
        elements.add(new ASN1OctetString(this.dn.toString()));
        ArrayList<ASN1Element> attrElements = new ArrayList<ASN1Element>(this.attributes.size());
        for (LDAPAttribute attr : this.attributes) {
            attrElements.add(attr.encode());
        }
        elements.add(new ASN1Sequence(attrElements));
        return new ASN1Sequence(100, elements);
    }

    public static SearchResultEntryProtocolOp decodeSearchEntry(ASN1Element element) throws LDAPException {
        LinkedList<LDAPAttribute> attributes;
        DN dn;
        ArrayList<ASN1Element> elements;
        try {
            elements = element.decodeAsSequence().elements();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293878;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        int numElements = elements.size();
        if (numElements != 2) {
            int msgID = 2293879;
            String message = MessageHandler.getMessage(msgID, numElements);
            throw new LDAPException(2, msgID, message);
        }
        try {
            dn = DN.decode(elements.get(0).decodeAsOctetString().stringValue());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293880;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        try {
            ArrayList<ASN1Element> attrElements = elements.get(1).decodeAsSequence().elements();
            attributes = new LinkedList<LDAPAttribute>();
            for (ASN1Element e : attrElements) {
                attributes.add(LDAPAttribute.decode(e));
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293881;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        return new SearchResultEntryProtocolOp(dn, attributes);
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("SearchResultEntry(dn=");
        this.dn.toString(buffer);
        buffer.append(", attrs={");
        if (!this.attributes.isEmpty()) {
            Iterator iterator = this.attributes.iterator();
            ((LDAPAttribute)iterator.next()).toString(buffer);
            while (iterator.hasNext()) {
                buffer.append(", ");
                ((LDAPAttribute)iterator.next()).toString(buffer);
            }
        }
        buffer.append("})");
    }

    @Override
    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("Search Result Entry");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  DN:  ");
        this.dn.toString(buffer);
        buffer.append(ServerConstants.EOL);
        buffer.append("  Attributes:");
        buffer.append(ServerConstants.EOL);
        for (LDAPAttribute attribute : this.attributes) {
            attribute.toString(buffer, indent + 4);
        }
    }

    public void toLDIF(StringBuilder buffer, int wrapColumn) {
        int colsRemaining;
        String dnString = this.dn.toString();
        if (StaticUtils.needsBase64Encoding(dnString)) {
            dnString = Base64.encode(StaticUtils.getBytes(dnString));
            buffer.append("dn:: ");
            colsRemaining = wrapColumn - 5;
        } else {
            buffer.append("dn: ");
            colsRemaining = wrapColumn - 4;
        }
        int dnLength = dnString.length();
        if (dnLength <= colsRemaining || colsRemaining <= 0) {
            buffer.append(dnString);
            buffer.append(ServerConstants.EOL);
        } else {
            buffer.append(dnString.substring(0, colsRemaining));
            buffer.append(ServerConstants.EOL);
            int startPos = colsRemaining;
            while (dnLength - startPos > wrapColumn - 1) {
                buffer.append(" ");
                buffer.append(dnString.substring(startPos, startPos + wrapColumn - 1));
                buffer.append(ServerConstants.EOL);
                startPos += wrapColumn - 1;
            }
            if (startPos < dnLength) {
                buffer.append(" ");
                buffer.append(dnString.substring(startPos));
                buffer.append(ServerConstants.EOL);
            }
        }
        for (LDAPAttribute a : this.attributes) {
            String name = a.getAttributeType();
            int nameLength = name.length();
            for (ASN1OctetString v : a.getValues()) {
                String valueString;
                if (StaticUtils.needsBase64Encoding(v.value())) {
                    valueString = Base64.encode(v.value());
                    buffer.append(name);
                    buffer.append(":: ");
                    colsRemaining = wrapColumn - nameLength - 3;
                } else {
                    valueString = v.stringValue();
                    buffer.append(name);
                    buffer.append(": ");
                    colsRemaining = wrapColumn - nameLength - 2;
                }
                int valueLength = valueString.length();
                if (valueLength <= colsRemaining || colsRemaining <= 0) {
                    buffer.append(valueString);
                    buffer.append(ServerConstants.EOL);
                    continue;
                }
                buffer.append(valueString.substring(0, colsRemaining));
                buffer.append(ServerConstants.EOL);
                int startPos = colsRemaining;
                while (valueLength - startPos > wrapColumn - 1) {
                    buffer.append(" ");
                    buffer.append(valueString.substring(startPos, startPos + wrapColumn - 1));
                    buffer.append(ServerConstants.EOL);
                    startPos += wrapColumn - 1;
                }
                if (startPos >= valueLength) continue;
                buffer.append(" ");
                buffer.append(valueString.substring(startPos));
                buffer.append(ServerConstants.EOL);
            }
        }
        buffer.append(ServerConstants.EOL);
    }

    public SearchResultEntry toSearchResultEntry() throws LDAPException {
        HashMap<ObjectClass, String> objectClasses = new HashMap<ObjectClass, String>();
        HashMap<AttributeType, List<Attribute>> userAttributes = new HashMap<AttributeType, List<Attribute>>();
        HashMap<AttributeType, List<Attribute>> operationalAttributes = new HashMap<AttributeType, List<Attribute>>();
        for (LDAPAttribute a : this.attributes) {
            List<Attribute> attrs;
            Attribute attr = a.toAttribute();
            AttributeType attrType = attr.getAttributeType();
            if (attrType.isObjectClassType()) {
                for (ASN1OctetString os : a.getValues()) {
                    String ocName = os.toString();
                    ObjectClass oc = DirectoryServer.getObjectClass(StaticUtils.toLowerCase(ocName));
                    if (oc == null) {
                        oc = DirectoryServer.getDefaultObjectClass(ocName);
                    }
                    objectClasses.put(oc, ocName);
                }
                continue;
            }
            if (attrType.isOperational()) {
                attrs = operationalAttributes.get(attrType);
                if (attrs == null) {
                    attrs = new ArrayList<Attribute>(1);
                    attrs.add(attr);
                    operationalAttributes.put(attrType, attrs);
                    continue;
                }
                attrs.add(attr);
                continue;
            }
            attrs = userAttributes.get(attrType);
            if (attrs == null) {
                attrs = new ArrayList<Attribute>(1);
                attrs.add(attr);
                userAttributes.put(attrType, attrs);
                continue;
            }
            boolean attributeSeen = false;
            for (Attribute ea : attrs) {
                if (!ea.optionsEqual(attr.getOptions())) continue;
                LinkedHashSet<AttributeValue> valueSet = ea.getValues();
                valueSet.addAll(attr.getValues());
                attributeSeen = true;
            }
            if (attributeSeen) continue;
            attrs.add(attr);
        }
        Entry entry = new Entry(this.dn, objectClasses, userAttributes, operationalAttributes);
        return new SearchResultEntry(entry);
    }
}

