/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.util.ServerConstants;

public class DeleteRequestProtocolOp
extends ProtocolOp {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ASN1OctetString dn;

    public DeleteRequestProtocolOp(ASN1OctetString dn) {
        this.dn = dn;
    }

    public ASN1OctetString getDN() {
        return this.dn;
    }

    public void setDN(ASN1OctetString dn) {
        this.dn = dn;
    }

    public byte getType() {
        return 74;
    }

    public String getProtocolOpName() {
        return "Delete Request";
    }

    public ASN1Element encode() {
        this.dn.setType((byte)74);
        return this.dn;
    }

    public static DeleteRequestProtocolOp decodeDeleteRequest(ASN1Element element) throws LDAPException {
        try {
            return new DeleteRequestProtocolOp(element.decodeAsOctetString());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293850;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
    }

    public void toString(StringBuilder buffer) {
        buffer.append("DeleteRequest(dn=");
        this.dn.toString(buffer);
        buffer.append(")");
    }

    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("Delete Request");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Entry DN:  ");
        this.dn.toString(buffer);
        buffer.append(ServerConstants.EOL);
    }
}

