/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.util.ServerConstants;

public class CompareRequestProtocolOp
extends ProtocolOp {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ASN1OctetString assertionValue;
    private ASN1OctetString dn;
    private String attributeType;

    public CompareRequestProtocolOp(ASN1OctetString dn, String attributeType, ASN1OctetString assertionValue) {
        this.dn = dn;
        this.attributeType = attributeType;
        this.assertionValue = assertionValue;
    }

    public ASN1OctetString getDN() {
        return this.dn;
    }

    public void setDN(ASN1OctetString dn) {
        this.dn = dn;
    }

    public String getAttributeType() {
        return this.attributeType;
    }

    public void setAttributeType(String attributeType) {
        this.attributeType = attributeType;
    }

    public ASN1OctetString getAssertionValue() {
        return this.assertionValue;
    }

    public void setAssertionValue(ASN1OctetString assertionValue) {
        this.assertionValue = assertionValue;
    }

    public byte getType() {
        return 110;
    }

    public String getProtocolOpName() {
        return "Compare Request";
    }

    public ASN1Element encode() {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
        elements.add(this.dn);
        ArrayList<ASN1Element> avaElements = new ArrayList<ASN1Element>(2);
        avaElements.add(new ASN1OctetString(this.attributeType));
        avaElements.add(this.assertionValue);
        elements.add(new ASN1Sequence(avaElements));
        return new ASN1Sequence(110, elements);
    }

    public static CompareRequestProtocolOp decodeCompareRequest(ASN1Element element) throws LDAPException {
        ASN1OctetString assertionValue;
        String attributeType;
        ArrayList<ASN1Element> avaElements;
        ASN1OctetString dn;
        ArrayList<ASN1Element> elements;
        try {
            elements = element.decodeAsSequence().elements();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293843;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        int numElements = elements.size();
        if (numElements != 2) {
            int msgID = 2293844;
            String message = MessageHandler.getMessage(msgID, numElements);
            throw new LDAPException(2, msgID, message);
        }
        try {
            dn = elements.get(0).decodeAsOctetString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293845;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        try {
            avaElements = elements.get(1).decodeAsSequence().elements();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293846;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        numElements = avaElements.size();
        if (numElements != 2) {
            int msgID = 2293847;
            String message = MessageHandler.getMessage(msgID, numElements);
            throw new LDAPException(2, msgID, message);
        }
        try {
            attributeType = avaElements.get(0).decodeAsOctetString().stringValue();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293848;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        try {
            assertionValue = avaElements.get(1).decodeAsOctetString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293849;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        return new CompareRequestProtocolOp(dn, attributeType, assertionValue);
    }

    public void toString(StringBuilder buffer) {
        buffer.append("CompareRequest(dn=");
        this.dn.toString(buffer);
        buffer.append(", attribute=");
        buffer.append(this.attributeType);
        buffer.append(", value=");
        this.assertionValue.toString(buffer);
        buffer.append(")");
    }

    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("Compare Request");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Target DN:  ");
        this.dn.toString(buffer);
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Attribute Type:  ");
        buffer.append(this.attributeType);
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Assertion Value:");
        buffer.append(ServerConstants.EOL);
        this.assertionValue.toString(buffer, indent + 4);
    }
}

