/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Integer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.AuthenticationType;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.util.ServerConstants;

public class BindRequestProtocolOp
extends ProtocolOp {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ASN1OctetString dn;
    private ASN1OctetString saslCredentials;
    private ASN1OctetString simplePassword;
    private AuthenticationType authenticationType;
    private int protocolVersion;
    private String saslMechanism;

    public BindRequestProtocolOp(ASN1OctetString dn, int protocolVersion, ASN1OctetString simplePassword) {
        this.dn = dn;
        this.protocolVersion = protocolVersion;
        this.simplePassword = simplePassword;
        this.authenticationType = AuthenticationType.SIMPLE;
        this.saslMechanism = null;
        this.saslCredentials = null;
    }

    public BindRequestProtocolOp(ASN1OctetString dn, String saslMechanism, ASN1OctetString saslCredentials) {
        this.dn = dn;
        this.saslMechanism = saslMechanism;
        this.saslCredentials = saslCredentials;
        this.authenticationType = AuthenticationType.SASL;
        this.protocolVersion = 3;
        this.simplePassword = null;
    }

    private BindRequestProtocolOp(ASN1OctetString dn, int protocolVersion, AuthenticationType authenticationType, ASN1OctetString simplePassword, String saslMechanism, ASN1OctetString saslCredentials) {
        this.dn = dn;
        this.protocolVersion = protocolVersion;
        this.authenticationType = authenticationType;
        this.simplePassword = simplePassword;
        this.saslMechanism = saslMechanism;
        this.saslCredentials = saslCredentials;
    }

    public ASN1OctetString getDN() {
        return this.dn;
    }

    public void setDN(ASN1OctetString dn) {
        this.dn = dn;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public ASN1OctetString getSimplePassword() {
        return this.simplePassword;
    }

    public void setSimplePassword(ASN1OctetString simplePassword) {
        this.simplePassword = simplePassword;
        this.authenticationType = AuthenticationType.SIMPLE;
        this.saslMechanism = null;
        this.saslCredentials = null;
    }

    public String getSASLMechanism() {
        return this.saslMechanism;
    }

    public ASN1OctetString getSASLCredentials() {
        return this.saslCredentials;
    }

    public void setSASLAuthenticationInfo(String saslMechanism, ASN1OctetString saslCredentials) {
        this.saslMechanism = saslMechanism;
        this.saslCredentials = saslCredentials;
        this.authenticationType = AuthenticationType.SASL;
        this.simplePassword = null;
    }

    public byte getType() {
        return 96;
    }

    public String getProtocolOpName() {
        return "Bind Request";
    }

    public ASN1Element encode() {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(3);
        elements.add(new ASN1Integer(this.protocolVersion));
        elements.add(this.dn);
        if (this.authenticationType == AuthenticationType.SIMPLE) {
            this.simplePassword.setType((byte)-128);
            elements.add(this.simplePassword);
        } else {
            ArrayList<ASN1Element> saslElements = new ArrayList<ASN1Element>(2);
            saslElements.add(new ASN1OctetString(this.saslMechanism));
            if (this.saslCredentials != null) {
                saslElements.add(this.saslCredentials);
            }
            elements.add(new ASN1Sequence(-93, saslElements));
        }
        return new ASN1Sequence(96, elements);
    }

    public static BindRequestProtocolOp decodeBindRequest(ASN1Element element) throws LDAPException {
        AuthenticationType authenticationType;
        ASN1OctetString dn;
        int protocolVersion;
        ArrayList<ASN1Element> elements;
        try {
            elements = element.decodeAsSequence().elements();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293835;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        int numElements = elements.size();
        if (numElements != 3) {
            int msgID = 2293836;
            String message = MessageHandler.getMessage(msgID, String.valueOf(numElements));
            throw new LDAPException(2, msgID, message);
        }
        try {
            protocolVersion = elements.get(0).decodeAsInteger().intValue();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293837;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        try {
            dn = elements.get(1).decodeAsOctetString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293838;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        ASN1OctetString simplePassword = null;
        String saslMechanism = null;
        ASN1OctetString saslCredentials = null;
        try {
            element = elements.get(2);
            switch (element.getType()) {
                case -128: {
                    authenticationType = AuthenticationType.SIMPLE;
                    try {
                        simplePassword = element.decodeAsOctetString();
                        break;
                    }
                    catch (Exception e) {
                        int msgID = 2293839;
                        String message = MessageHandler.getMessage(msgID, String.valueOf(e));
                        throw new LDAPException(2, msgID, message, e);
                    }
                }
                case -93: {
                    authenticationType = AuthenticationType.SASL;
                    try {
                        elements = element.decodeAsSequence().elements();
                        saslMechanism = elements.get(0).decodeAsOctetString().stringValue();
                        if (elements.size() == 2) {
                            saslCredentials = elements.get(1).decodeAsOctetString();
                        }
                        break;
                    }
                    catch (Exception e) {
                        int msgID = 2293840;
                        String message = MessageHandler.getMessage(msgID, String.valueOf(e));
                        throw new LDAPException(2, msgID, message, e);
                    }
                }
                default: {
                    int msgID = 2293841;
                    String message = MessageHandler.getMessage(msgID, element.getType());
                    throw new LDAPException(7, msgID, message);
                }
            }
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293842;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        return new BindRequestProtocolOp(dn, protocolVersion, authenticationType, simplePassword, saslMechanism, saslCredentials);
    }

    public void toString(StringBuilder buffer) {
        buffer.append("BindRequest(version=");
        buffer.append(this.protocolVersion);
        buffer.append(", dn=");
        if (this.dn != null) {
            this.dn.toString(buffer);
        }
        if (this.authenticationType == AuthenticationType.SIMPLE) {
            buffer.append(", password=");
            this.simplePassword.toString(buffer);
        } else {
            buffer.append(", saslMechanism=");
            buffer.append(this.saslMechanism);
            if (this.saslCredentials != null) {
                buffer.append(", saslCredentials=");
                this.saslCredentials.toString(buffer);
            }
        }
        buffer.append(")");
    }

    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("Bind Request");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Protocol Version:  ");
        buffer.append(this.protocolVersion);
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  DN:  ");
        if (this.dn != null) {
            this.dn.toString(buffer);
        }
        buffer.append(ServerConstants.EOL);
        if (this.authenticationType == AuthenticationType.SIMPLE) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  Simple Password:  ");
            buffer.append(String.valueOf(this.simplePassword));
            buffer.append(ServerConstants.EOL);
        } else {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  SASL Mechanism:  ");
            buffer.append(this.saslMechanism);
            buffer.append(ServerConstants.EOL);
            if (this.saslCredentials != null) {
                buffer.append((CharSequence)indentBuf);
                buffer.append("  SASL Credentials:");
                buffer.append(ServerConstants.EOL);
                this.saslCredentials.toString(buffer, indent + 4);
            }
        }
    }
}

