/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.asn1;

import java.util.ArrayList;
import java.util.Iterator;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Constants;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASN1Set
extends ASN1Element {
    private static final long serialVersionUID = 2197633272056656073L;
    private ArrayList<ASN1Element> elements;

    public ASN1Set() {
        super((byte)49);
        this.elements = new ArrayList();
    }

    public ASN1Set(byte type) {
        super(type);
        this.elements = new ArrayList();
    }

    public ASN1Set(ArrayList<ASN1Element> elements) {
        super((byte)49, ASN1Set.encodeValue(elements));
        this.elements = elements == null ? new ArrayList() : elements;
    }

    public ASN1Set(byte type, ArrayList<ASN1Element> elements) {
        super(type, ASN1Set.encodeValue(elements));
        this.elements = elements == null ? new ArrayList() : elements;
    }

    private ASN1Set(byte type, byte[] value, ArrayList<ASN1Element> elements) {
        super(type, value);
        this.elements = elements == null ? new ArrayList() : elements;
    }

    public ArrayList<ASN1Element> elements() {
        return this.elements;
    }

    public void setElements(ArrayList<ASN1Element> elements) {
        if (elements == null) {
            this.elements.clear();
            this.setValueInternal(ASN1Constants.NO_VALUE);
        } else {
            this.elements = elements;
            this.setValueInternal(ASN1Set.encodeValue(elements));
        }
    }

    @Override
    public void setValue(byte[] value) throws ASN1Exception {
        if (value == null) {
            int msgID = 2293802;
            String message = MessageHandler.getMessage(msgID);
            throw new ASN1Exception(msgID, message);
        }
        this.elements = ASN1Set.decodeElements(value);
        this.setValueInternal(value);
    }

    public static ASN1Set decodeAsSet(ASN1Element element) throws ASN1Exception {
        if (element == null) {
            int msgID = 2293803;
            String message = MessageHandler.getMessage(msgID);
            throw new ASN1Exception(msgID, message);
        }
        byte[] value = element.value();
        ArrayList<ASN1Element> elements = ASN1Set.decodeElements(value);
        return new ASN1Set(element.getType(), value, elements);
    }

    public static ASN1Set decodeAsSet(byte[] encodedElement) throws ASN1Exception {
        if (encodedElement == null) {
            int msgID = 2293804;
            String message = MessageHandler.getMessage(msgID);
            throw new ASN1Exception(msgID, message);
        }
        if (encodedElement.length < 2) {
            int msgID = 0x230002;
            String message = MessageHandler.getMessage(msgID, encodedElement.length);
            throw new ASN1Exception(msgID, message);
        }
        byte type = encodedElement[0];
        int length = encodedElement[1] & 0x7F;
        int valueStartPos = 2;
        if (length != encodedElement[1]) {
            int numLengthBytes = length;
            if (numLengthBytes > 4) {
                int msgID = 0x230003;
                String message = MessageHandler.getMessage(msgID, numLengthBytes);
                throw new ASN1Exception(msgID, message);
            }
            if (encodedElement.length < 2 + numLengthBytes) {
                int msgID = 2293764;
                String message = MessageHandler.getMessage(msgID, numLengthBytes);
                throw new ASN1Exception(msgID, message);
            }
            length = 0;
            valueStartPos = 2 + numLengthBytes;
            for (int i = 0; i < numLengthBytes; ++i) {
                length = length << 8 | encodedElement[i + 2] & 0xFF;
            }
        }
        if (encodedElement.length - valueStartPos != length) {
            int msgID = 2293765;
            String message = MessageHandler.getMessage(msgID, length, encodedElement.length - valueStartPos);
            throw new ASN1Exception(msgID, message);
        }
        byte[] value = new byte[length];
        System.arraycopy(encodedElement, valueStartPos, value, 0, length);
        ArrayList<ASN1Element> elements = ASN1Set.decodeElements(value);
        return new ASN1Set(type, value, elements);
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("ASN1Set(type=");
        buffer.append(StaticUtils.byteToHex(this.getType()));
        buffer.append(", values={ ");
        if (!this.elements.isEmpty()) {
            Iterator<ASN1Element> iterator = this.elements.iterator();
            iterator.next().toString(buffer);
            while (iterator.hasNext()) {
                buffer.append(", ");
                iterator.next().toString(buffer);
            }
        }
        buffer.append(" })");
    }

    @Override
    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("ASN.1 Set");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  BER Type:  ");
        buffer.append(StaticUtils.byteToHex(this.getType()));
        buffer.append(ServerConstants.EOL);
        if (!this.elements.isEmpty()) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  Decoded Values:");
            buffer.append(ServerConstants.EOL);
            Iterator<ASN1Element> iterator = this.elements.iterator();
            buffer.append((CharSequence)indentBuf);
            buffer.append("  ");
            iterator.next().toString(buffer);
            buffer.append(ServerConstants.EOL);
            while (iterator.hasNext()) {
                buffer.append((CharSequence)indentBuf);
                buffer.append("  ");
                iterator.next().toString(buffer);
                buffer.append(ServerConstants.EOL);
            }
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Value:  ");
        buffer.append(ServerConstants.EOL);
        StaticUtils.byteArrayToHexPlusAscii(buffer, this.value(), indent + 2);
    }
}

