/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.asn1;

import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Constants;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

public class ASN1OctetString
extends ASN1Element
implements ByteString {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final long serialVersionUID = -6101268916754431502L;
    private String stringValue;

    public ASN1OctetString() {
        super((byte)4);
    }

    public ASN1OctetString(byte type) {
        super(type);
    }

    public ASN1OctetString(byte[] value) {
        super((byte)4, value);
        this.stringValue = null;
    }

    public ASN1OctetString(String stringValue) {
        super((byte)4, StaticUtils.getBytes(stringValue));
        this.stringValue = stringValue;
    }

    public ASN1OctetString(byte type, byte[] value) {
        super(type, value);
        this.stringValue = null;
    }

    public ASN1OctetString(byte type, String stringValue) {
        super(type, StaticUtils.getBytes(stringValue));
        this.stringValue = stringValue;
    }

    public String stringValue() {
        if (this.stringValue == null) {
            try {
                this.stringValue = new String(this.value(), "UTF-8");
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                this.stringValue = new String(this.value());
            }
        }
        return this.stringValue;
    }

    public void stringValue(StringBuilder buffer) {
        if (this.stringValue != null) {
            buffer.append(this.stringValue);
            return;
        }
        byte[] value = this.value();
        int length = value.length;
        for (int i = 0; i < length; ++i) {
            if ((value[i] & 0x7F) != value[i]) {
                String s;
                try {
                    s = new String(value, i, length - i, "UTF-8");
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    s = new String(value, i, length - i);
                }
                buffer.append(s);
                return;
            }
            buffer.append((char)value[i]);
        }
    }

    public void setValue(String stringValue) {
        if (stringValue == null) {
            this.stringValue = null;
            this.setValueInternal(new byte[0]);
        } else {
            this.stringValue = stringValue;
            this.setValueInternal(StaticUtils.getBytes(stringValue));
        }
    }

    public void setValue(byte[] value) {
        if (value == null) {
            this.setValueInternal(ASN1Constants.NO_VALUE);
        } else {
            this.setValueInternal(value);
        }
        this.stringValue = null;
    }

    public static ASN1OctetString decodeAsOctetString(ASN1Element element) throws ASN1Exception {
        if (element == null) {
            int msgID = 2293783;
            String message = MessageHandler.getMessage(msgID);
            throw new ASN1Exception(msgID, message);
        }
        return new ASN1OctetString(element.getType(), element.value());
    }

    public static ASN1OctetString decodeAsOctetString(byte[] encodedElement) throws ASN1Exception {
        if (encodedElement == null) {
            int msgID = 2293784;
            String message = MessageHandler.getMessage(msgID);
            throw new ASN1Exception(msgID, message);
        }
        if (encodedElement.length < 2) {
            int msgID = 0x230002;
            String message = MessageHandler.getMessage(msgID, encodedElement.length);
            throw new ASN1Exception(msgID, message);
        }
        byte type = encodedElement[0];
        int length = encodedElement[1] & 0x7F;
        int valueStartPos = 2;
        if (length != encodedElement[1]) {
            int numLengthBytes = length;
            if (numLengthBytes > 4) {
                int msgID = 0x230003;
                String message = MessageHandler.getMessage(msgID, numLengthBytes);
                throw new ASN1Exception(msgID, message);
            }
            if (encodedElement.length < 2 + numLengthBytes) {
                int msgID = 2293764;
                String message = MessageHandler.getMessage(msgID, numLengthBytes);
                throw new ASN1Exception(msgID, message);
            }
            length = 0;
            valueStartPos = 2 + numLengthBytes;
            for (int i = 0; i < numLengthBytes; ++i) {
                length = length << 8 | encodedElement[i + 2] & 0xFF;
            }
        }
        if (encodedElement.length - valueStartPos != length) {
            int msgID = 2293765;
            String message = MessageHandler.getMessage(msgID, length, encodedElement.length - valueStartPos);
            throw new ASN1Exception(msgID, message);
        }
        byte[] value = new byte[length];
        System.arraycopy(encodedElement, valueStartPos, value, 0, length);
        return new ASN1OctetString(type, value);
    }

    public ASN1OctetString duplicate() {
        byte[] value = this.value();
        int length = value.length;
        byte[] duplicateValue = new byte[length];
        System.arraycopy(value, 0, duplicateValue, 0, length);
        return new ASN1OctetString(this.getType(), value);
    }

    public void toString(StringBuilder buffer) {
        buffer.append(this.stringValue());
    }

    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("ASN.1 Octet String");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  BER Type:  ");
        buffer.append(StaticUtils.byteToHex(this.getType()));
        buffer.append(ServerConstants.EOL);
        byte[] value = this.value();
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Value (");
        buffer.append(value.length);
        buffer.append(" bytes)");
        buffer.append(ServerConstants.EOL);
        StaticUtils.byteArrayToHexPlusAscii(buffer, value, indent + 2);
    }

    public ASN1OctetString toASN1OctetString() {
        return this;
    }
}

