/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.asn1;

import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

public class ASN1Null
extends ASN1Element {
    private static final long serialVersionUID = 8921787912269145125L;

    public ASN1Null() {
        super((byte)5);
    }

    public ASN1Null(byte type) {
        super(type);
    }

    public void setValue(byte[] value) throws ASN1Exception {
        if (value != null && value.length != 0) {
            int msgID = 2293778;
            String message = MessageHandler.getMessage(msgID, value.length);
            throw new ASN1Exception(msgID, message);
        }
    }

    public static ASN1Null decodeAsNull(ASN1Element element) throws ASN1Exception {
        if (element == null) {
            int msgID = 2293779;
            String message = MessageHandler.getMessage(msgID);
            throw new ASN1Exception(msgID, message);
        }
        byte[] value = element.value();
        if (value.length != 0) {
            int msgID = 2293780;
            String message = MessageHandler.getMessage(msgID, value.length);
            throw new ASN1Exception(msgID, message);
        }
        return new ASN1Null(element.getType());
    }

    public static ASN1Null decodeAsNull(byte[] encodedElement) throws ASN1Exception {
        int msgID;
        if (encodedElement == null) {
            int msgID2 = 2293781;
            String message = MessageHandler.getMessage(msgID2);
            throw new ASN1Exception(msgID2, message);
        }
        if (encodedElement.length < 2) {
            int msgID3 = 0x230002;
            String message = MessageHandler.getMessage(msgID3, encodedElement.length);
            throw new ASN1Exception(msgID3, message);
        }
        byte type = encodedElement[0];
        int length = encodedElement[1] & 0x7F;
        int valueStartPos = 2;
        if (length != encodedElement[1]) {
            int numLengthBytes = length;
            if (numLengthBytes > 4) {
                int msgID4 = 0x230003;
                String message = MessageHandler.getMessage(msgID4, numLengthBytes);
                throw new ASN1Exception(msgID4, message);
            }
            if (encodedElement.length < 2 + numLengthBytes) {
                int msgID5 = 2293764;
                String message = MessageHandler.getMessage(msgID5, numLengthBytes);
                throw new ASN1Exception(msgID5, message);
            }
            length = 0;
            valueStartPos = 2 + numLengthBytes;
            for (int i = 0; i < numLengthBytes; ++i) {
                length = length << 8 | encodedElement[i + 2] & 0xFF;
            }
        }
        if (encodedElement.length - valueStartPos != length) {
            msgID = 2293765;
            String message = MessageHandler.getMessage(msgID, length, encodedElement.length - valueStartPos);
            throw new ASN1Exception(msgID, message);
        }
        if (length != 0) {
            msgID = 2293782;
            String message = MessageHandler.getMessage(msgID, length);
            throw new ASN1Exception(msgID, message);
        }
        return new ASN1Null(type);
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ASN1Null(type=");
        buffer.append(StaticUtils.byteToHex(this.getType()));
        buffer.append(")");
    }

    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("ASN.1 Null");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  BER Type:  ");
        buffer.append(StaticUtils.byteToHex(this.getType()));
        buffer.append(ServerConstants.EOL);
    }
}

