/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.PluginCfgDefn;
import org.opends.server.admin.std.server.PluginCfg;
import org.opends.server.api.plugin.DirectoryServerPlugin;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.api.plugin.PreOperationPluginResult;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteStringFactory;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PreOperationAddOperation;
import org.opends.server.types.operation.PreOperationModifyDNOperation;
import org.opends.server.types.operation.PreOperationModifyOperation;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LastModPlugin
extends DirectoryServerPlugin<PluginCfg>
implements ConfigurationChangeListener<PluginCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final AttributeType createTimestampType = DirectoryConfig.getAttributeType("createtimestamp", true);
    private final AttributeType creatorsNameType = DirectoryConfig.getAttributeType("creatorsname", true);
    private final AttributeType modifiersNameType = DirectoryConfig.getAttributeType("modifiersname", true);
    private final AttributeType modifyTimestampType = DirectoryConfig.getAttributeType("modifytimestamp", true);

    @Override
    public final void initializePlugin(Set<PluginType> pluginTypes, PluginCfg configuration) throws ConfigException {
        configuration.addChangeListener(this);
        block3: for (PluginType t : pluginTypes) {
            switch (t) {
                case PRE_OPERATION_ADD: 
                case PRE_OPERATION_MODIFY: 
                case PRE_OPERATION_MODIFY_DN: {
                    continue block3;
                }
            }
            int msgID = 7602227;
            String message = MessageHandler.getMessage(msgID, t.toString());
            throw new ConfigException(msgID, message);
        }
    }

    @Override
    public final PreOperationPluginResult doPreOperation(PreOperationAddOperation addOperation) {
        DN creatorDN = addOperation.getAuthorizationDN();
        LinkedHashSet<AttributeValue> nameValues = new LinkedHashSet<AttributeValue>(1);
        if (creatorDN == null) {
            nameValues.add(new AttributeValue(this.creatorsNameType, ByteStringFactory.create()));
        } else {
            nameValues.add(new AttributeValue(this.creatorsNameType, ByteStringFactory.create(creatorDN.toString())));
        }
        Attribute nameAttr = new Attribute(this.creatorsNameType, "creatorsName", nameValues);
        ArrayList<Attribute> nameList = new ArrayList<Attribute>(1);
        nameList.add(nameAttr);
        addOperation.setAttribute(this.creatorsNameType, nameList);
        LinkedHashSet<AttributeValue> timeValues = new LinkedHashSet<AttributeValue>(1);
        timeValues.add(new AttributeValue(this.createTimestampType, ByteStringFactory.create(TimeThread.getGMTTime())));
        Attribute timeAttr = new Attribute(this.createTimestampType, "createTimestamp", timeValues);
        ArrayList<Attribute> timeList = new ArrayList<Attribute>(1);
        timeList.add(timeAttr);
        addOperation.setAttribute(this.createTimestampType, timeList);
        return PreOperationPluginResult.SUCCESS;
    }

    @Override
    public final PreOperationPluginResult doPreOperation(PreOperationModifyOperation modifyOperation) {
        DN modifierDN = modifyOperation.getAuthorizationDN();
        LinkedHashSet<AttributeValue> nameValues = new LinkedHashSet<AttributeValue>(1);
        if (modifierDN == null) {
            nameValues.add(new AttributeValue(this.modifiersNameType, ByteStringFactory.create()));
        } else {
            nameValues.add(new AttributeValue(this.modifiersNameType, ByteStringFactory.create(modifierDN.toString())));
        }
        Attribute nameAttr = new Attribute(this.modifiersNameType, "modifiersName", nameValues);
        try {
            modifyOperation.addModification(new Modification(ModificationType.REPLACE, nameAttr, true));
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            modifyOperation.setResultCode(DirectoryConfig.getServerErrorResultCode());
            modifyOperation.appendErrorMessage(de.getErrorMessage());
            return new PreOperationPluginResult(false, false, true);
        }
        LinkedHashSet<AttributeValue> timeValues = new LinkedHashSet<AttributeValue>(1);
        timeValues.add(new AttributeValue(this.modifyTimestampType, ByteStringFactory.create(TimeThread.getGMTTime())));
        Attribute timeAttr = new Attribute(this.modifyTimestampType, "modifyTimestamp", timeValues);
        try {
            modifyOperation.addModification(new Modification(ModificationType.REPLACE, timeAttr, true));
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            modifyOperation.setResultCode(DirectoryConfig.getServerErrorResultCode());
            modifyOperation.appendErrorMessage(de.getErrorMessage());
            return new PreOperationPluginResult(false, false, true);
        }
        return PreOperationPluginResult.SUCCESS;
    }

    @Override
    public final PreOperationPluginResult doPreOperation(PreOperationModifyDNOperation modifyDNOperation) {
        DN modifierDN = modifyDNOperation.getAuthorizationDN();
        LinkedHashSet<AttributeValue> nameValues = new LinkedHashSet<AttributeValue>(1);
        if (modifierDN == null) {
            nameValues.add(new AttributeValue(this.modifiersNameType, ByteStringFactory.create()));
        } else {
            nameValues.add(new AttributeValue(this.modifiersNameType, ByteStringFactory.create(modifierDN.toString())));
        }
        Attribute nameAttr = new Attribute(this.modifiersNameType, "modifiersName", nameValues);
        modifyDNOperation.addModification(new Modification(ModificationType.REPLACE, nameAttr, true));
        LinkedHashSet<AttributeValue> timeValues = new LinkedHashSet<AttributeValue>(1);
        timeValues.add(new AttributeValue(this.modifyTimestampType, ByteStringFactory.create(TimeThread.getGMTTime())));
        Attribute timeAttr = new Attribute(this.modifyTimestampType, "modifyTimestamp", timeValues);
        modifyDNOperation.addModification(new Modification(ModificationType.REPLACE, timeAttr, true));
        return PreOperationPluginResult.SUCCESS;
    }

    @Override
    public boolean isConfigurationAcceptable(PluginCfg configuration, List<String> unacceptableReasons) {
        return this.isConfigurationChangeAcceptable(configuration, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(PluginCfg configuration, List<String> unacceptableReasons) {
        boolean configAcceptable = true;
        block3: for (PluginCfgDefn.PluginType pluginType : configuration.getPluginType()) {
            switch (pluginType) {
                case PREOPERATIONADD: 
                case PREOPERATIONMODIFY: 
                case PREOPERATIONMODIFYDN: {
                    continue block3;
                }
            }
            int msgID = 7602227;
            String message = MessageHandler.getMessage(msgID, pluginType.toString());
            unacceptableReasons.add(message);
            configAcceptable = false;
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(PluginCfg configuration) {
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }
}

