/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers.debug;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.std.meta.DebugLogPublisherCfgDefn;
import org.opends.server.admin.std.server.DebugLogPublisherCfg;
import org.opends.server.api.DebugLogPublisher;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.LogLevel;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugLogger
implements ConfigurationAddListener<DebugLogPublisherCfg>,
ConfigurationDeleteListener<DebugLogPublisherCfg>,
ConfigurationChangeListener<DebugLogPublisherCfg> {
    static final LogLevel DEFAULT_CONSTRUCTOR_LEVEL = DebugLogLevel.VERBOSE;
    static final LogLevel DEFAULT_ENTRY_EXIT_LEVEL = DebugLogLevel.VERBOSE;
    static final LogLevel DEFAULT_THROWN_LEVEL = DebugLogLevel.ERROR;
    private static ConcurrentHashMap<String, DebugTracer> classTracers = new ConcurrentHashMap();
    private static CopyOnWriteArrayList<DebugLogPublisher> debugPublishers = new CopyOnWriteArrayList();
    static boolean enabled = false;
    static final DebugLogger instance = new DebugLogger();

    public static synchronized void addDebugLogPublisher(DebugLogPublisher publisher) {
        debugPublishers.add(publisher);
        DebugLogger.updateTracerSettings();
        enabled = true;
    }

    public static synchronized boolean removeDebugLogPublisher(DebugLogPublisher publisher) {
        boolean removed = debugPublishers.remove(publisher);
        if (removed) {
            publisher.close();
        }
        DebugLogger.updateTracerSettings();
        if (debugPublishers.isEmpty()) {
            enabled = false;
        }
        return removed;
    }

    public static synchronized void removeAllDebugLogPublishers() {
        for (DebugLogPublisher publisher : debugPublishers) {
            publisher.close();
        }
        debugPublishers.clear();
        DebugLogger.updateTracerSettings();
        enabled = false;
    }

    public void initializeDebugLogger(List<DebugLogPublisherCfg> configs) throws ConfigException, InitializationException {
        for (DebugLogPublisherCfg config : configs) {
            config.addDebugChangeListener(this);
            if (!config.isEnabled()) continue;
            DebugLogPublisher debugLogPublisher = this.getDebugPublisher(config);
            DebugLogger.addDebugLogPublisher(debugLogPublisher);
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(DebugLogPublisherCfg config, List<String> unacceptableReasons) {
        return !config.isEnabled() || this.isJavaClassAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(DebugLogPublisherCfg config, List<String> unacceptableReasons) {
        return !config.isEnabled() || this.isJavaClassAcceptable(config, unacceptableReasons);
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(DebugLogPublisherCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        config.addDebugChangeListener(this);
        if (config.isEnabled()) {
            try {
                DebugLogPublisher debugLogPublisher = this.getDebugPublisher(config);
                DebugLogger.addDebugLogPublisher(debugLogPublisher);
            }
            catch (ConfigException e) {
                messages.add(e.getMessage());
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            catch (Exception e) {
                int msgID = 3407921;
                messages.add(MessageHandler.getMessage(msgID, String.valueOf(config.dn().toString()), StaticUtils.stackTraceToSingleLineString(e)));
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(DebugLogPublisherCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        DN dn = config.dn();
        DebugLogPublisher debugLogPublisher = null;
        for (DebugLogPublisher publisher : debugPublishers) {
            if (!publisher.getDN().equals(dn)) continue;
            debugLogPublisher = publisher;
        }
        if (debugLogPublisher == null) {
            if (config.isEnabled()) {
                return this.applyConfigurationAdd(config);
            }
        } else if (config.isEnabled()) {
            String className = config.getJavaImplementationClass();
            if (!className.equals(debugLogPublisher.getClass().getName())) {
                adminActionRequired = true;
            }
        } else {
            DebugLogger.removeDebugLogPublisher(debugLogPublisher);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(DebugLogPublisherCfg config, List<String> unacceptableReasons) {
        DN dn = config.dn();
        DebugLogPublisher debugLogPublisher = null;
        for (DebugLogPublisher publisher : debugPublishers) {
            if (!publisher.getDN().equals(dn)) continue;
            debugLogPublisher = publisher;
        }
        return debugLogPublisher != null;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(DebugLogPublisherCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        DebugLogPublisher debugLogPublisher = null;
        for (DebugLogPublisher publisher : debugPublishers) {
            if (!publisher.getDN().equals(config.dn())) continue;
            debugLogPublisher = publisher;
        }
        if (debugLogPublisher != null) {
            DebugLogger.removeDebugLogPublisher(debugLogPublisher);
        } else {
            resultCode = ResultCode.NO_SUCH_OBJECT;
        }
        return new ConfigChangeResult(resultCode, adminActionRequired);
    }

    private boolean isJavaClassAcceptable(DebugLogPublisherCfg config, List<String> unacceptableReasons) {
        Class<DebugLogPublisher> theClass;
        String className = config.getJavaImplementationClass();
        DebugLogPublisherCfgDefn d = DebugLogPublisherCfgDefn.getInstance();
        ClassPropertyDefinition pd = d.getJavaImplementationClassPropertyDefinition();
        DebugLogPublisher publisher = null;
        try {
            theClass = pd.loadClass(className, DebugLogPublisher.class);
            publisher = theClass.newInstance();
        }
        catch (Exception e) {
            int msgID = 3407928;
            String message = MessageHandler.getMessage(msgID, className, config.dn().toString(), String.valueOf(e));
            unacceptableReasons.add(message);
            return false;
        }
        try {
            Method method = theClass.getMethod("isConfigurationAcceptable", DebugLogPublisherCfg.class, List.class);
            Boolean acceptable = (Boolean)method.invoke((Object)publisher, config, unacceptableReasons);
            if (!acceptable.booleanValue()) {
                return false;
            }
        }
        catch (Exception e) {
            int msgID = 3407928;
            String message = MessageHandler.getMessage(msgID, className, config.dn().toString(), String.valueOf(e));
            unacceptableReasons.add(message);
            return false;
        }
        return true;
    }

    private DebugLogPublisher getDebugPublisher(DebugLogPublisherCfg config) throws ConfigException {
        DebugLogPublisher debugLogPublisher;
        String className = config.getJavaImplementationClass();
        DebugLogPublisherCfgDefn d = DebugLogPublisherCfgDefn.getInstance();
        ClassPropertyDefinition pd = d.getJavaImplementationClassPropertyDefinition();
        try {
            Class<DebugLogPublisher> theClass = pd.loadClass(className, DebugLogPublisher.class);
            debugLogPublisher = theClass.newInstance();
            Method method = theClass.getMethod("initializeDebugLogPublisher", config.definition().getServerConfigurationClass());
            method.invoke((Object)debugLogPublisher, config);
        }
        catch (InvocationTargetException ite) {
            Throwable e = ite.getTargetException();
            int msgID = 3407928;
            String message = MessageHandler.getMessage(msgID, className, config.dn().toString(), StaticUtils.stackTraceToSingleLineString(e));
            throw new ConfigException(msgID, message, e);
        }
        catch (Exception e) {
            int msgID = 3407928;
            String message = MessageHandler.getMessage(msgID, className, config.dn().toString(), String.valueOf(e));
            throw new ConfigException(msgID, message, e);
        }
        return debugLogPublisher;
    }

    static void updateTracerSettings() {
        DebugLogPublisher[] publishers = debugPublishers.toArray(new DebugLogPublisher[0]);
        for (DebugTracer tracer : classTracers.values()) {
            tracer.updateSettings(publishers);
        }
    }

    public static boolean debugEnabled() {
        return enabled;
    }

    public static DebugLogger getInstance() {
        return instance;
    }

    public static DebugTracer getTracer() {
        DebugTracer tracer = new DebugTracer(debugPublishers.toArray(new DebugLogPublisher[0]));
        classTracers.put(tracer.getTracedClassName(), tracer);
        return tracer;
    }

    public static DebugTracer getTracer(String className) {
        return classTracers.get(className);
    }

    public static @interface TraceThrown {
    }

    public static @interface NoExitDebugTracing {
    }

    public static @interface NoEntryDebugTracing {
    }

    public static @interface NoDebugTracing {
    }
}

