/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.StringTokenizer;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.ErrorLogPublisherCfgDefn;
import org.opends.server.admin.std.server.ErrorLogPublisherCfg;
import org.opends.server.admin.std.server.FileBasedErrorLogPublisherCfg;
import org.opends.server.api.ErrorLogPublisher;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.AsyncronousTextWriter;
import org.opends.server.loggers.LogPublisherErrorHandler;
import org.opends.server.loggers.MultifileTextWriter;
import org.opends.server.loggers.RetentionPolicy;
import org.opends.server.loggers.RotationPolicy;
import org.opends.server.loggers.TextWriter;
import org.opends.server.loggers.TimeStampNaming;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.FilePermission;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextErrorLogPublisher
extends ErrorLogPublisher<FileBasedErrorLogPublisherCfg>
implements ConfigurationChangeListener<FileBasedErrorLogPublisherCfg> {
    private TextWriter writer;
    private FileBasedErrorLogPublisherCfg currentConfig;

    public static TextErrorLogPublisher getStartupTextErrorPublisher(TextWriter writer) {
        TextErrorLogPublisher startupPublisher = new TextErrorLogPublisher();
        startupPublisher.writer = writer;
        startupPublisher.defaultSeverities.add(ErrorLogSeverity.FATAL_ERROR);
        startupPublisher.defaultSeverities.add(ErrorLogSeverity.SEVERE_ERROR);
        startupPublisher.defaultSeverities.add(ErrorLogSeverity.SEVERE_WARNING);
        startupPublisher.defaultSeverities.add(ErrorLogSeverity.NOTICE);
        return startupPublisher;
    }

    @Override
    public void initializeErrorLogPublisher(FileBasedErrorLogPublisherCfg config) throws ConfigException, InitializationException {
        File logFile = StaticUtils.getFileForPath(config.getLogFile());
        TimeStampNaming fnPolicy = new TimeStampNaming(logFile);
        try {
            Object policy;
            FilePermission perm = FilePermission.decodeUNIXMode(config.getLogFileMode());
            LogPublisherErrorHandler errorHandler = new LogPublisherErrorHandler(config.dn());
            boolean writerAutoFlush = config.isAutoFlush() && !config.isAsynchronous();
            MultifileTextWriter writer = new MultifileTextWriter("Multifile Text Writer for " + config.dn().toNormalizedString(), config.getTimeInterval(), fnPolicy, perm, errorHandler, "UTF-8", writerAutoFlush, config.isAppend(), (int)config.getBufferSize());
            for (DN dn : config.getRotationPolicyDN()) {
                policy = DirectoryServer.getRotationPolicy(dn);
                if (policy != null) {
                    writer.addRotationPolicy((RotationPolicy)policy);
                    continue;
                }
                int msgID = 3408099;
                String message = MessageHandler.getMessage(msgID, dn.toString(), config.dn().toString());
                throw new ConfigException(msgID, message);
            }
            for (DN dn : config.getRetentionPolicyDN()) {
                policy = DirectoryServer.getRetentionPolicy(dn);
                if (policy != null) {
                    writer.addRetentionPolicy((RetentionPolicy)policy);
                    continue;
                }
                int msgID = 3277158;
                String message = MessageHandler.getMessage(msgID, dn.toString(), config.dn().toString());
                throw new ConfigException(msgID, message);
            }
            this.writer = config.isAsynchronous() ? new AsyncronousTextWriter("Asyncronous Text Writer for " + config.dn().toNormalizedString(), config.getQueueSize(), config.isAutoFlush(), writer) : writer;
        }
        catch (DirectoryException e) {
            int msgID = 3408533;
            String message = MessageHandler.getMessage(msgID, config.dn().toString(), String.valueOf(e));
            throw new InitializationException(msgID, message, e);
        }
        catch (IOException e) {
            int msgID = 3408533;
            String message = MessageHandler.getMessage(msgID, config.dn().toString(), String.valueOf(e));
            throw new InitializationException(msgID, message, e);
        }
        SortedSet<ErrorLogPublisherCfgDefn.DefaultSeverity> defSevs = config.getDefaultSeverity();
        if (defSevs.isEmpty()) {
            this.defaultSeverities.add(ErrorLogSeverity.FATAL_ERROR);
            this.defaultSeverities.add(ErrorLogSeverity.SEVERE_ERROR);
            this.defaultSeverities.add(ErrorLogSeverity.SEVERE_WARNING);
        } else {
            for (ErrorLogPublisherCfgDefn.DefaultSeverity defSev : defSevs) {
                if (defSev.name().equalsIgnoreCase("ALL")) {
                    this.defaultSeverities.add(ErrorLogSeverity.FATAL_ERROR);
                    this.defaultSeverities.add(ErrorLogSeverity.INFORMATIONAL);
                    this.defaultSeverities.add(ErrorLogSeverity.MILD_ERROR);
                    this.defaultSeverities.add(ErrorLogSeverity.MILD_WARNING);
                    this.defaultSeverities.add(ErrorLogSeverity.NOTICE);
                    this.defaultSeverities.add(ErrorLogSeverity.SEVERE_ERROR);
                    this.defaultSeverities.add(ErrorLogSeverity.SEVERE_WARNING);
                    continue;
                }
                ErrorLogSeverity errorSeverity = ErrorLogSeverity.getByName(defSev.name());
                if (errorSeverity == null) continue;
                this.defaultSeverities.add(errorSeverity);
            }
        }
        for (String overrideSeverity : config.getOverrideSeverity()) {
            if (overrideSeverity == null) continue;
            int equalPos = overrideSeverity.indexOf(61);
            if (equalPos < 0) {
                int msgID = 4259847;
                String msg = MessageHandler.getMessage(msgID, overrideSeverity);
                throw new ConfigException(msgID, msg);
            }
            String categoryName = overrideSeverity.substring(0, equalPos);
            ErrorLogCategory category = ErrorLogCategory.getByName(categoryName);
            if (category == null) {
                int msgID = 4259846;
                String msg = MessageHandler.getMessage(msgID, categoryName);
                throw new ConfigException(msgID, msg);
            }
            HashSet<ErrorLogSeverity> severities = new HashSet<ErrorLogSeverity>();
            StringTokenizer sevTokenizer = new StringTokenizer(overrideSeverity.substring(equalPos + 1), ",");
            while (sevTokenizer.hasMoreElements()) {
                String severityName = sevTokenizer.nextToken();
                if (severityName.equalsIgnoreCase("ALL")) {
                    severities.add(ErrorLogSeverity.FATAL_ERROR);
                    severities.add(ErrorLogSeverity.INFORMATIONAL);
                    severities.add(ErrorLogSeverity.MILD_ERROR);
                    severities.add(ErrorLogSeverity.MILD_WARNING);
                    severities.add(ErrorLogSeverity.NOTICE);
                    severities.add(ErrorLogSeverity.SEVERE_ERROR);
                    severities.add(ErrorLogSeverity.SEVERE_WARNING);
                    continue;
                }
                ErrorLogSeverity severity = ErrorLogSeverity.getByName(severityName);
                if (severity == null) {
                    int msgID = 4259845;
                    String msg = MessageHandler.getMessage(msgID, severityName);
                    throw new ConfigException(msgID, msg);
                }
                severities.add(severity);
            }
            this.definedSeverities.put(category, severities);
        }
        this.currentConfig = config;
        config.addFileBasedErrorChangeListener(this);
    }

    @Override
    public boolean isConfigurationAcceptable(ErrorLogPublisherCfg configuration, List<String> unacceptableReasons) {
        Object policy;
        FileBasedErrorLogPublisherCfg config = (FileBasedErrorLogPublisherCfg)configuration;
        for (DN dn : config.getRotationPolicyDN()) {
            policy = DirectoryServer.getRotationPolicy(dn);
            if (policy != null) continue;
            int msgID = 3408099;
            String message = MessageHandler.getMessage(msgID, dn.toString(), config.dn().toString());
            unacceptableReasons.add(message);
            return false;
        }
        for (DN dn : config.getRetentionPolicyDN()) {
            policy = DirectoryServer.getRetentionPolicy(dn);
            if (policy != null) continue;
            int msgID = 3277158;
            String message = MessageHandler.getMessage(msgID, dn.toString(), config.dn().toString());
            unacceptableReasons.add(message);
            return false;
        }
        for (String overrideSeverity : config.getOverrideSeverity()) {
            if (overrideSeverity == null) continue;
            int equalPos = overrideSeverity.indexOf(61);
            if (equalPos < 0) {
                int msgID = 4259847;
                String msg = MessageHandler.getMessage(msgID, overrideSeverity);
                unacceptableReasons.add(msg);
                return false;
            }
            String categoryName = overrideSeverity.substring(0, equalPos);
            ErrorLogCategory category = ErrorLogCategory.getByName(categoryName);
            if (category == null) {
                int msgID = 4259846;
                String msg = MessageHandler.getMessage(msgID, categoryName);
                unacceptableReasons.add(msg);
                return false;
            }
            StringTokenizer sevTokenizer = new StringTokenizer(overrideSeverity.substring(equalPos + 1), ",");
            while (sevTokenizer.hasMoreElements()) {
                ErrorLogSeverity severity;
                String severityName = sevTokenizer.nextToken();
                if (severityName.equalsIgnoreCase("ALL") || (severity = ErrorLogSeverity.getByName(severityName)) != null) continue;
                int msgID = 4259845;
                String msg = MessageHandler.getMessage(msgID, severityName);
                unacceptableReasons.add(msg);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isConfigurationChangeAcceptable(FileBasedErrorLogPublisherCfg config, List<String> unacceptableReasons) {
        try {
            File logFile;
            if (!this.currentConfig.getLogFileMode().equalsIgnoreCase(config.getLogFileMode())) {
                FilePermission.decodeUNIXMode(config.getLogFileMode());
            }
            if (!this.currentConfig.getLogFile().equalsIgnoreCase(config.getLogFile()) && (logFile = StaticUtils.getFileForPath(config.getLogFile())).createNewFile()) {
                logFile.delete();
            }
        }
        catch (Exception e) {
            int msgID = 3408533;
            String message = MessageHandler.getMessage(msgID, config.dn().toString(), StaticUtils.stackTraceToSingleLineString(e));
            unacceptableReasons.add(message);
            return false;
        }
        return this.isConfigurationAcceptable(config, unacceptableReasons);
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(FileBasedErrorLogPublisherCfg config) {
        int msgID;
        int msgID2;
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        SortedSet<ErrorLogPublisherCfgDefn.DefaultSeverity> defSevs = config.getDefaultSeverity();
        this.defaultSeverities.clear();
        if (defSevs.isEmpty()) {
            this.defaultSeverities.add(ErrorLogSeverity.FATAL_ERROR);
            this.defaultSeverities.add(ErrorLogSeverity.SEVERE_ERROR);
            this.defaultSeverities.add(ErrorLogSeverity.SEVERE_WARNING);
        } else {
            for (ErrorLogPublisherCfgDefn.DefaultSeverity defSev : defSevs) {
                if (defSev.name().equalsIgnoreCase("ALL")) {
                    this.defaultSeverities.add(ErrorLogSeverity.FATAL_ERROR);
                    this.defaultSeverities.add(ErrorLogSeverity.INFORMATIONAL);
                    this.defaultSeverities.add(ErrorLogSeverity.MILD_ERROR);
                    this.defaultSeverities.add(ErrorLogSeverity.MILD_WARNING);
                    this.defaultSeverities.add(ErrorLogSeverity.NOTICE);
                    this.defaultSeverities.add(ErrorLogSeverity.SEVERE_ERROR);
                    this.defaultSeverities.add(ErrorLogSeverity.SEVERE_WARNING);
                    continue;
                }
                ErrorLogSeverity errorSeverity = ErrorLogSeverity.getByName(defSev.name());
                if (errorSeverity == null) continue;
                this.defaultSeverities.add(errorSeverity);
            }
        }
        this.definedSeverities.clear();
        for (String overrideSeverity : config.getOverrideSeverity()) {
            if (overrideSeverity == null) continue;
            int equalPos = overrideSeverity.indexOf(61);
            if (equalPos < 0) {
                msgID2 = 4259847;
                String msg = MessageHandler.getMessage(msgID2, overrideSeverity);
                resultCode = DirectoryServer.getServerErrorResultCode();
                messages.add(msg);
                continue;
            }
            String categoryName = overrideSeverity.substring(0, equalPos);
            ErrorLogCategory category = ErrorLogCategory.getByName(categoryName);
            if (category == null) {
                int msgID3 = 4259846;
                String msg = MessageHandler.getMessage(msgID3, categoryName);
                resultCode = DirectoryServer.getServerErrorResultCode();
                messages.add(msg);
                continue;
            }
            HashSet<ErrorLogSeverity> severities = new HashSet<ErrorLogSeverity>();
            StringTokenizer sevTokenizer = new StringTokenizer(overrideSeverity.substring(equalPos + 1), ",");
            while (sevTokenizer.hasMoreElements()) {
                String severityName = sevTokenizer.nextToken();
                if (severityName.equalsIgnoreCase("ALL")) {
                    severities.add(ErrorLogSeverity.FATAL_ERROR);
                    severities.add(ErrorLogSeverity.INFORMATIONAL);
                    severities.add(ErrorLogSeverity.MILD_ERROR);
                    severities.add(ErrorLogSeverity.MILD_WARNING);
                    severities.add(ErrorLogSeverity.NOTICE);
                    severities.add(ErrorLogSeverity.SEVERE_ERROR);
                    severities.add(ErrorLogSeverity.SEVERE_WARNING);
                    continue;
                }
                ErrorLogSeverity severity = ErrorLogSeverity.getByName(severityName);
                if (severity == null) {
                    msgID = 4259845;
                    String msg = MessageHandler.getMessage(msgID, severityName);
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    messages.add(msg);
                    continue;
                }
                severities.add(severity);
            }
            this.definedSeverities.put(category, severities);
        }
        File logFile = StaticUtils.getFileForPath(config.getLogFile());
        TimeStampNaming fnPolicy = new TimeStampNaming(logFile);
        try {
            FilePermission perm = FilePermission.decodeUNIXMode(config.getLogFileMode());
            boolean writerAutoFlush = config.isAutoFlush() && !config.isAsynchronous();
            TextWriter currentWriter = this.writer instanceof AsyncronousTextWriter ? ((AsyncronousTextWriter)this.writer).getWrappedWriter() : this.writer;
            if (currentWriter instanceof MultifileTextWriter) {
                AsyncronousTextWriter asyncWriter;
                String message;
                Object policy;
                MultifileTextWriter mfWriter = (MultifileTextWriter)this.writer;
                mfWriter.setNamingPolicy(fnPolicy);
                mfWriter.setFilePermissions(perm);
                mfWriter.setAppend(config.isAppend());
                mfWriter.setAutoFlush(writerAutoFlush);
                mfWriter.setBufferSize((int)config.getBufferSize());
                mfWriter.setInterval(config.getTimeInterval());
                mfWriter.removeAllRetentionPolicies();
                mfWriter.removeAllRotationPolicies();
                for (DN dn : config.getRotationPolicyDN()) {
                    policy = DirectoryServer.getRotationPolicy(dn);
                    if (policy != null) {
                        mfWriter.addRotationPolicy((RotationPolicy)policy);
                        continue;
                    }
                    msgID = 3408099;
                    message = MessageHandler.getMessage(msgID, dn.toString(), config.dn().toString());
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    messages.add(message);
                }
                for (DN dn : config.getRetentionPolicyDN()) {
                    policy = DirectoryServer.getRetentionPolicy(dn);
                    if (policy != null) {
                        mfWriter.addRetentionPolicy((RetentionPolicy)policy);
                        continue;
                    }
                    msgID = 3277158;
                    message = MessageHandler.getMessage(msgID, dn.toString(), config.dn().toString());
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    messages.add(message);
                }
                if (this.writer instanceof AsyncronousTextWriter && !config.isAsynchronous()) {
                    asyncWriter = (AsyncronousTextWriter)this.writer;
                    this.writer = mfWriter;
                    asyncWriter.shutdown(false);
                }
                if (!(this.writer instanceof AsyncronousTextWriter) && config.isAsynchronous()) {
                    asyncWriter = new AsyncronousTextWriter("Asyncronous Text Writer for " + config.dn().toNormalizedString(), config.getQueueSize(), config.isAutoFlush(), mfWriter);
                    this.writer = asyncWriter;
                }
                if (this.currentConfig.isAsynchronous() && config.isAsynchronous() && this.currentConfig.getQueueSize() != config.getQueueSize()) {
                    adminActionRequired = true;
                }
                this.currentConfig = config;
            }
        }
        catch (Exception e) {
            msgID2 = 3408533;
            String message = MessageHandler.getMessage(msgID2, config.dn().toString(), StaticUtils.stackTraceToSingleLineString(e));
            resultCode = DirectoryServer.getServerErrorResultCode();
            messages.add(message);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public void close() {
        this.writer.shutdown();
        if (this.currentConfig != null) {
            this.currentConfig.removeFileBasedErrorChangeListener(this);
        }
    }

    @Override
    public void logError(ErrorLogCategory category, ErrorLogSeverity severity, String message, int errorID) {
        HashSet severities = (HashSet)this.definedSeverities.get((Object)category);
        if (severities == null) {
            severities = this.defaultSeverities;
        }
        if (severities.contains((Object)severity)) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            sb.append(TimeThread.getLocalTime());
            sb.append("] category=").append(category.getCategoryName()).append(" severity=").append(severity.getSeverityName()).append(" msgID=").append(String.valueOf(errorID)).append(" msg=").append(message);
            this.writer.writeRecord(sb.toString());
        }
    }

    @Override
    public DN getDN() {
        if (this.currentConfig != null) {
            return this.currentConfig.dn();
        }
        return null;
    }
}

