/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.FileBasedAccessLogPublisherCfg;
import org.opends.server.api.AccessLogPublisher;
import org.opends.server.api.ClientConnection;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AbandonOperation;
import org.opends.server.core.AddOperation;
import org.opends.server.core.BindOperation;
import org.opends.server.core.CompareOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.core.UnbindOperation;
import org.opends.server.loggers.AsyncronousTextWriter;
import org.opends.server.loggers.LogPublisherErrorHandler;
import org.opends.server.loggers.MultifileTextWriter;
import org.opends.server.loggers.RetentionPolicy;
import org.opends.server.loggers.RotationPolicy;
import org.opends.server.loggers.TextWriter;
import org.opends.server.loggers.TimeStampNaming;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.FilePermission;
import org.opends.server.types.InitializationException;
import org.opends.server.types.Modification;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.util.Base64;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextAuditLogPublisher
extends AccessLogPublisher<FileBasedAccessLogPublisherCfg>
implements ConfigurationChangeListener<FileBasedAccessLogPublisherCfg> {
    private TextWriter writer;
    private FileBasedAccessLogPublisherCfg currentConfig;

    @Override
    public void initializeAccessLogPublisher(FileBasedAccessLogPublisherCfg config) throws ConfigException, InitializationException {
        File logFile = StaticUtils.getFileForPath(config.getLogFile());
        TimeStampNaming fnPolicy = new TimeStampNaming(logFile);
        try {
            Object policy;
            FilePermission perm = FilePermission.decodeUNIXMode(config.getLogFileMode());
            LogPublisherErrorHandler errorHandler = new LogPublisherErrorHandler(config.dn());
            boolean writerAutoFlush = config.isAutoFlush() && !config.isAsynchronous();
            MultifileTextWriter writer = new MultifileTextWriter("Multifile Text Writer for " + config.dn().toNormalizedString(), config.getTimeInterval(), fnPolicy, perm, errorHandler, "UTF-8", writerAutoFlush, config.isAppend(), (int)config.getBufferSize());
            for (DN dn : config.getRotationPolicyDN()) {
                policy = DirectoryServer.getRotationPolicy(dn);
                if (policy != null) {
                    writer.addRotationPolicy((RotationPolicy)policy);
                    continue;
                }
                int msgID = 3408099;
                String message = MessageHandler.getMessage(msgID, dn.toString(), config.dn().toString());
                throw new ConfigException(msgID, message);
            }
            for (DN dn : config.getRetentionPolicyDN()) {
                policy = DirectoryServer.getRetentionPolicy(dn);
                if (policy != null) {
                    writer.addRetentionPolicy((RetentionPolicy)policy);
                    continue;
                }
                int msgID = 3277158;
                String message = MessageHandler.getMessage(msgID, dn.toString(), config.dn().toString());
                throw new ConfigException(msgID, message);
            }
            this.writer = config.isAsynchronous() ? new AsyncronousTextWriter("Asyncronous Text Writer for " + config.dn().toNormalizedString(), config.getQueueSize(), config.isAutoFlush(), writer) : writer;
        }
        catch (DirectoryException e) {
            int msgID = 3408533;
            String message = MessageHandler.getMessage(msgID, config.dn().toString(), String.valueOf(e));
            throw new InitializationException(msgID, message, e);
        }
        catch (IOException e) {
            int msgID = 3408533;
            String message = MessageHandler.getMessage(msgID, config.dn().toString(), String.valueOf(e));
            throw new InitializationException(msgID, message, e);
        }
        this.suppressInternalOperations = config.isSuppressInternalOperations();
        this.suppressSynchronizationOperations = config.isSuppressSynchronizationOperations();
        this.currentConfig = config;
        config.addFileBasedAccessChangeListener(this);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(FileBasedAccessLogPublisherCfg config, List<String> unacceptableReasons) {
        Object policy;
        try {
            File logFile;
            if (!this.currentConfig.getLogFileMode().equalsIgnoreCase(config.getLogFileMode())) {
                FilePermission.decodeUNIXMode(config.getLogFileMode());
            }
            if (!this.currentConfig.getLogFile().equalsIgnoreCase(config.getLogFile()) && (logFile = StaticUtils.getFileForPath(config.getLogFile())).createNewFile()) {
                logFile.delete();
            }
        }
        catch (Exception e) {
            int msgID = 3408533;
            String message = MessageHandler.getMessage(msgID, config.dn().toString(), StaticUtils.stackTraceToSingleLineString(e));
            unacceptableReasons.add(message);
            return false;
        }
        for (DN dn : config.getRotationPolicyDN()) {
            policy = DirectoryServer.getRotationPolicy(dn);
            if (policy != null) continue;
            int msgID = 3408099;
            String message = MessageHandler.getMessage(msgID, dn.toString(), config.dn().toString());
            unacceptableReasons.add(message);
            return false;
        }
        for (DN dn : config.getRetentionPolicyDN()) {
            policy = DirectoryServer.getRetentionPolicy(dn);
            if (policy != null) continue;
            int msgID = 3277158;
            String message = MessageHandler.getMessage(msgID, dn.toString(), config.dn().toString());
            unacceptableReasons.add(message);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(FileBasedAccessLogPublisherCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        this.suppressInternalOperations = config.isSuppressInternalOperations();
        this.suppressSynchronizationOperations = config.isSuppressSynchronizationOperations();
        File logFile = StaticUtils.getFileForPath(config.getLogFile());
        TimeStampNaming fnPolicy = new TimeStampNaming(logFile);
        try {
            FilePermission perm = FilePermission.decodeUNIXMode(config.getLogFileMode());
            boolean writerAutoFlush = config.isAutoFlush() && !config.isAsynchronous();
            TextWriter currentWriter = this.writer instanceof AsyncronousTextWriter ? ((AsyncronousTextWriter)this.writer).getWrappedWriter() : this.writer;
            if (currentWriter instanceof MultifileTextWriter) {
                AsyncronousTextWriter asyncWriter;
                String message;
                int msgID;
                Object policy;
                MultifileTextWriter mfWriter = (MultifileTextWriter)currentWriter;
                mfWriter.setNamingPolicy(fnPolicy);
                mfWriter.setFilePermissions(perm);
                mfWriter.setAppend(config.isAppend());
                mfWriter.setAutoFlush(writerAutoFlush);
                mfWriter.setBufferSize((int)config.getBufferSize());
                mfWriter.setInterval(config.getTimeInterval());
                mfWriter.removeAllRetentionPolicies();
                mfWriter.removeAllRotationPolicies();
                for (DN dn : config.getRotationPolicyDN()) {
                    policy = DirectoryServer.getRotationPolicy(dn);
                    if (policy != null) {
                        mfWriter.addRotationPolicy((RotationPolicy)policy);
                        continue;
                    }
                    msgID = 3408099;
                    message = MessageHandler.getMessage(msgID, dn.toString(), config.dn().toString());
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    messages.add(message);
                }
                for (DN dn : config.getRetentionPolicyDN()) {
                    policy = DirectoryServer.getRetentionPolicy(dn);
                    if (policy != null) {
                        mfWriter.addRetentionPolicy((RetentionPolicy)policy);
                        continue;
                    }
                    msgID = 3277158;
                    message = MessageHandler.getMessage(msgID, dn.toString(), config.dn().toString());
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    messages.add(message);
                }
                if (this.writer instanceof AsyncronousTextWriter && !config.isAsynchronous()) {
                    asyncWriter = (AsyncronousTextWriter)this.writer;
                    this.writer = mfWriter;
                    asyncWriter.shutdown(false);
                }
                if (!(this.writer instanceof AsyncronousTextWriter) && config.isAsynchronous()) {
                    asyncWriter = new AsyncronousTextWriter("Asyncronous Text Writer for " + config.dn().toNormalizedString(), config.getQueueSize(), config.isAutoFlush(), mfWriter);
                    this.writer = asyncWriter;
                }
                if (this.currentConfig.isAsynchronous() && config.isAsynchronous() && this.currentConfig.getQueueSize() != config.getQueueSize()) {
                    adminActionRequired = true;
                }
                this.currentConfig = config;
            }
        }
        catch (Exception e) {
            int msgID = 3408533;
            String message = MessageHandler.getMessage(msgID, config.dn().toString(), StaticUtils.stackTraceToSingleLineString(e));
            resultCode = DirectoryServer.getServerErrorResultCode();
            messages.add(message);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public void close() {
        this.writer.shutdown();
        this.currentConfig.removeFileBasedAccessChangeListener(this);
    }

    @Override
    public void logConnect(ClientConnection clientConnection) {
    }

    @Override
    public void logDisconnect(ClientConnection clientConnection, DisconnectReason disconnectReason, String message) {
    }

    @Override
    public void logAbandonRequest(AbandonOperation abandonOperation) {
    }

    @Override
    public void logAbandonResult(AbandonOperation abandonOperation) {
    }

    @Override
    public void logAddRequest(AddOperation addOperation) {
    }

    @Override
    public void logAddResponse(AddOperation addOperation) {
        long connectionID = addOperation.getConnectionID();
        if (connectionID < 0L && (addOperation.isSynchronizationOperation() ? this.suppressSynchronizationOperations : this.suppressInternalOperations)) {
            return;
        }
        ResultCode code = addOperation.getResultCode();
        if (code == ResultCode.SUCCESS) {
            StringBuilder buffer = new StringBuilder(50);
            buffer.append("# ");
            buffer.append(TimeThread.getLocalTime());
            buffer.append(ServerConstants.EOL);
            buffer.append("dn:");
            this.encodeValue(addOperation.getEntryDN().toString(), buffer);
            buffer.append(ServerConstants.EOL);
            buffer.append("changetype: add");
            buffer.append(ServerConstants.EOL);
            for (String string : addOperation.getObjectClasses().values()) {
                buffer.append("objectClass: ");
                buffer.append(string);
                buffer.append(ServerConstants.EOL);
            }
            for (List list : addOperation.getUserAttributes().values()) {
                for (Attribute a : list) {
                    for (AttributeValue v : a.getValues()) {
                        buffer.append(a.getName());
                        buffer.append(":");
                        this.encodeValue(v.getValue(), buffer);
                        buffer.append(ServerConstants.EOL);
                    }
                }
            }
            for (List list : addOperation.getOperationalAttributes().values()) {
                for (Attribute a : list) {
                    for (AttributeValue v : a.getValues()) {
                        buffer.append(a.getName());
                        buffer.append(":");
                        this.encodeValue(v.getValue(), buffer);
                        buffer.append(ServerConstants.EOL);
                    }
                }
            }
            this.writer.writeRecord(buffer.toString());
        }
    }

    @Override
    public void logBindRequest(BindOperation bindOperation) {
    }

    @Override
    public void logBindResponse(BindOperation bindOperation) {
    }

    @Override
    public void logCompareRequest(CompareOperation compareOperation) {
    }

    @Override
    public void logCompareResponse(CompareOperation compareOperation) {
    }

    @Override
    public void logDeleteRequest(DeleteOperation deleteOperation) {
    }

    @Override
    public void logDeleteResponse(DeleteOperation deleteOperation) {
        long connectionID = deleteOperation.getConnectionID();
        if (connectionID < 0L && (deleteOperation.isSynchronizationOperation() ? this.suppressSynchronizationOperations : this.suppressInternalOperations)) {
            return;
        }
        ResultCode code = deleteOperation.getResultCode();
        if (code == ResultCode.SUCCESS) {
            StringBuilder buffer = new StringBuilder(50);
            buffer.append("# ");
            buffer.append(TimeThread.getLocalTime());
            buffer.append(ServerConstants.EOL);
            buffer.append("dn:");
            this.encodeValue(deleteOperation.getEntryDN().toString(), buffer);
            buffer.append(ServerConstants.EOL);
            buffer.append("changetype: delete");
            buffer.append(ServerConstants.EOL);
            this.writer.writeRecord(buffer.toString());
        }
    }

    @Override
    public void logExtendedRequest(ExtendedOperation extendedOperation) {
    }

    @Override
    public void logExtendedResponse(ExtendedOperation extendedOperation) {
    }

    @Override
    public void logModifyRequest(ModifyOperation modifyOperation) {
    }

    @Override
    public void logModifyResponse(ModifyOperation modifyOperation) {
        long connectionID = modifyOperation.getConnectionID();
        if (connectionID < 0L && (modifyOperation.isSynchronizationOperation() ? this.suppressSynchronizationOperations : this.suppressInternalOperations)) {
            return;
        }
        ResultCode code = modifyOperation.getResultCode();
        if (code == ResultCode.SUCCESS) {
            StringBuilder buffer = new StringBuilder(50);
            buffer.append("# ");
            buffer.append(TimeThread.getLocalTime());
            buffer.append(ServerConstants.EOL);
            buffer.append("dn:");
            this.encodeValue(modifyOperation.getEntryDN().toString(), buffer);
            buffer.append(ServerConstants.EOL);
            buffer.append("changetype: modify");
            buffer.append(ServerConstants.EOL);
            boolean first = true;
            block6: for (Modification mod : modifyOperation.getModifications()) {
                if (first) {
                    first = false;
                } else {
                    buffer.append("-");
                    buffer.append(ServerConstants.EOL);
                }
                switch (mod.getModificationType()) {
                    case ADD: {
                        buffer.append("add: ");
                        break;
                    }
                    case DELETE: {
                        buffer.append("delete: ");
                        break;
                    }
                    case REPLACE: {
                        buffer.append("replace: ");
                        break;
                    }
                    case INCREMENT: {
                        buffer.append("increment: ");
                        break;
                    }
                    default: {
                        continue block6;
                    }
                }
                Attribute a = mod.getAttribute();
                buffer.append(a.getName());
                buffer.append(ServerConstants.EOL);
                for (AttributeValue v : a.getValues()) {
                    buffer.append(a.getName());
                    buffer.append(":");
                    this.encodeValue(v.getValue(), buffer);
                    buffer.append(ServerConstants.EOL);
                }
            }
            this.writer.writeRecord(buffer.toString());
        }
    }

    @Override
    public void logModifyDNRequest(ModifyDNOperation modifyDNOperation) {
    }

    @Override
    public void logModifyDNResponse(ModifyDNOperation modifyDNOperation) {
        long connectionID = modifyDNOperation.getConnectionID();
        if (connectionID < 0L && (modifyDNOperation.isSynchronizationOperation() ? this.suppressSynchronizationOperations : this.suppressInternalOperations)) {
            return;
        }
        ResultCode code = modifyDNOperation.getResultCode();
        if (code == ResultCode.SUCCESS) {
            StringBuilder buffer = new StringBuilder(50);
            buffer.append("# ");
            buffer.append(TimeThread.getLocalTime());
            buffer.append(ServerConstants.EOL);
            buffer.append("dn:");
            this.encodeValue(modifyDNOperation.getEntryDN().toString(), buffer);
            buffer.append(ServerConstants.EOL);
            buffer.append("changetype: moddn");
            buffer.append(ServerConstants.EOL);
            buffer.append("newrdn:");
            this.encodeValue(modifyDNOperation.getNewRDN().toString(), buffer);
            buffer.append(ServerConstants.EOL);
            buffer.append("deleteoldrdn: ");
            if (modifyDNOperation.deleteOldRDN()) {
                buffer.append("1");
            } else {
                buffer.append("0");
            }
            buffer.append(ServerConstants.EOL);
            DN newSuperior = modifyDNOperation.getNewSuperior();
            if (newSuperior != null) {
                buffer.append("newsuperior:");
                this.encodeValue(newSuperior.toString(), buffer);
                buffer.append(ServerConstants.EOL);
            }
            this.writer.writeRecord(buffer.toString());
        }
    }

    @Override
    public void logSearchRequest(SearchOperation searchOperation) {
    }

    @Override
    public void logSearchResultEntry(SearchOperation searchOperation, SearchResultEntry searchEntry) {
    }

    @Override
    public void logSearchResultReference(SearchOperation searchOperation, SearchResultReference searchReference) {
    }

    @Override
    public void logSearchResultDone(SearchOperation searchOperation) {
    }

    @Override
    public void logUnbind(UnbindOperation unbindOperation) {
    }

    private void encodeValue(ByteString str, StringBuilder buffer) {
        byte[] byteVal = str.value();
        if (StaticUtils.needsBase64Encoding(byteVal)) {
            buffer.append(": ");
            buffer.append(Base64.encode(byteVal));
        } else {
            buffer.append(" ");
            str.toString(buffer);
        }
    }

    private void encodeValue(String str, StringBuilder buffer) {
        if (StaticUtils.needsBase64Encoding(str)) {
            buffer.append(": ");
            buffer.append(Base64.encode(StaticUtils.getBytes(str)));
        } else {
            buffer.append(" ");
            buffer.append(str);
        }
    }

    @Override
    public DN getDN() {
        if (this.currentConfig != null) {
            return this.currentConfig.dn();
        }
        return null;
    }
}

