/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.File;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DN;
import org.opends.server.util.StaticUtils;

public class LogPublisherErrorHandler {
    private DN publisherConfigDN;
    private boolean writeErroroccurred = false;

    public LogPublisherErrorHandler(DN publisherConfigDN) {
        this.publisherConfigDN = publisherConfigDN;
    }

    public void handleWriteError(String record, Throwable ex) {
        if (!this.writeErroroccurred) {
            int msgID = 0x440001;
            String msg = MessageHandler.getMessage(msgID, this.publisherConfigDN.toString(), StaticUtils.stackTraceToSingleLineString(ex));
            System.err.println(msg);
            this.writeErroroccurred = true;
        }
    }

    public void handleOpenError(File file, Throwable ex) {
        int msgID = 0x440002;
        String msg = MessageHandler.getMessage(msgID, file.toString(), this.publisherConfigDN.toString(), StaticUtils.stackTraceToSingleLineString(ex));
        System.err.println(msg);
    }

    public void handleCloseError(Throwable ex) {
        int msgID = 0x440003;
        String msg = MessageHandler.getMessage(msgID, this.publisherConfigDN.toString(), StaticUtils.stackTraceToSingleLineString(ex));
        System.err.println(msg);
    }

    public void handleFlushError(Throwable ex) {
        int msgID = 0x440004;
        String msg = MessageHandler.getMessage(msgID, this.publisherConfigDN.toString(), StaticUtils.stackTraceToSingleLineString(ex));
        System.err.println(msg);
    }
}

