/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.util.ArrayList;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogLevel {
    private static ArrayList<LogLevel> known = new ArrayList();
    public static final LogLevel DISABLED = new LogLevel("DISABLED", Integer.MAX_VALUE);
    public static final LogLevel ALL = new LogLevel("ALL", Integer.MIN_VALUE);
    private final String name;
    private final int value;

    protected LogLevel(String name, int value) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.value = value;
        known.add(this);
    }

    public String getName() {
        return this.name;
    }

    public final String toString() {
        return this.name;
    }

    public final int intValue() {
        return this.value;
    }

    public static synchronized LogLevel parse(String name) throws IllegalArgumentException {
        name.length();
        for (int i = 0; i < known.size(); ++i) {
            LogLevel l = known.get(i);
            if (!name.equalsIgnoreCase(l.name)) continue;
            return l;
        }
        try {
            int x = Integer.parseInt(name);
            for (int i = 0; i < known.size(); ++i) {
                LogLevel l = known.get(i);
                if (l.value != x) continue;
                return l;
            }
            return new LogLevel(name, x);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Bad level \"" + name + "\"");
        }
    }

    public boolean equals(Object ox) {
        try {
            LogLevel lx = (LogLevel)ox;
            return lx.value == this.value;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public int hashCode() {
        return this.value;
    }

    public static HashSet<String> getLevelStrings() {
        HashSet<String> strings = new HashSet<String>();
        for (int i = 0; i < known.size(); ++i) {
            strings.add(LogLevel.known.get((int)i).name.toLowerCase());
        }
        return strings;
    }
}

