/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.FreeDiskSpaceLogRetentionPolicyCfg;
import org.opends.server.loggers.FileComparator;
import org.opends.server.loggers.MultifileTextWriter;
import org.opends.server.loggers.RetentionPolicy;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeDiskSpaceRetentionPolicy
implements RetentionPolicy<FreeDiskSpaceLogRetentionPolicyCfg>,
ConfigurationChangeListener<FreeDiskSpaceLogRetentionPolicyCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private long freeDiskSpace = 0L;

    @Override
    public void initializeLogRetentionPolicy(FreeDiskSpaceLogRetentionPolicyCfg config) {
        this.freeDiskSpace = config.getFreeDiskSpace();
        config.addFreeDiskSpaceChangeListener(this);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(FreeDiskSpaceLogRetentionPolicyCfg config, List<String> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(FreeDiskSpaceLogRetentionPolicyCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        this.freeDiskSpace = config.getFreeDiskSpace();
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public int deleteFiles(MultifileTextWriter writer) {
        File[] files = writer.getNamingPolicy().listFiles();
        if (files.length <= 0) {
            return 0;
        }
        int count = 0;
        long freeSpace = 0L;
        try {
            Method meth = File.class.getMethod("getFreeSpace", new Class[0]);
            Object value = meth.invoke((Object)files[0], new Object[0]);
            freeSpace = (Long)value;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return 0;
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Current free disk space: %d, Required: %d", freeSpace, this.freeDiskSpace);
        }
        if (freeSpace > this.freeDiskSpace) {
            return 0;
        }
        long freeSpaceNeeded = this.freeDiskSpace - freeSpace;
        Arrays.sort(files, new FileComparator());
        long freedSpace = 0L;
        for (int j = files.length - 1; j < 1; --j) {
            freedSpace += files[j].length();
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Deleting log file:", files[j]);
            }
            files[j].delete();
            if (freedSpace >= freeSpaceNeeded) break;
            ++count;
        }
        return count;
    }
}

