/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.FixedTimeLogRotationPolicyCfg;
import org.opends.server.loggers.MultifileTextWriter;
import org.opends.server.loggers.RotationPolicy;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.ResultCode;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedTimeRotationPolicy
implements RotationPolicy<FixedTimeLogRotationPolicyCfg>,
ConfigurationChangeListener<FixedTimeLogRotationPolicyCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final long MS_IN_DAY = 86400000L;
    private long[] rotationTimes;

    @Override
    public void initializeLogRotationPolicy(FixedTimeLogRotationPolicyCfg config) {
        this.rotationTimes = new long[config.getTimeOfDay().size()];
        int i = 0;
        for (String time : config.getTimeOfDay()) {
            int hour = Integer.valueOf(time) / 100;
            int min = Integer.valueOf(time) - hour * 100;
            this.rotationTimes[i++] = hour * 3600 * 1000 + min * 60 * 1000;
        }
        Arrays.sort(this.rotationTimes);
        config.addFixedTimeChangeListener(this);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(FixedTimeLogRotationPolicyCfg config, List<String> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(FixedTimeLogRotationPolicyCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        this.rotationTimes = new long[config.getTimeOfDay().size()];
        int i = 0;
        for (String time : config.getTimeOfDay()) {
            int hour = Integer.valueOf(time) / 100;
            int min = Integer.valueOf(time) - hour * 100;
            this.rotationTimes[i++] = hour * 3600 * 1000 + min * 60 * 1000;
        }
        Arrays.sort(this.rotationTimes);
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean rotateFile(MultifileTextWriter writer) {
        long currTime = TimeThread.getTime();
        long lastRotationTime = writer.getLastRotationTime();
        long dayOfLastRotation = 86400000L * (lastRotationTime / 86400000L);
        long hourOfLastRotation = lastRotationTime - dayOfLastRotation;
        long hourOfNextRotation = 0L;
        for (long time : this.rotationTimes) {
            if (time <= hourOfLastRotation) continue;
            hourOfNextRotation = time;
            break;
        }
        if (hourOfNextRotation <= 0L) {
            hourOfNextRotation = this.rotationTimes[0] + 86400000L;
        }
        long nextRotationTime = dayOfLastRotation + hourOfNextRotation;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("The next fixed rotation time in %ds", (currTime - nextRotationTime) / 1000L);
        }
        return currTime > nextRotationTime;
    }
}

