/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.ServerShutdownListener;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.TextWriter;

public class AsyncronousTextWriter
implements ServerShutdownListener,
TextWriter {
    private final TextWriter writer;
    private final LinkedBlockingQueue<String> queue;
    private String name;
    private AtomicBoolean stopRequested;
    private WriterThread writerThread;
    private boolean autoFlush;

    public AsyncronousTextWriter(String name, int capacity, boolean autoFlush, TextWriter writer) {
        this.name = name;
        this.autoFlush = autoFlush;
        this.writer = writer;
        this.queue = new LinkedBlockingQueue(capacity);
        this.writerThread = null;
        this.stopRequested = new AtomicBoolean(false);
        this.writerThread = new WriterThread();
        this.writerThread.start();
        DirectoryServer.registerShutdownListener(this);
    }

    public void writeRecord(String record) {
        if (this.writer != null) {
            while (!this.stopRequested.get()) {
                try {
                    this.queue.put(record);
                    break;
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    public void flush() {
        this.writer.flush();
    }

    public long getBytesWritten() {
        return this.writer.getBytesWritten();
    }

    public TextWriter getWrappedWriter() {
        return this.writer;
    }

    public String getShutdownListenerName() {
        return "AsyncronousTextWriter Thread " + this.name;
    }

    public void processServerShutdown(String reason) {
        this.shutdown(false);
    }

    public void shutdown() {
        this.shutdown(true);
    }

    public void shutdown(boolean shutdownWrapped) {
        this.stopRequested.set(true);
        while (this.writerThread != null && this.writerThread.isAlive()) {
            try {
                this.writerThread.interrupt();
                this.writerThread.join();
            }
            catch (InterruptedException ex) {}
        }
        while (!this.queue.isEmpty()) {
            String message = this.queue.poll();
            this.writer.writeRecord(message);
        }
        if (shutdownWrapped && this.writer != null) {
            this.writer.shutdown();
        }
        DirectoryServer.deregisterShutdownListener(this);
    }

    public void setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
    }

    private class WriterThread
    extends DirectoryThread {
        public WriterThread() {
            super(AsyncronousTextWriter.this.name);
        }

        public void run() {
            String message = null;
            while (!AsyncronousTextWriter.this.stopRequested.get() || !AsyncronousTextWriter.this.queue.isEmpty()) {
                try {
                    message = (String)AsyncronousTextWriter.this.queue.poll(10L, TimeUnit.SECONDS);
                    if (message == null) continue;
                    do {
                        AsyncronousTextWriter.this.writer.writeRecord(message);
                    } while ((message = (String)AsyncronousTextWriter.this.queue.poll()) != null);
                    if (!AsyncronousTextWriter.this.autoFlush) continue;
                    AsyncronousTextWriter.this.flush();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

