/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import org.opends.server.admin.std.server.ExtendedOperationHandlerCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ExtendedOperationHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhoAmIExtendedOperation
extends ExtendedOperationHandler<ExtendedOperationHandlerCfg> {
    @Override
    public void initializeExtendedOperationHandler(ExtendedOperationHandlerCfg config) throws ConfigException, InitializationException {
        DirectoryServer.registerSupportedExtension("1.3.6.1.4.1.4203.1.11.3", this);
        this.registerControlsAndFeatures();
    }

    @Override
    public void finalizeExtendedOperationHandler() {
        DirectoryServer.deregisterSupportedExtension("1.3.6.1.4.1.4203.1.11.3");
        this.deregisterControlsAndFeatures();
    }

    @Override
    public void processExtendedOperation(ExtendedOperation operation) {
        ClientConnection clientConnection = operation.getClientConnection();
        if (clientConnection == null) {
            operation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
            int msgID = 1310997;
            operation.appendErrorMessage(MessageHandler.getMessage(msgID));
            return;
        }
        AuthenticationInfo authInfo = clientConnection.getAuthenticationInfo();
        if (authInfo == null || authInfo.getAuthenticationDN() == null) {
            operation.setResultCode(ResultCode.SUCCESS);
            operation.setResponseValue(new ASN1OctetString());
            return;
        }
        operation.setResultCode(ResultCode.SUCCESS);
        operation.setResponseValue(new ASN1OctetString("dn:" + authInfo.getAuthenticationDN().toString()));
    }
}

