/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.TraditionalWorkQueueCfg;
import org.opends.server.api.WorkQueue;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.TraditionalWorkerThread;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.monitors.TraditionalWorkQueueMonitor;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraditionalWorkQueue
extends WorkQueue<TraditionalWorkQueueCfg>
implements ConfigurationChangeListener<TraditionalWorkQueueCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final int MAX_RETRY_COUNT = 5;
    private ArrayList<TraditionalWorkerThread> workerThreads;
    private AtomicLong opsSubmitted;
    private AtomicLong queueFullRejects;
    private boolean killThreads;
    private boolean shutdownRequested;
    private DN configEntryDN;
    private int lastThreadNumber;
    private int maxCapacity;
    private int numWorkerThreads;
    private LinkedBlockingQueue<AbstractOperation> opQueue;
    private ReentrantLock queueLock;

    @Override
    public void initializeWorkQueue(TraditionalWorkQueueCfg configuration) throws ConfigException, InitializationException {
        this.shutdownRequested = false;
        this.killThreads = false;
        this.opsSubmitted = new AtomicLong(0L);
        this.queueFullRejects = new AtomicLong(0L);
        this.queueLock = new ReentrantLock();
        configuration.addTraditionalChangeListener(this);
        this.configEntryDN = configuration.dn();
        this.numWorkerThreads = configuration.getNumWorkerThreads();
        this.maxCapacity = configuration.getMaxWorkQueueCapacity();
        this.opQueue = this.maxCapacity > 0 ? new LinkedBlockingQueue(this.maxCapacity) : new LinkedBlockingQueue();
        this.workerThreads = new ArrayList(this.numWorkerThreads);
        this.lastThreadNumber = 0;
        while (this.lastThreadNumber < this.numWorkerThreads) {
            TraditionalWorkerThread t = new TraditionalWorkerThread(this, this.lastThreadNumber);
            t.start();
            this.workerThreads.add(t);
            ++this.lastThreadNumber;
        }
        try {
            TraditionalWorkQueueMonitor monitor = new TraditionalWorkQueueMonitor(this);
            monitor.initializeMonitorProvider(null);
            monitor.start();
            DirectoryServer.registerMonitorProvider(monitor);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 3407967;
            String message = MessageHandler.getMessage(msgID, TraditionalWorkQueueMonitor.class, String.valueOf(e));
            ErrorLogger.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
        }
    }

    @Override
    public void finalizeWorkQueue(String reason) {
        this.shutdownRequested = true;
        CancelRequest cancelRequest = new CancelRequest(true, reason);
        ArrayList pendingOperations = new ArrayList();
        this.opQueue.removeAll(pendingOperations);
        for (Operation o : pendingOperations) {
            try {
                o.cancel(cancelRequest);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                ErrorLogger.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, 65651, String.valueOf(o), String.valueOf(e));
            }
        }
        for (TraditionalWorkerThread t : this.workerThreads) {
            try {
                t.shutDown();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                ErrorLogger.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, 65652, t.getName(), String.valueOf(e));
            }
        }
    }

    public boolean shutdownRequested() {
        return this.shutdownRequested;
    }

    @Override
    public void submitOperation(AbstractOperation operation) throws DirectoryException {
        if (this.shutdownRequested) {
            int messageID = 65647;
            String message = MessageHandler.getMessage(messageID);
            throw new DirectoryException(ResultCode.UNAVAILABLE, message, messageID);
        }
        if (!this.opQueue.offer(operation)) {
            this.queueFullRejects.incrementAndGet();
            int messageID = 131184;
            String message = MessageHandler.getMessage(messageID, this.maxCapacity);
            throw new DirectoryException(ResultCode.UNAVAILABLE, message, messageID);
        }
        this.opsSubmitted.incrementAndGet();
    }

    public AbstractOperation nextOperation(TraditionalWorkerThread workerThread) {
        return this.retryNextOperation(workerThread, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AbstractOperation retryNextOperation(TraditionalWorkerThread workerThread, int numFailures) {
        if (this.killThreads) {
            this.queueLock.lock();
            try {
                int currentThreads = this.workerThreads.size();
                if (currentThreads > this.numWorkerThreads) {
                    if (this.workerThreads.remove(Thread.currentThread())) {
                        --currentThreads;
                    }
                    if (currentThreads <= this.numWorkerThreads) {
                        this.killThreads = false;
                    }
                    workerThread.setStoppedByReducedThreadNumber();
                    AbstractOperation abstractOperation = null;
                    return abstractOperation;
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            finally {
                this.queueLock.unlock();
            }
        }
        if (this.shutdownRequested || numFailures > 5) {
            if (numFailures <= 5) return null;
            int msgID = 3407966;
            String message = MessageHandler.getMessage(msgID, Thread.currentThread().getName(), numFailures, 5);
            ErrorLogger.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            return null;
        }
        try {
            AbstractOperation nextOperation;
            while ((nextOperation = this.opQueue.poll(5L, TimeUnit.SECONDS)) == null) {
                if (this.shutdownRequested) {
                    return null;
                }
                if (!this.killThreads) continue;
                this.queueLock.lock();
                try {
                    int currentThreads = this.workerThreads.size();
                    if (currentThreads <= this.numWorkerThreads) continue;
                    if (this.workerThreads.remove(Thread.currentThread())) {
                        --currentThreads;
                    }
                    if (currentThreads <= this.numWorkerThreads) {
                        this.killThreads = false;
                    }
                    workerThread.setStoppedByReducedThreadNumber();
                    AbstractOperation abstractOperation = null;
                    return abstractOperation;
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                finally {
                    this.queueLock.unlock();
                }
            }
            return nextOperation;
        }
        catch (InterruptedException ie) {
            if (this.shutdownRequested) {
                return null;
            }
            ErrorLogger.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, 131185, Thread.currentThread().getName(), String.valueOf(ie));
            return this.retryNextOperation(workerThread, numFailures + 1);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            ErrorLogger.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, 131186, Thread.currentThread().getName(), String.valueOf(e));
            return this.retryNextOperation(workerThread, numFailures + 1);
        }
    }

    public boolean removeOperation(AbstractOperation operation) {
        return this.opQueue.remove(operation);
    }

    public long getOpsSubmitted() {
        return this.opsSubmitted.longValue();
    }

    public long getOpsRejectedDueToQueueFull() {
        return this.queueFullRejects.longValue();
    }

    public int size() {
        return this.opQueue.size();
    }

    @Override
    public boolean isConfigurationChangeAcceptable(TraditionalWorkQueueCfg configuration, List<String> unacceptableReasons) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigChangeResult applyConfigurationChange(TraditionalWorkQueueCfg configuration) {
        ArrayList<String> resultMessages = new ArrayList<String>();
        int newNumThreads = configuration.getNumWorkerThreads();
        int newMaxCapacity = configuration.getMaxWorkQueueCapacity();
        int currentThreads = this.workerThreads.size();
        if (newNumThreads != currentThreads) {
            this.queueLock.lock();
            try {
                int threadsToAdd = newNumThreads - currentThreads;
                if (threadsToAdd > 0) {
                    for (int i = 0; i < threadsToAdd; ++i) {
                        TraditionalWorkerThread t = new TraditionalWorkerThread(this, this.lastThreadNumber++);
                        this.workerThreads.add(t);
                        t.start();
                    }
                    this.killThreads = false;
                } else {
                    this.killThreads = true;
                }
                this.numWorkerThreads = newNumThreads;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            finally {
                this.queueLock.unlock();
            }
        }
        if (newMaxCapacity != this.maxCapacity) {
            this.queueLock.lock();
            try {
                LinkedBlockingQueue<AbstractOperation> newOpQueue = newMaxCapacity > 0 ? new LinkedBlockingQueue(newMaxCapacity) : new LinkedBlockingQueue<AbstractOperation>();
                LinkedBlockingQueue<AbstractOperation> oldOpQueue = this.opQueue;
                this.opQueue = newOpQueue;
                LinkedList pendingOps = new LinkedList();
                oldOpQueue.drainTo(pendingOps);
                while (!pendingOps.isEmpty()) {
                    Iterator iterator = pendingOps.iterator();
                    while (iterator.hasNext()) {
                        AbstractOperation o = (AbstractOperation)iterator.next();
                        try {
                            if (!newOpQueue.offer(o, 1000L, TimeUnit.MILLISECONDS)) continue;
                            iterator.remove();
                        }
                        catch (InterruptedException ie) {
                            if (!DebugLogger.debugEnabled()) continue;
                            TRACER.debugCaught(DebugLogLevel.ERROR, ie);
                        }
                    }
                }
                this.maxCapacity = newMaxCapacity;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            finally {
                this.queueLock.unlock();
            }
        }
        return new ConfigChangeResult(ResultCode.SUCCESS, false, resultMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIdle() {
        if (this.opQueue.size() > 0) {
            return false;
        }
        this.queueLock.lock();
        try {
            for (TraditionalWorkerThread t : this.workerThreads) {
                if (!t.isActive()) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.queueLock.unlock();
        }
    }
}

