/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.CertificateMapperCfg;
import org.opends.server.admin.std.server.SubjectAttributeToUserAttributeCertificateMapperCfg;
import org.opends.server.api.CertificateMapper;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.RDN;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubjectAttributeToUserAttributeCertificateMapper
extends CertificateMapper<SubjectAttributeToUserAttributeCertificateMapperCfg>
implements ConfigurationChangeListener<SubjectAttributeToUserAttributeCertificateMapperCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DN configEntryDN;
    private LinkedHashMap<String, AttributeType> attributeMap;
    private SubjectAttributeToUserAttributeCertificateMapperCfg currentConfig;

    @Override
    public void initializeCertificateMapper(SubjectAttributeToUserAttributeCertificateMapperCfg configuration) throws ConfigException, InitializationException {
        configuration.addSubjectAttributeToUserAttributeChangeListener(this);
        this.currentConfig = configuration;
        this.configEntryDN = configuration.dn();
        this.attributeMap = new LinkedHashMap();
        for (String mapStr : configuration.getSubjectAttributeMapping()) {
            String message;
            String lowerMap = StaticUtils.toLowerCase(mapStr);
            int colonPos = lowerMap.indexOf(58);
            if (colonPos <= 0) {
                int msgID = 1311142;
                String message2 = MessageHandler.getMessage(msgID, String.valueOf(this.configEntryDN), mapStr);
                throw new ConfigException(msgID, message2);
            }
            String certAttrName = lowerMap.substring(0, colonPos).trim();
            String userAttrName = lowerMap.substring(colonPos + 1).trim();
            if (certAttrName.length() == 0 || userAttrName.length() == 0) {
                int msgID = 1311142;
                message = MessageHandler.getMessage(msgID, String.valueOf(this.configEntryDN), mapStr);
                throw new ConfigException(msgID, message);
            }
            if (this.attributeMap.containsKey(certAttrName)) {
                int msgID = 1311143;
                message = MessageHandler.getMessage(msgID, String.valueOf(this.configEntryDN), certAttrName);
                throw new ConfigException(msgID, message);
            }
            AttributeType userAttrType = DirectoryServer.getAttributeType(userAttrName, false);
            if (userAttrType == null) {
                int msgID = 1311144;
                String message3 = MessageHandler.getMessage(msgID, mapStr, String.valueOf(this.configEntryDN), userAttrName);
                throw new ConfigException(msgID, message3);
            }
            for (AttributeType attrType : this.attributeMap.values()) {
                if (!attrType.equals(userAttrType)) continue;
                int msgID = 1311145;
                String message4 = MessageHandler.getMessage(msgID, String.valueOf(this.configEntryDN), attrType.getNameOrOID());
                throw new ConfigException(msgID, message4);
            }
            this.attributeMap.put(certAttrName, userAttrType);
        }
    }

    @Override
    public void finalizeCertificateMapper() {
        this.currentConfig.removeSubjectAttributeToUserAttributeChangeListener(this);
    }

    @Override
    public Entry mapCertificateToUser(Certificate[] certificateChain) throws DirectoryException {
        DN peerDN;
        X509Certificate peerCertificate;
        SubjectAttributeToUserAttributeCertificateMapperCfg config = this.currentConfig;
        LinkedHashMap<String, AttributeType> attributeMap = this.attributeMap;
        if (certificateChain == null || certificateChain.length == 0) {
            int msgID = 1311149;
            String message = MessageHandler.getMessage(msgID);
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message, msgID);
        }
        try {
            peerCertificate = (X509Certificate)certificateChain[0];
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 1311150;
            String message = MessageHandler.getMessage(msgID, String.valueOf(certificateChain[0].getType()));
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message, msgID);
        }
        X500Principal peerPrincipal = peerCertificate.getSubjectX500Principal();
        String peerName = peerPrincipal.getName("RFC2253");
        try {
            peerDN = DN.decode(peerName);
        }
        catch (DirectoryException de) {
            int msgID = 1311151;
            String message = MessageHandler.getMessage(msgID, peerName, de.getErrorMessage());
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message, msgID, de);
        }
        LinkedList<SearchFilter> filterComps = new LinkedList<SearchFilter>();
        for (int i = 0; i < peerDN.getNumComponents(); ++i) {
            RDN rdn = peerDN.getRDN(i);
            for (int j = 0; j < rdn.getNumValues(); ++j) {
                String lowerName = StaticUtils.toLowerCase(rdn.getAttributeName(j));
                AttributeType attrType = attributeMap.get(lowerName);
                if (attrType == null) continue;
                filterComps.add(SearchFilter.createEqualityFilter(attrType, rdn.getAttributeValue(j)));
            }
        }
        if (filterComps.isEmpty()) {
            int msgID = 1311152;
            String message = MessageHandler.getMessage(msgID, peerName);
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message, msgID);
        }
        SearchFilter filter = SearchFilter.createANDFilter(filterComps);
        Set<DN> baseDNs = config.getUserBaseDN();
        if (baseDNs == null || baseDNs.isEmpty()) {
            baseDNs = DirectoryServer.getPublicNamingContexts().keySet();
        }
        SearchResultEntry userEntry = null;
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        for (DN baseDN : baseDNs) {
            InternalSearchOperation searchOperation = conn.processSearch(baseDN, SearchScope.WHOLE_SUBTREE, filter);
            for (SearchResultEntry entry : searchOperation.getSearchEntries()) {
                if (userEntry == null) {
                    userEntry = entry;
                    continue;
                }
                int msgID = 1311153;
                String message = MessageHandler.getMessage(msgID, peerName, String.valueOf(userEntry.getDN()), String.valueOf(entry.getDN()));
                throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message, msgID);
            }
        }
        return userEntry;
    }

    @Override
    public boolean isConfigurationAcceptable(CertificateMapperCfg configuration, List<String> unacceptableReasons) {
        SubjectAttributeToUserAttributeCertificateMapperCfg config = (SubjectAttributeToUserAttributeCertificateMapperCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(SubjectAttributeToUserAttributeCertificateMapperCfg configuration, List<String> unacceptableReasons) {
        boolean configAcceptable = true;
        DN cfgEntryDN = configuration.dn();
        LinkedHashMap<String, AttributeType> newAttributeMap = new LinkedHashMap<String, AttributeType>();
        block0: for (String mapStr : configuration.getSubjectAttributeMapping()) {
            String lowerMap = StaticUtils.toLowerCase(mapStr);
            int colonPos = lowerMap.indexOf(58);
            if (colonPos <= 0) {
                int msgID = 1311142;
                unacceptableReasons.add(MessageHandler.getMessage(msgID, String.valueOf(cfgEntryDN), mapStr));
                configAcceptable = false;
                break;
            }
            String certAttrName = lowerMap.substring(0, colonPos).trim();
            String userAttrName = lowerMap.substring(colonPos + 1).trim();
            if (certAttrName.length() == 0 || userAttrName.length() == 0) {
                int msgID = 1311142;
                unacceptableReasons.add(MessageHandler.getMessage(msgID, String.valueOf(cfgEntryDN), mapStr));
                configAcceptable = false;
                break;
            }
            if (newAttributeMap.containsKey(certAttrName)) {
                int msgID = 1311143;
                unacceptableReasons.add(MessageHandler.getMessage(msgID, String.valueOf(cfgEntryDN), certAttrName));
                configAcceptable = false;
                break;
            }
            AttributeType userAttrType = DirectoryServer.getAttributeType(userAttrName, false);
            if (userAttrType == null) {
                int msgID = 1311144;
                unacceptableReasons.add(MessageHandler.getMessage(msgID, mapStr, String.valueOf(cfgEntryDN), userAttrName));
                configAcceptable = false;
                break;
            }
            for (AttributeType attrType : newAttributeMap.values()) {
                if (!attrType.equals(userAttrType)) continue;
                int msgID = 1311145;
                unacceptableReasons.add(MessageHandler.getMessage(msgID, String.valueOf(cfgEntryDN), attrType.getNameOrOID()));
                configAcceptable = false;
                break block0;
            }
            newAttributeMap.put(certAttrName, userAttrType);
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(SubjectAttributeToUserAttributeCertificateMapperCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        LinkedHashMap<String, AttributeType> newAttributeMap = new LinkedHashMap<String, AttributeType>();
        block0: for (String mapStr : configuration.getSubjectAttributeMapping()) {
            String lowerMap = StaticUtils.toLowerCase(mapStr);
            int colonPos = lowerMap.indexOf(58);
            if (colonPos <= 0) {
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = ResultCode.CONSTRAINT_VIOLATION;
                }
                int msgID = 1311142;
                messages.add(MessageHandler.getMessage(msgID, String.valueOf(this.configEntryDN), mapStr));
                break;
            }
            String certAttrName = lowerMap.substring(0, colonPos).trim();
            String userAttrName = lowerMap.substring(colonPos + 1).trim();
            if (certAttrName.length() == 0 || userAttrName.length() == 0) {
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = ResultCode.CONSTRAINT_VIOLATION;
                }
                int msgID = 1311142;
                messages.add(MessageHandler.getMessage(msgID, String.valueOf(this.configEntryDN), mapStr));
                break;
            }
            if (newAttributeMap.containsKey(certAttrName)) {
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = ResultCode.CONSTRAINT_VIOLATION;
                }
                int msgID = 1311143;
                messages.add(MessageHandler.getMessage(msgID, String.valueOf(this.configEntryDN), certAttrName));
                break;
            }
            AttributeType userAttrType = DirectoryServer.getAttributeType(userAttrName, false);
            if (userAttrType == null) {
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = ResultCode.CONSTRAINT_VIOLATION;
                }
                int msgID = 1311144;
                messages.add(MessageHandler.getMessage(msgID, mapStr, String.valueOf(this.configEntryDN), userAttrName));
                break;
            }
            for (AttributeType attrType : newAttributeMap.values()) {
                if (!attrType.equals(userAttrType)) continue;
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = ResultCode.CONSTRAINT_VIOLATION;
                }
                int msgID = 1311145;
                messages.add(MessageHandler.getMessage(msgID, String.valueOf(this.configEntryDN), attrType.getNameOrOID()));
                break block0;
            }
            newAttributeMap.put(certAttrName, userAttrType);
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.attributeMap = newAttributeMap;
            this.currentConfig = configuration;
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

