/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import org.opends.server.admin.std.server.ExtendedOperationHandlerCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ExtendedOperationHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.extensions.TLSCapableConnection;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartTLSExtendedOperation
extends ExtendedOperationHandler<ExtendedOperationHandlerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    @Override
    public void initializeExtendedOperationHandler(ExtendedOperationHandlerCfg config) throws ConfigException, InitializationException {
        DirectoryServer.registerSupportedExtension("1.3.6.1.4.1.1466.20037", this);
        this.registerControlsAndFeatures();
    }

    @Override
    public void finalizeExtendedOperationHandler() {
        DirectoryServer.deregisterSupportedExtension("1.3.6.1.4.1.1466.20037");
        this.deregisterControlsAndFeatures();
    }

    @Override
    public void processExtendedOperation(ExtendedOperation operation) {
        operation.setResponseOID("1.3.6.1.4.1.1466.20037");
        ClientConnection clientConnection = operation.getClientConnection();
        if (clientConnection == null) {
            operation.setResultCode(ResultCode.UNAVAILABLE);
            int msgID = 1245312;
            operation.appendErrorMessage(MessageHandler.getMessage(msgID));
            return;
        }
        if (!(clientConnection instanceof TLSCapableConnection)) {
            operation.setResultCode(ResultCode.UNAVAILABLE);
            int msgID = 1245313;
            operation.appendErrorMessage(MessageHandler.getMessage(msgID));
            return;
        }
        TLSCapableConnection tlsCapableConnection = (TLSCapableConnection)((Object)clientConnection);
        StringBuilder unavailableReason = new StringBuilder();
        if (!tlsCapableConnection.tlsProtectionAvailable(unavailableReason)) {
            operation.setResultCode(ResultCode.UNAVAILABLE);
            operation.setErrorMessage(unavailableReason);
            return;
        }
        try {
            tlsCapableConnection.enableTLSConnectionSecurityProvider();
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            ErrorLogger.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.MILD_ERROR, 1245314, StaticUtils.getExceptionMessage(de));
        }
        operation.setResultCode(ResultCode.SUCCESS);
        try {
            tlsCapableConnection.sendClearResponse(operation);
            operation.setResponseSent();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            ErrorLogger.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.MILD_ERROR, 1245563, StaticUtils.getExceptionMessage(e));
            clientConnection.disconnect(DisconnectReason.SECURITY_PROBLEM, false, 1245563, StaticUtils.getExceptionMessage(e));
        }
    }
}

