/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.MemberList;
import org.opends.server.types.MembershipException;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleStaticGroupMemberList
extends MemberList {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DN groupDN;
    private Iterator<DN> memberDNIterator;
    private LinkedList<DN> memberDNs;

    public SimpleStaticGroupMemberList(DN groupDN, Set<DN> memberDNs) {
        Validator.ensureNotNull(groupDN, memberDNs);
        this.groupDN = groupDN;
        this.memberDNs = new LinkedList<DN>(memberDNs);
        this.memberDNIterator = memberDNs.iterator();
    }

    @Override
    public boolean hasMoreMembers() {
        return this.memberDNIterator.hasNext();
    }

    @Override
    public DN nextMemberDN() throws MembershipException {
        if (this.memberDNIterator.hasNext()) {
            return this.memberDNIterator.next();
        }
        return null;
    }

    @Override
    public Entry nextMemberEntry() throws MembershipException {
        if (this.memberDNIterator.hasNext()) {
            DN memberDN = this.memberDNIterator.next();
            try {
                Entry memberEntry = DirectoryConfig.getEntry(memberDN);
                if (memberEntry == null) {
                    int msgID = 1245567;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(memberDN), String.valueOf(this.groupDN));
                    throw new MembershipException(msgID, message, true);
                }
                return memberEntry;
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                int msgID = 1245568;
                String message = MessageHandler.getMessage(msgID, String.valueOf(memberDN), String.valueOf(this.groupDN), String.valueOf(de.getErrorMessage()));
                throw new MembershipException(msgID, message, true, de);
            }
        }
        return null;
    }

    @Override
    public void close() {
    }
}

