/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.List;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.AlertHandlerCfg;
import org.opends.server.admin.std.server.SMTPAlertHandlerCfg;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.AlertHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.EMailMessage;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMTPAlertHandler
implements AlertHandler<SMTPAlertHandlerCfg>,
ConfigurationChangeListener<SMTPAlertHandlerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private SMTPAlertHandlerCfg currentConfig;

    @Override
    public void initializeAlertHandler(SMTPAlertHandlerCfg configuration) throws ConfigException, InitializationException {
        if (DirectoryServer.getMailServerPropertySets() == null || DirectoryServer.getMailServerPropertySets().isEmpty()) {
            int msgID = 1245715;
            String message = MessageHandler.getMessage(msgID);
            throw new ConfigException(msgID, message);
        }
        configuration.addSMTPChangeListener(this);
        this.currentConfig = configuration;
    }

    @Override
    public AlertHandlerCfg getAlertHandlerConfiguration() {
        return this.currentConfig;
    }

    @Override
    public boolean isConfigurationAcceptable(AlertHandlerCfg configuration, List<String> unacceptableReasons) {
        return true;
    }

    @Override
    public void finalizeAlertHandler() {
    }

    @Override
    public void sendAlertNotification(AlertGenerator generator, String alertType, int alertID, String alertMessage) {
        SMTPAlertHandlerCfg cfg = this.currentConfig;
        ArrayList<String> recipients = new ArrayList<String>(cfg.getRecipientAddress());
        String alertIDStr = String.valueOf(alertID);
        String subject = this.replaceTokens(cfg.getMessageSubject(), alertType, alertIDStr, alertMessage);
        String body = this.replaceTokens(cfg.getMessageBody(), alertType, alertIDStr, alertMessage);
        EMailMessage message = new EMailMessage(cfg.getSenderAddress(), recipients, subject);
        message.setBody(StaticUtils.wrapText(body, 75));
        try {
            message.send();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 1180180;
            String msg = MessageHandler.getMessage(msgID, alertType, alertMessage, StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, msg, msgID);
        }
    }

    private String replaceTokens(String s, String alertType, String alertID, String alertMessage) {
        return s.replace("%%alert-type%%", alertType).replace("%%alert-id%%", alertID).replace("%%alert-message%%", alertMessage).replace("\\n", "\r\n");
    }

    @Override
    public boolean isConfigurationChangeAcceptable(SMTPAlertHandlerCfg configuration, List<String> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(SMTPAlertHandlerCfg configuration) {
        this.currentConfig = configuration;
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }
}

