/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.security.MessageDigest;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.admin.std.server.PasswordStorageSchemeCfg;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringFactory;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.Base64;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SHA1PasswordStorageScheme
extends PasswordStorageScheme<PasswordStorageSchemeCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.extensions.SHA1PasswordStorageScheme";
    private MessageDigest messageDigest;
    private ReentrantLock digestLock;

    @Override
    public void initializePasswordStorageScheme(PasswordStorageSchemeCfg configuration) throws ConfigException, InitializationException {
        try {
            this.messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 0x140001;
            String message = MessageHandler.getMessage(msgID, "SHA-1", String.valueOf(e));
            throw new InitializationException(msgID, message, e);
        }
        this.digestLock = new ReentrantLock();
    }

    @Override
    public String getStorageSchemeName() {
        return "SHA";
    }

    @Override
    public ByteString encodePassword(ByteString plaintext) throws DirectoryException {
        byte[] digestBytes;
        this.digestLock.lock();
        try {
            digestBytes = this.messageDigest.digest(plaintext.value());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 1245189;
            String message = MessageHandler.getMessage(msgID, CLASS_NAME, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
        }
        finally {
            this.digestLock.unlock();
        }
        return ByteStringFactory.create(Base64.encode(digestBytes));
    }

    @Override
    public ByteString encodePasswordWithScheme(ByteString plaintext) throws DirectoryException {
        byte[] digestBytes;
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        buffer.append("SHA");
        buffer.append('}');
        this.digestLock.lock();
        try {
            digestBytes = this.messageDigest.digest(plaintext.value());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 1245189;
            String message = MessageHandler.getMessage(msgID, CLASS_NAME, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
        }
        finally {
            this.digestLock.unlock();
        }
        buffer.append(Base64.encode(digestBytes));
        return ByteStringFactory.create(buffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean passwordMatches(ByteString plaintextPassword, ByteString storedPassword) {
        byte[] storedPWDigestBytes;
        byte[] userPWDigestBytes;
        this.digestLock.lock();
        try {
            userPWDigestBytes = this.messageDigest.digest(plaintextPassword.value());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.digestLock.unlock();
        }
        try {
            storedPWDigestBytes = Base64.decode(storedPassword.stringValue());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            ErrorLogger.logError(ErrorLogCategory.EXTENSIONS, ErrorLogSeverity.MILD_ERROR, 1245186, storedPassword.stringValue(), String.valueOf(e));
            return false;
        }
        return Arrays.equals(userPWDigestBytes, storedPWDigestBytes);
    }

    @Override
    public boolean supportsAuthPasswordSyntax() {
        return false;
    }

    @Override
    public ByteString encodeAuthPassword(ByteString plaintext) throws DirectoryException {
        int msgID = 1245514;
        String message = MessageHandler.getMessage(msgID, this.getStorageSchemeName());
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public boolean authPasswordMatches(ByteString plaintextPassword, String authInfo, String authValue) {
        return false;
    }

    @Override
    public boolean isReversible() {
        return false;
    }

    @Override
    public ByteString getPlaintextValue(ByteString storedPassword) throws DirectoryException {
        int msgID = 0x130003;
        String message = MessageHandler.getMessage(msgID, "SHA");
        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
    }

    @Override
    public ByteString getAuthPasswordPlaintextValue(String authInfo, String authValue) throws DirectoryException {
        int msgID = 1245514;
        String message = MessageHandler.getMessage(msgID, this.getStorageSchemeName());
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public boolean isStorageSchemeSecure() {
        return true;
    }
}

