/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.PlainSASLMechanismHandlerCfg;
import org.opends.server.admin.std.server.SASLMechanismHandlerCfg;
import org.opends.server.api.IdentityMapper;
import org.opends.server.api.SASLMechanismHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.BindOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LockManager;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainSASLMechanismHandler
extends SASLMechanismHandler<PlainSASLMechanismHandlerCfg>
implements ConfigurationChangeListener<PlainSASLMechanismHandlerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DN configEntryDN;
    private IdentityMapper identityMapper;
    private PlainSASLMechanismHandlerCfg currentConfig;

    @Override
    public void initializeSASLMechanismHandler(PlainSASLMechanismHandlerCfg configuration) throws ConfigException, InitializationException {
        configuration.addPlainChangeListener(this);
        this.currentConfig = configuration;
        this.configEntryDN = configuration.dn();
        DN identityMapperDN = configuration.getIdentityMapperDN();
        this.identityMapper = DirectoryServer.getIdentityMapper(identityMapperDN);
        if (this.identityMapper == null) {
            int msgID = 1245507;
            String message = MessageHandler.getMessage(msgID, String.valueOf(identityMapperDN), String.valueOf(this.configEntryDN));
            throw new ConfigException(msgID, message);
        }
        DirectoryServer.registerSASLMechanismHandler("PLAIN", this);
    }

    @Override
    public void finalizeSASLMechanismHandler() {
        this.currentConfig.removePlainChangeListener(this);
        DirectoryServer.deregisterSASLMechanismHandler("PLAIN");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void processSASLBind(BindOperation bindOperation) {
        Entry authZEntry;
        Entry userEntry;
        String password;
        block48: {
            AuthenticationInfo tempAuthInfo;
            InternalClientConnection tempConn;
            String lowerAuthzID;
            int msgID;
            String authzID;
            IdentityMapper identityMapper;
            block49: {
                DN authzDN;
                DN userDN;
                int nullPos2;
                identityMapper = this.identityMapper;
                authzID = null;
                String authcID = null;
                password = null;
                ASN1OctetString saslCredentials = bindOperation.getSASLCredentials();
                if (saslCredentials == null) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int msgID2 = 1245331;
                    String message = MessageHandler.getMessage(msgID2);
                    bindOperation.setAuthFailureReason(msgID2, message);
                    return;
                }
                String credString = saslCredentials.stringValue();
                int length = credString.length();
                int nullPos1 = credString.indexOf(0);
                if (nullPos1 < 0) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int msgID3 = 1245332;
                    String message = MessageHandler.getMessage(msgID3);
                    bindOperation.setAuthFailureReason(msgID3, message);
                    return;
                }
                if (nullPos1 > 0) {
                    authzID = credString.substring(0, nullPos1);
                }
                if ((nullPos2 = credString.indexOf(0, nullPos1 + 1)) < 0) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int msgID4 = 1245333;
                    String message = MessageHandler.getMessage(msgID4);
                    bindOperation.setAuthFailureReason(msgID4, message);
                    return;
                }
                if (nullPos2 == nullPos1 + 1) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int msgID5 = 1245334;
                    String message = MessageHandler.getMessage(msgID5);
                    bindOperation.setAuthFailureReason(msgID5, message);
                    return;
                }
                if (nullPos2 == length - 1) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int msgID6 = 1245335;
                    String message = MessageHandler.getMessage(msgID6);
                    bindOperation.setAuthFailureReason(msgID6, message);
                    return;
                }
                authcID = credString.substring(nullPos1 + 1, nullPos2);
                password = credString.substring(nullPos2 + 1);
                userEntry = null;
                String lowerAuthcID = StaticUtils.toLowerCase(authcID);
                if (!lowerAuthcID.startsWith("dn:")) {
                    if (lowerAuthcID.startsWith("u:")) {
                        authcID = authcID.substring(2);
                    }
                    try {
                        userEntry = identityMapper.getEntryForID(authcID);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        int msgID7 = 1245509;
                        String message = MessageHandler.getMessage(msgID7, String.valueOf(authcID), de.getErrorMessage());
                        bindOperation.setAuthFailureReason(msgID7, message);
                        return;
                    }
                }
                try {
                    userDN = DN.decode(authcID.substring(3));
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int msgID8 = 1245336;
                    String message = MessageHandler.getMessage(msgID8, authcID, de.getErrorMessage());
                    bindOperation.setAuthFailureReason(msgID8, message);
                    return;
                }
                if (userDN.isNullDN()) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int msgID9 = 1245337;
                    String message = MessageHandler.getMessage(msgID9);
                    bindOperation.setAuthFailureReason(msgID9, message);
                    return;
                }
                DN rootDN = DirectoryServer.getActualRootBindDN(userDN);
                if (rootDN != null) {
                    userDN = rootDN;
                }
                Lock readLock = null;
                for (int i = 0; i < 3 && (readLock = LockManager.lockRead(userDN)) == null; ++i) {
                }
                if (readLock == null) {
                    bindOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                    msgID = 1048739;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(userDN));
                    bindOperation.setAuthFailureReason(msgID, message);
                    return;
                }
                try {
                    userEntry = DirectoryServer.getEntry(userDN);
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int msgID10 = 1245338;
                    String message = MessageHandler.getMessage(msgID10, String.valueOf(userDN), de.getErrorMessage());
                    bindOperation.setAuthFailureReason(msgID10, message);
                    return;
                }
                finally {
                    LockManager.unlock(userDN, readLock);
                }
                if (userEntry == null) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int msgID11 = 1245341;
                    String message = MessageHandler.getMessage(msgID11, authcID);
                    bindOperation.setAuthFailureReason(msgID11, message);
                    return;
                }
                bindOperation.setSASLAuthUserEntry(userEntry);
                authZEntry = userEntry;
                if (authzID == null) break block48;
                lowerAuthzID = StaticUtils.toLowerCase(authzID);
                if (!lowerAuthzID.startsWith("dn:")) break block49;
                try {
                    authzDN = DN.decode(authzID.substring(3));
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int msgID12 = 1245584;
                    String message = MessageHandler.getMessage(msgID12, authzID, de.getErrorMessage());
                    bindOperation.setAuthFailureReason(msgID12, message);
                    return;
                }
                DN actualAuthzDN = DirectoryServer.getActualRootBindDN(authzDN);
                if (actualAuthzDN != null) {
                    authzDN = actualAuthzDN;
                }
                if (authzDN.equals(userEntry.getDN())) break block48;
                AuthenticationInfo tempAuthInfo2 = new AuthenticationInfo(userEntry, DirectoryServer.isRootDN(userEntry.getDN()));
                InternalClientConnection tempConn2 = new InternalClientConnection(tempAuthInfo2);
                if (!tempConn2.hasPrivilege(Privilege.PROXIED_AUTH, bindOperation)) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int msgID13 = 1245585;
                    String message = MessageHandler.getMessage(msgID13, String.valueOf(userEntry.getDN()));
                    bindOperation.setAuthFailureReason(msgID13, message);
                    return;
                }
                if (authzDN.isNullDN()) {
                    authZEntry = null;
                    break block48;
                } else {
                    try {
                        authZEntry = DirectoryServer.getEntry(authzDN);
                        if (authZEntry == null) {
                            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            int msgID14 = 1245586;
                            String message = MessageHandler.getMessage(msgID14, String.valueOf(authzDN));
                            bindOperation.setAuthFailureReason(msgID14, message);
                            return;
                        }
                        break block48;
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        int msgID15 = 1245587;
                        String message = MessageHandler.getMessage(msgID15, String.valueOf(authzDN), de.getErrorMessage());
                        bindOperation.setAuthFailureReason(msgID15, message);
                        return;
                    }
                }
            }
            String idStr = lowerAuthzID.startsWith("u:") ? authzID.substring(2) : authzID;
            if (idStr.length() == 0) {
                authZEntry = null;
            } else {
                try {
                    authZEntry = identityMapper.getEntryForID(idStr);
                    if (authZEntry == null) {
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        msgID = 1245588;
                        String message = MessageHandler.getMessage(msgID, authzID);
                        bindOperation.setAuthFailureReason(msgID, message);
                        return;
                    }
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int msgID16 = 1245589;
                    String message = MessageHandler.getMessage(msgID16, authzID, de.getErrorMessage());
                    bindOperation.setAuthFailureReason(msgID16, message);
                    return;
                }
            }
            if (!(authZEntry != null && authZEntry.getDN().equals(userEntry.getDN()) || (tempConn = new InternalClientConnection(tempAuthInfo = new AuthenticationInfo(userEntry, DirectoryServer.isRootDN(userEntry.getDN())))).hasPrivilege(Privilege.PROXIED_AUTH, bindOperation))) {
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                int msgID17 = 1245585;
                String message = MessageHandler.getMessage(msgID17, String.valueOf(userEntry.getDN()));
                bindOperation.setAuthFailureReason(msgID17, message);
                return;
            }
        }
        try {
            PasswordPolicyState pwPolicyState = new PasswordPolicyState(userEntry, false, false);
            if (!pwPolicyState.passwordMatches(new ASN1OctetString(password))) {
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                int msgID = 1245344;
                String message = MessageHandler.getMessage(msgID);
                bindOperation.setAuthFailureReason(msgID, message);
                return;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int msgID = 1245562;
            String message = MessageHandler.getMessage(msgID, String.valueOf(userEntry.getDN()), String.valueOf(e));
            bindOperation.setAuthFailureReason(msgID, message);
            return;
        }
        bindOperation.setResultCode(ResultCode.SUCCESS);
        AuthenticationInfo authInfo = new AuthenticationInfo(userEntry, authZEntry, "PLAIN", DirectoryServer.isRootDN(userEntry.getDN()));
        bindOperation.setAuthenticationInfo(authInfo);
    }

    @Override
    public boolean isPasswordBased(String mechanism) {
        return true;
    }

    @Override
    public boolean isSecure(String mechanism) {
        return false;
    }

    @Override
    public boolean isConfigurationAcceptable(SASLMechanismHandlerCfg configuration, List<String> unacceptableReasons) {
        PlainSASLMechanismHandlerCfg config = (PlainSASLMechanismHandlerCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(PlainSASLMechanismHandlerCfg configuration, List<String> unacceptableReasons) {
        boolean configAcceptable = true;
        DN cfgEntryDN = configuration.dn();
        DN identityMapperDN = configuration.getIdentityMapperDN();
        IdentityMapper newIdentityMapper = DirectoryServer.getIdentityMapper(identityMapperDN);
        if (newIdentityMapper == null) {
            int msgID = 1245507;
            unacceptableReasons.add(MessageHandler.getMessage(msgID, String.valueOf(identityMapperDN), String.valueOf(cfgEntryDN)));
            configAcceptable = false;
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(PlainSASLMechanismHandlerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        DN identityMapperDN = configuration.getIdentityMapperDN();
        IdentityMapper newIdentityMapper = DirectoryServer.getIdentityMapper(identityMapperDN);
        if (newIdentityMapper == null) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
            }
            int msgID = 1245507;
            messages.add(MessageHandler.getMessage(msgID, String.valueOf(identityMapperDN), String.valueOf(this.configEntryDN)));
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.identityMapper = newIdentityMapper;
            this.currentConfig = configuration;
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

