/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import org.opends.server.admin.std.server.ExtendedOperationHandlerCfg;
import org.opends.server.api.ExtendedOperationHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1Long;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetConnectionIDExtendedOperation
extends ExtendedOperationHandler<ExtendedOperationHandlerCfg> {
    @Override
    public void initializeExtendedOperationHandler(ExtendedOperationHandlerCfg config) throws ConfigException, InitializationException {
        DirectoryServer.registerSupportedExtension("1.3.6.1.4.1.26027.1.6.2", this);
        this.registerControlsAndFeatures();
    }

    @Override
    public void finalizeExtendedOperationHandler() {
        DirectoryServer.deregisterSupportedExtension("1.3.6.1.4.1.26027.1.6.2");
        this.deregisterControlsAndFeatures();
    }

    @Override
    public void processExtendedOperation(ExtendedOperation operation) {
        operation.setResponseOID("1.3.6.1.4.1.26027.1.6.2");
        operation.setResponseValue(GetConnectionIDExtendedOperation.encodeResponseValue(operation.getConnectionID()));
        operation.setResultCode(ResultCode.SUCCESS);
    }

    public static ASN1OctetString encodeResponseValue(long connectionID) {
        return new ASN1OctetString(new ASN1Long(connectionID).encode());
    }

    public static long decodeResponseValue(ASN1OctetString responseValue) throws ASN1Exception {
        return ASN1Long.decodeAsLong(responseValue.value()).longValue();
    }
}

