/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.FileBasedTrustManagerCfg;
import org.opends.server.admin.std.server.TrustManagerCfg;
import org.opends.server.api.TrustManagerProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.ExpirationCheckTrustManager;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBasedTrustManagerProvider
extends TrustManagerProvider<FileBasedTrustManagerCfg>
implements ConfigurationChangeListener<FileBasedTrustManagerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DN configEntryDN;
    private char[] trustStorePIN;
    private FileBasedTrustManagerCfg currentConfig;
    private String trustStoreFile;
    private String trustStoreType;

    @Override
    public void initializeTrustManagerProvider(FileBasedTrustManagerCfg configuration) throws ConfigException, InitializationException {
        this.currentConfig = configuration;
        this.configEntryDN = configuration.dn();
        configuration.addFileBasedChangeListener(this);
        this.trustStoreFile = configuration.getTrustStoreFile();
        File f = StaticUtils.getFileForPath(this.trustStoreFile);
        if (!f.exists() || !f.isFile()) {
            int msgID = 1310807;
            String message = MessageHandler.getMessage(msgID, String.valueOf(this.trustStoreFile), String.valueOf(this.configEntryDN));
            throw new InitializationException(msgID, message);
        }
        this.trustStoreType = configuration.getTrustStoreType();
        if (this.trustStoreType == null) {
            this.trustStoreType = KeyStore.getDefaultType();
        }
        try {
            KeyStore.getInstance(this.trustStoreType);
        }
        catch (KeyStoreException kse) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, kse);
            }
            int msgID = 1310826;
            String message = MessageHandler.getMessage(msgID, String.valueOf(this.trustStoreType), String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(kse));
            throw new InitializationException(msgID, message);
        }
        String pinProperty = configuration.getTrustStorePinProperty();
        if (pinProperty == null) {
            String pinEnVar = configuration.getTrustStorePinEnvironmentVariable();
            if (pinEnVar == null) {
                String pinFilePath = configuration.getTrustStorePinFile();
                if (pinFilePath == null) {
                    String pinStr = configuration.getTrustStorePin();
                    this.trustStorePIN = (char[])(pinStr == null ? null : pinStr.toCharArray());
                } else {
                    String pinStr;
                    File pinFile = StaticUtils.getFileForPath(pinFilePath);
                    if (!pinFile.exists()) {
                        int msgID = 1310818;
                        String message = MessageHandler.getMessage(msgID, String.valueOf(pinFilePath), String.valueOf(this.configEntryDN));
                        throw new InitializationException(msgID, message);
                    }
                    BufferedReader br = null;
                    try {
                        br = new BufferedReader(new FileReader(pinFile));
                        pinStr = br.readLine();
                    }
                    catch (IOException ioe) {
                        int msgID = 1310819;
                        String message = MessageHandler.getMessage(msgID, String.valueOf(pinFilePath), String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(ioe));
                        throw new InitializationException(msgID, message, ioe);
                    }
                    finally {
                        try {
                            br.close();
                        }
                        catch (Exception e) {}
                    }
                    if (pinStr == null) {
                        int msgID = 1310820;
                        String message = MessageHandler.getMessage(msgID, String.valueOf(pinFilePath), String.valueOf(this.configEntryDN));
                        throw new InitializationException(msgID, message);
                    }
                    this.trustStorePIN = pinStr.toCharArray();
                }
            } else {
                String pinStr = System.getenv(pinEnVar);
                if (pinStr == null) {
                    int msgID = 1310815;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(pinProperty), String.valueOf(this.configEntryDN));
                    throw new InitializationException(msgID, message);
                }
                this.trustStorePIN = pinStr.toCharArray();
            }
        } else {
            String pinStr = System.getProperty(pinProperty);
            if (pinStr == null) {
                int msgID = 1310812;
                String message = MessageHandler.getMessage(msgID, String.valueOf(pinProperty), String.valueOf(this.configEntryDN));
                throw new InitializationException(msgID, message);
            }
            this.trustStorePIN = pinStr.toCharArray();
        }
    }

    @Override
    public void finalizeTrustManagerProvider() {
        this.currentConfig.removeFileBasedChangeListener(this);
    }

    @Override
    public TrustManager[] getTrustManagers() throws DirectoryException {
        KeyStore trustStore;
        try {
            trustStore = KeyStore.getInstance(this.trustStoreType);
            FileInputStream inputStream = new FileInputStream(StaticUtils.getFileForPath(this.trustStoreFile));
            trustStore.load(inputStream, this.trustStorePIN);
            inputStream.close();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 1310824;
            String message = MessageHandler.getMessage(msgID, this.trustStoreFile, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
        }
        try {
            String trustManagerAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(trustManagerAlgorithm);
            trustManagerFactory.init(trustStore);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            TrustManager[] newTrustManagers = new TrustManager[trustManagers.length];
            for (int i = 0; i < trustManagers.length; ++i) {
                newTrustManagers[i] = new ExpirationCheckTrustManager((X509TrustManager)trustManagers[i]);
            }
            return newTrustManagers;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 1310825;
            String message = MessageHandler.getMessage(msgID, this.trustStoreFile, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
        }
    }

    @Override
    public boolean isConfigurationAcceptable(TrustManagerCfg configuration, List<String> unacceptableReasons) {
        FileBasedTrustManagerCfg config = (FileBasedTrustManagerCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConfigurationChangeAcceptable(FileBasedTrustManagerCfg configuration, List<String> unacceptableReasons) {
        String pinFile;
        String pinEnVar;
        String pinProp;
        String message;
        int msgID;
        int msgID2;
        boolean configAcceptable = true;
        DN cfgEntryDN = configuration.dn();
        String newTrustStoreFile = configuration.getTrustStoreFile();
        try {
            File f = StaticUtils.getFileForPath(newTrustStoreFile);
            if (!f.exists() || !f.isFile()) {
                msgID2 = 1310807;
                unacceptableReasons.add(MessageHandler.getMessage(msgID2, String.valueOf(newTrustStoreFile), String.valueOf(cfgEntryDN)));
                configAcceptable = false;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            msgID2 = 1310808;
            unacceptableReasons.add(MessageHandler.getMessage(msgID2, String.valueOf(cfgEntryDN), StaticUtils.getExceptionMessage(e)));
            configAcceptable = false;
        }
        String storeType = configuration.getTrustStoreType();
        if (storeType != null) {
            try {
                KeyStore.getInstance(storeType);
            }
            catch (KeyStoreException kse) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, kse);
                }
                msgID = 1310826;
                message = MessageHandler.getMessage(msgID, String.valueOf(storeType), String.valueOf(cfgEntryDN), StaticUtils.getExceptionMessage(kse));
                unacceptableReasons.add(message);
                configAcceptable = false;
            }
        }
        if ((pinProp = configuration.getTrustStorePinProperty()) != null && System.getProperty(pinProp) == null) {
            msgID = 1310812;
            message = MessageHandler.getMessage(msgID, String.valueOf(pinProp), String.valueOf(cfgEntryDN));
            unacceptableReasons.add(message);
            configAcceptable = false;
        }
        if ((pinEnVar = configuration.getTrustStorePinEnvironmentVariable()) != null && System.getenv(pinEnVar) == null) {
            int msgID3 = 1310815;
            String message2 = MessageHandler.getMessage(msgID3, String.valueOf(pinEnVar), String.valueOf(cfgEntryDN));
            unacceptableReasons.add(message2);
            configAcceptable = false;
        }
        if ((pinFile = configuration.getTrustStorePinFile()) != null) {
            File f = new File(pinFile);
            if (f.exists()) {
                String pinStr = null;
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new FileReader(pinFile));
                    pinStr = br.readLine();
                }
                catch (IOException ioe) {
                    int msgID4 = 1310819;
                    String message3 = MessageHandler.getMessage(msgID4, String.valueOf(pinFile), String.valueOf(cfgEntryDN), StaticUtils.getExceptionMessage(ioe));
                    unacceptableReasons.add(message3);
                    configAcceptable = false;
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (Exception e) {}
                }
                if (pinStr == null) {
                    int msgID5 = 1310820;
                    String message4 = MessageHandler.getMessage(msgID5, String.valueOf(pinFile), String.valueOf(cfgEntryDN));
                    unacceptableReasons.add(message4);
                    configAcceptable = false;
                }
            } else {
                int msgID6 = 1310818;
                String message5 = MessageHandler.getMessage(msgID6, String.valueOf(pinFile), String.valueOf(cfgEntryDN));
                unacceptableReasons.add(message5);
                configAcceptable = false;
            }
        }
        return configAcceptable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigChangeResult applyConfigurationChange(FileBasedTrustManagerCfg configuration) {
        String newTrustStoreType;
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        String newTrustStoreFile = configuration.getTrustStoreFile();
        File f = StaticUtils.getFileForPath(newTrustStoreFile);
        if (!f.exists() || !f.isFile()) {
            resultCode = DirectoryServer.getServerErrorResultCode();
            int msgID = 1310807;
            messages.add(MessageHandler.getMessage(msgID, String.valueOf(newTrustStoreFile), String.valueOf(this.configEntryDN)));
        }
        if ((newTrustStoreType = configuration.getTrustStoreType()) == null) {
            newTrustStoreType = KeyStore.getDefaultType();
        }
        try {
            KeyStore.getInstance(newTrustStoreType);
        }
        catch (KeyStoreException kse) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, kse);
            }
            int msgID = 1310826;
            messages.add(MessageHandler.getMessage(msgID, String.valueOf(newTrustStoreType), String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(kse)));
            resultCode = DirectoryServer.getServerErrorResultCode();
        }
        Object newPIN = null;
        String newPINProperty = configuration.getTrustStorePinProperty();
        if (newPINProperty == null) {
            String newPINEnVar = configuration.getTrustStorePinEnvironmentVariable();
            if (newPINEnVar == null) {
                String newPINFile = configuration.getTrustStorePinFile();
                if (newPINFile == null) {
                    String pinStr = configuration.getTrustStorePin();
                    newPIN = pinStr == null ? null : pinStr.toCharArray();
                } else {
                    File pinFile = StaticUtils.getFileForPath(newPINFile);
                    if (!pinFile.exists()) {
                        resultCode = DirectoryServer.getServerErrorResultCode();
                        int msgID = 1310818;
                        messages.add(MessageHandler.getMessage(msgID, String.valueOf(newPINFile), String.valueOf(this.configEntryDN)));
                    } else {
                        String pinStr = null;
                        BufferedReader br = null;
                        try {
                            br = new BufferedReader(new FileReader(pinFile));
                            pinStr = br.readLine();
                        }
                        catch (IOException ioe) {
                            resultCode = DirectoryServer.getServerErrorResultCode();
                            int msgID = 1310819;
                            messages.add(MessageHandler.getMessage(msgID, String.valueOf(newPINFile), String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(ioe)));
                        }
                        finally {
                            try {
                                br.close();
                            }
                            catch (Exception e) {}
                        }
                        if (pinStr == null) {
                            resultCode = DirectoryServer.getServerErrorResultCode();
                            int msgID = 1310820;
                            messages.add(MessageHandler.getMessage(msgID, String.valueOf(newPINFile), String.valueOf(this.configEntryDN)));
                        } else {
                            newPIN = pinStr.toCharArray();
                        }
                    }
                }
            } else {
                String pinStr = System.getenv(newPINEnVar);
                if (pinStr == null) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    int msgID = 1310815;
                    messages.add(MessageHandler.getMessage(msgID, String.valueOf(newPINEnVar), String.valueOf(this.configEntryDN)));
                } else {
                    newPIN = pinStr.toCharArray();
                }
            }
        } else {
            String pinStr = System.getProperty(newPINProperty);
            if (pinStr == null) {
                resultCode = DirectoryServer.getServerErrorResultCode();
                int msgID = 1310812;
                messages.add(MessageHandler.getMessage(msgID, String.valueOf(newPINProperty), String.valueOf(this.configEntryDN)));
            } else {
                newPIN = pinStr.toCharArray();
            }
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.trustStoreFile = newTrustStoreFile;
            this.trustStoreType = newTrustStoreType;
            this.trustStorePIN = newPIN;
            this.currentConfig = configuration;
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

