/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.FileBasedKeyManagerCfg;
import org.opends.server.admin.std.server.KeyManagerCfg;
import org.opends.server.api.KeyManagerProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBasedKeyManagerProvider
extends KeyManagerProvider<FileBasedKeyManagerCfg>
implements ConfigurationChangeListener<FileBasedKeyManagerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DN configEntryDN;
    private char[] keyStorePIN;
    private FileBasedKeyManagerCfg currentConfig;
    private String keyStoreFile;
    private String keyStoreType;

    @Override
    public void initializeKeyManagerProvider(FileBasedKeyManagerCfg configuration) throws ConfigException, InitializationException {
        this.currentConfig = configuration;
        this.configEntryDN = configuration.dn();
        configuration.addFileBasedChangeListener(this);
        this.keyStoreFile = configuration.getKeyStoreFile();
        try {
            File f = StaticUtils.getFileForPath(this.keyStoreFile);
            if (!f.exists() || !f.isFile()) {
                int msgID = 1310765;
                String message = MessageHandler.getMessage(msgID, String.valueOf(this.keyStoreFile), String.valueOf(this.configEntryDN));
                throw new InitializationException(msgID, message);
            }
        }
        catch (SecurityException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 1310766;
            String message = MessageHandler.getMessage(msgID, String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(e));
            throw new InitializationException(msgID, message, e);
        }
        if (configuration.getKeyStoreType() != null) {
            try {
                KeyStore.getInstance(configuration.getKeyStoreType());
                this.keyStoreType = configuration.getKeyStoreType();
            }
            catch (KeyStoreException kse) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, kse);
                }
                int msgID = 1310783;
                String message = MessageHandler.getMessage(msgID, String.valueOf(configuration.getKeyStoreType()), String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(kse));
                throw new InitializationException(msgID, message);
            }
        } else {
            this.keyStoreType = KeyStore.getDefaultType();
        }
        this.keyStorePIN = null;
        if (configuration.getKeyStorePinProperty() != null) {
            String propertyName = configuration.getKeyStorePinProperty();
            String pinStr = System.getProperty(propertyName);
            if (pinStr == null) {
                int msgID = 1310770;
                String message = MessageHandler.getMessage(msgID, String.valueOf(propertyName), String.valueOf(this.configEntryDN));
                throw new InitializationException(msgID, message);
            }
            this.keyStorePIN = pinStr.toCharArray();
        } else if (configuration.getKeyStorePinEnvironmentVariable() != null) {
            String enVarName = configuration.getKeyStorePinEnvironmentVariable();
            String pinStr = System.getenv(enVarName);
            if (pinStr == null) {
                int msgID = 1310773;
                String message = MessageHandler.getMessage(msgID, String.valueOf(enVarName), String.valueOf(this.configEntryDN));
                throw new InitializationException(msgID, message);
            }
            this.keyStorePIN = pinStr.toCharArray();
        } else if (configuration.getKeyStorePinFile() != null) {
            String pinStr;
            String fileName = configuration.getKeyStorePinFile();
            File pinFile = StaticUtils.getFileForPath(fileName);
            if (!pinFile.exists()) {
                int msgID = 1310776;
                String message = MessageHandler.getMessage(msgID, String.valueOf(fileName), String.valueOf(this.configEntryDN));
                throw new InitializationException(msgID, message);
            }
            try {
                BufferedReader br = new BufferedReader(new FileReader(pinFile));
                pinStr = br.readLine();
                br.close();
            }
            catch (IOException ioe) {
                int msgID = 1310777;
                String message = MessageHandler.getMessage(msgID, String.valueOf(fileName), String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(ioe));
                throw new InitializationException(msgID, message, ioe);
            }
            if (pinStr == null) {
                int msgID = 1310778;
                String message = MessageHandler.getMessage(msgID, String.valueOf(fileName), String.valueOf(this.configEntryDN));
                throw new InitializationException(msgID, message);
            }
            this.keyStorePIN = pinStr.toCharArray();
        } else if (configuration.getKeyStorePin() != null) {
            this.keyStorePIN = configuration.getKeyStorePin().toCharArray();
        } else {
            int msgID = 1310781;
            String message = MessageHandler.getMessage(msgID, String.valueOf(this.configEntryDN));
            throw new ConfigException(msgID, message);
        }
    }

    @Override
    public void finalizeKeyManagerProvider() {
        this.currentConfig.removeFileBasedChangeListener(this);
    }

    @Override
    public KeyManager[] getKeyManagers() throws DirectoryException {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance(this.keyStoreType);
            FileInputStream inputStream = new FileInputStream(StaticUtils.getFileForPath(this.keyStoreFile));
            keyStore.load(inputStream, this.keyStorePIN);
            inputStream.close();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 1310782;
            String message = MessageHandler.getMessage(msgID, this.keyStoreFile, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
        }
        try {
            String keyManagerAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(keyManagerAlgorithm);
            keyManagerFactory.init(keyStore, this.keyStorePIN);
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 1310803;
            String message = MessageHandler.getMessage(msgID, this.keyStoreFile, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
        }
    }

    @Override
    public boolean isConfigurationAcceptable(KeyManagerCfg configuration, List<String> unacceptableReasons) {
        FileBasedKeyManagerCfg config = (FileBasedKeyManagerCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConfigurationChangeAcceptable(FileBasedKeyManagerCfg configuration, List<String> unacceptableReasons) {
        int msgID;
        boolean configAcceptable = true;
        DN cfgEntryDN = configuration.dn();
        String newKeyStoreFile = configuration.getKeyStoreFile();
        try {
            File f = StaticUtils.getFileForPath(newKeyStoreFile);
            if (!f.exists() || !f.isFile()) {
                msgID = 1310765;
                unacceptableReasons.add(MessageHandler.getMessage(msgID, String.valueOf(newKeyStoreFile), String.valueOf(cfgEntryDN)));
                configAcceptable = false;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            msgID = 1310766;
            unacceptableReasons.add(MessageHandler.getMessage(msgID, String.valueOf(cfgEntryDN), StaticUtils.getExceptionMessage(e)));
            configAcceptable = false;
        }
        if (configuration.getKeyStoreType() != null) {
            try {
                KeyStore.getInstance(configuration.getKeyStoreType());
            }
            catch (KeyStoreException kse) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, kse);
                }
                msgID = 1310783;
                unacceptableReasons.add(MessageHandler.getMessage(msgID, String.valueOf(configuration.getKeyStoreType()), String.valueOf(cfgEntryDN), StaticUtils.getExceptionMessage(kse)));
                configAcceptable = false;
            }
        }
        if (configuration.getKeyStorePinProperty() != null) {
            String propertyName = configuration.getKeyStorePinProperty();
            String pinStr = System.getProperty(propertyName);
            if (pinStr == null) {
                int msgID2 = 1310770;
                unacceptableReasons.add(MessageHandler.getMessage(msgID2, String.valueOf(propertyName), String.valueOf(cfgEntryDN)));
                configAcceptable = false;
            }
        } else if (configuration.getKeyStorePinEnvironmentVariable() != null) {
            String enVarName = configuration.getKeyStorePinEnvironmentVariable();
            String pinStr = System.getenv(enVarName);
            if (pinStr == null) {
                int msgID3 = 1310773;
                unacceptableReasons.add(MessageHandler.getMessage(msgID3, String.valueOf(enVarName), String.valueOf(cfgEntryDN)));
                configAcceptable = false;
            }
        } else if (configuration.getKeyStorePinFile() != null) {
            String fileName = configuration.getKeyStorePinFile();
            File pinFile = StaticUtils.getFileForPath(fileName);
            if (!pinFile.exists()) {
                int msgID4 = 1310776;
                unacceptableReasons.add(MessageHandler.getMessage(msgID4, String.valueOf(fileName), String.valueOf(cfgEntryDN)));
                configAcceptable = false;
            } else {
                String pinStr = null;
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new FileReader(pinFile));
                    pinStr = br.readLine();
                }
                catch (IOException ioe) {
                    int msgID5 = 1310777;
                    unacceptableReasons.add(MessageHandler.getMessage(msgID5, String.valueOf(fileName), String.valueOf(cfgEntryDN), StaticUtils.getExceptionMessage(ioe)));
                    configAcceptable = false;
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (Exception e) {}
                }
                if (pinStr == null) {
                    int msgID6 = 1310778;
                    unacceptableReasons.add(MessageHandler.getMessage(msgID6, String.valueOf(fileName), String.valueOf(cfgEntryDN)));
                    configAcceptable = false;
                }
            }
        } else if (configuration.getKeyStorePin() != null) {
            configuration.getKeyStorePin().toCharArray();
        } else {
            int msgID7 = 1310781;
            unacceptableReasons.add(MessageHandler.getMessage(msgID7, String.valueOf(cfgEntryDN)));
            configAcceptable = false;
        }
        return configAcceptable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigChangeResult applyConfigurationChange(FileBasedKeyManagerCfg configuration) {
        int msgID;
        int msgID2;
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        String newKeyStoreFile = configuration.getKeyStoreFile();
        try {
            File f = StaticUtils.getFileForPath(newKeyStoreFile);
            if (!f.exists() || !f.isFile()) {
                resultCode = DirectoryServer.getServerErrorResultCode();
                msgID2 = 1310765;
                messages.add(MessageHandler.getMessage(msgID2, String.valueOf(newKeyStoreFile), String.valueOf(this.configEntryDN)));
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            resultCode = DirectoryServer.getServerErrorResultCode();
            msgID2 = 1310766;
            messages.add(MessageHandler.getMessage(msgID2, String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(e)));
        }
        String newKeyStoreType = KeyStore.getDefaultType();
        if (configuration.getKeyStoreType() != null) {
            try {
                KeyStore.getInstance(configuration.getKeyStoreType());
                newKeyStoreType = configuration.getKeyStoreType();
            }
            catch (KeyStoreException kse) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, kse);
                }
                resultCode = DirectoryServer.getServerErrorResultCode();
                msgID = 1310783;
                messages.add(MessageHandler.getMessage(msgID, String.valueOf(configuration.getKeyStoreType()), String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(kse)));
            }
        }
        char[] newPIN = null;
        if (configuration.getKeyStorePinProperty() != null) {
            String propertyName = configuration.getKeyStorePinProperty();
            String pinStr = System.getProperty(propertyName);
            if (pinStr == null) {
                resultCode = DirectoryServer.getServerErrorResultCode();
                int msgID3 = 1310770;
                messages.add(MessageHandler.getMessage(msgID3, String.valueOf(propertyName), String.valueOf(this.configEntryDN)));
            } else {
                newPIN = pinStr.toCharArray();
            }
        } else if (configuration.getKeyStorePinEnvironmentVariable() != null) {
            String enVarName = configuration.getKeyStorePinEnvironmentVariable();
            String pinStr = System.getenv(enVarName);
            if (pinStr == null) {
                resultCode = DirectoryServer.getServerErrorResultCode();
                int msgID4 = 1310773;
                messages.add(MessageHandler.getMessage(msgID4, String.valueOf(enVarName), String.valueOf(this.configEntryDN)));
            } else {
                newPIN = pinStr.toCharArray();
            }
        } else if (configuration.getKeyStorePinFile() != null) {
            String fileName = configuration.getKeyStorePinFile();
            File pinFile = StaticUtils.getFileForPath(fileName);
            if (!pinFile.exists()) {
                resultCode = DirectoryServer.getServerErrorResultCode();
                int msgID5 = 1310776;
                messages.add(MessageHandler.getMessage(msgID5, String.valueOf(fileName), String.valueOf(this.configEntryDN)));
            } else {
                String pinStr = null;
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new FileReader(pinFile));
                    pinStr = br.readLine();
                }
                catch (IOException ioe) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    int msgID6 = 1310777;
                    messages.add(MessageHandler.getMessage(msgID6, String.valueOf(fileName), String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(ioe)));
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (Exception e) {}
                }
                if (pinStr == null) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    int msgID7 = 1310778;
                    messages.add(MessageHandler.getMessage(msgID7, String.valueOf(fileName), String.valueOf(this.configEntryDN)));
                } else {
                    newPIN = pinStr.toCharArray();
                }
            }
        } else if (configuration.getKeyStorePin() != null) {
            newPIN = configuration.getKeyStorePin().toCharArray();
        } else {
            resultCode = DirectoryServer.getServerErrorResultCode();
            msgID = 1310781;
            messages.add(MessageHandler.getMessage(msgID, String.valueOf(this.configEntryDN)));
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.currentConfig = configuration;
            this.keyStorePIN = newPIN;
            this.keyStoreFile = newKeyStoreFile;
            this.keyStoreType = newKeyStoreType;
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

