/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.ErrorLogAccountStatusNotificationHandlerCfgDefn;
import org.opends.server.admin.std.server.AccountStatusNotificationHandlerCfg;
import org.opends.server.admin.std.server.ErrorLogAccountStatusNotificationHandlerCfg;
import org.opends.server.api.AccountStatusNotificationHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.AccountStatusNotificationType;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorLogAccountStatusNotificationHandler
extends AccountStatusNotificationHandler<ErrorLogAccountStatusNotificationHandlerCfg>
implements ConfigurationChangeListener<ErrorLogAccountStatusNotificationHandlerCfg> {
    private static final HashSet<String> NOTIFICATION_TYPE_NAMES = new HashSet();
    private DN configEntryDN;
    private HashSet<AccountStatusNotificationType> notificationTypes;

    @Override
    public void initializeStatusNotificationHandler(ErrorLogAccountStatusNotificationHandlerCfg configuration) throws ConfigException, InitializationException {
        configuration.addErrorLogChangeListener(this);
        this.configEntryDN = configuration.dn();
        boolean applyChanges = true;
        this.processNotificationHandlerConfig(configuration, applyChanges);
    }

    @Override
    public void handleStatusNotification(AccountStatusNotificationType notificationType, DN userDN, int messageID, String message) {
        if (this.notificationTypes.contains((Object)notificationType)) {
            int msgID = 0x170177;
            ErrorLogger.logError(ErrorLogCategory.PASSWORD_POLICY, ErrorLogSeverity.NOTICE, msgID, notificationType.getNotificationTypeName(), String.valueOf(userDN), messageID, message);
        }
    }

    @Override
    public boolean isConfigurationAcceptable(AccountStatusNotificationHandlerCfg configuration, List<String> unacceptableReasons) {
        ErrorLogAccountStatusNotificationHandlerCfg config = (ErrorLogAccountStatusNotificationHandlerCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(ErrorLogAccountStatusNotificationHandlerCfg configuration, List<String> unacceptableReasons) {
        boolean applyChanges = false;
        boolean isAcceptable = this.processNotificationHandlerConfig(configuration, applyChanges);
        return isAcceptable;
    }

    public ConfigChangeResult applyConfigurationChange(ErrorLogAccountStatusNotificationHandlerCfg configuration, boolean detailedResults) {
        ConfigChangeResult changeResult = this.applyConfigurationChange(configuration);
        return changeResult;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(ErrorLogAccountStatusNotificationHandlerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        ConfigChangeResult changeResult = new ConfigChangeResult(resultCode, adminActionRequired, messages);
        boolean applyChanges = false;
        this.processNotificationHandlerConfig(configuration, applyChanges);
        return changeResult;
    }

    public boolean processNotificationHandlerConfig(ErrorLogAccountStatusNotificationHandlerCfg configuration, boolean applyChanges) {
        boolean isAcceptable = true;
        HashSet<AccountStatusNotificationType> newNotificationTypes = new HashSet<AccountStatusNotificationType>();
        for (ErrorLogAccountStatusNotificationHandlerCfgDefn.AccountStatusNotificationType configNotificationType : configuration.getAccountStatusNotificationType()) {
            newNotificationTypes.add(this.getNotificationType(configNotificationType));
        }
        if (applyChanges && isAcceptable) {
            this.notificationTypes = newNotificationTypes;
        }
        return isAcceptable;
    }

    private AccountStatusNotificationType getNotificationType(ErrorLogAccountStatusNotificationHandlerCfgDefn.AccountStatusNotificationType configNotificationType) {
        AccountStatusNotificationType nt = null;
        switch (configNotificationType) {
            case ACCOUNT_TEMPORARILY_LOCKED: {
                nt = AccountStatusNotificationType.ACCOUNT_TEMPORARILY_LOCKED;
                break;
            }
            case ACCOUNT_PERMANENTLY_LOCKED: {
                nt = AccountStatusNotificationType.ACCOUNT_PERMANENTLY_LOCKED;
                break;
            }
            case ACCOUNT_UNLOCKED: {
                nt = AccountStatusNotificationType.ACCOUNT_UNLOCKED;
                break;
            }
            case ACCOUNT_IDLE_LOCKED: {
                nt = AccountStatusNotificationType.ACCOUNT_IDLE_LOCKED;
                break;
            }
            case ACCOUNT_RESET_LOCKED: {
                nt = AccountStatusNotificationType.ACCOUNT_RESET_LOCKED;
                break;
            }
            case ACCOUNT_DISABLED: {
                nt = AccountStatusNotificationType.ACCOUNT_DISABLED;
                break;
            }
            case ACCOUNT_ENABLED: {
                nt = AccountStatusNotificationType.ACCOUNT_ENABLED;
                break;
            }
            case ACCOUNT_EXPIRED: {
                nt = AccountStatusNotificationType.ACCOUNT_EXPIRED;
                break;
            }
            case PASSWORD_EXPIRED: {
                nt = AccountStatusNotificationType.PASSWORD_EXPIRED;
                break;
            }
            case PASSWORD_EXPIRING: {
                nt = AccountStatusNotificationType.PASSWORD_EXPIRING;
                break;
            }
            case PASSWORD_RESET: {
                nt = AccountStatusNotificationType.PASSWORD_RESET;
                break;
            }
            case PASSWORD_CHANGED: {
                nt = AccountStatusNotificationType.PASSWORD_CHANGED;
            }
        }
        return nt;
    }

    static {
        for (AccountStatusNotificationType t : AccountStatusNotificationType.values()) {
            NOTIFICATION_TYPE_NAMES.add(t.getNotificationTypeName());
        }
    }
}

