/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import org.opends.server.admin.std.server.VirtualAttributeCfg;
import org.opends.server.api.VirtualAttributeProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringFactory;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.VirtualAttributeRule;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryUUIDVirtualAttributeProvider
extends VirtualAttributeProvider<VirtualAttributeCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    @Override
    public void initializeVirtualAttributeProvider(VirtualAttributeCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public boolean isMultiValued() {
        return false;
    }

    @Override
    public LinkedHashSet<AttributeValue> getValues(Entry entry, VirtualAttributeRule rule) {
        LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>(1);
        String normDNString = entry.getDN().toNormalizedString();
        String uuidString = UUID.nameUUIDFromBytes(StaticUtils.getBytes(normDNString)).toString();
        values.add(new AttributeValue(ByteStringFactory.create(uuidString), ByteStringFactory.create(uuidString)));
        return values;
    }

    @Override
    public boolean hasValue(Entry entry, VirtualAttributeRule rule) {
        return true;
    }

    @Override
    public boolean hasValue(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        try {
            String normalizedDN = entry.getDN().toNormalizedString();
            String uuidString = UUID.nameUUIDFromBytes(StaticUtils.getBytes(normalizedDN)).toString();
            String normalizedValue = value.getNormalizedStringValue();
            return uuidString.equals(normalizedValue);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return false;
        }
    }

    @Override
    public ConditionResult matchesSubstring(Entry entry, VirtualAttributeRule rule, ByteString subInitial, List<ByteString> subAny, ByteString subFinal) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public ConditionResult greaterThanOrEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public ConditionResult lessThanOrEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public ConditionResult approximatelyEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public boolean isSearchable(VirtualAttributeRule rule, SearchOperation searchOperation) {
        return false;
    }

    @Override
    public void processSearch(VirtualAttributeRule rule, SearchOperation searchOperation) {
        searchOperation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
        int msgID = 1245685;
        String message = MessageHandler.getMessage(msgID, rule.getAttributeType().getNameOrOID());
        searchOperation.appendErrorMessage(message);
    }
}

