/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.LinkedHashSet;
import org.opends.server.api.DirectoryThread;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.DynamicGroupMemberList;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchListener;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.types.DN;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.LDAPURL;
import org.opends.server.types.MembershipException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.types.SearchScope;

public class DynamicGroupSearchThread
extends DirectoryThread
implements InternalSearchListener {
    private final DN[] baseDNs;
    private final DynamicGroupMemberList memberList;
    private int searchCounter;
    private final LDAPURL[][] memberURLs;
    private final SearchFilter[] searchFilters;

    public DynamicGroupSearchThread(DynamicGroupMemberList memberList, DN[] baseDNs, SearchFilter[] filters, LDAPURL[][] memberURLs) {
        super("Dynamic Group Search Thread " + memberList.getDynamicGroupDN());
        this.memberList = memberList;
        this.baseDNs = baseDNs;
        this.searchFilters = filters;
        this.memberURLs = memberURLs;
        this.searchCounter = 0;
    }

    public void run() {
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        LinkedHashSet<String> attributes = new LinkedHashSet<String>(0);
        this.searchCounter = 0;
        while (this.searchCounter < this.baseDNs.length) {
            InternalSearchOperation searchOperation = conn.processSearch(this.baseDNs[this.searchCounter], SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, this.searchFilters[this.searchCounter], attributes, (InternalSearchListener)this);
            ResultCode resultCode = searchOperation.getResultCode();
            if (resultCode != ResultCode.SUCCESS) {
                String message;
                int msgID;
                if (resultCode == ResultCode.NO_SUCH_OBJECT) {
                    msgID = 1114562;
                    message = MessageHandler.getMessage(msgID, String.valueOf(this.baseDNs[this.searchCounter]), String.valueOf(this.memberList.getDynamicGroupDN()));
                    ErrorLogger.logError(ErrorLogCategory.EXTENSIONS, ErrorLogSeverity.MILD_WARNING, message, msgID);
                } else {
                    msgID = 1311171;
                    message = MessageHandler.getMessage(msgID, String.valueOf(this.baseDNs[this.searchCounter]), String.valueOf(this.searchFilters[this.searchCounter]), String.valueOf(this.memberList.getDynamicGroupDN()), String.valueOf((Object)resultCode), String.valueOf(searchOperation.getErrorMessage()));
                    if (!this.memberList.addResult(new MembershipException(msgID, message, true))) {
                        this.memberList.setSearchesCompleted();
                        return;
                    }
                }
            }
            ++this.searchCounter;
        }
        this.memberList.setSearchesCompleted();
    }

    public void handleInternalSearchEntry(InternalSearchOperation searchOperation, SearchResultEntry searchEntry) throws DirectoryException {
        for (LDAPURL url : this.memberURLs[this.searchCounter]) {
            if (!url.matchesEntry(searchEntry)) continue;
            if (!this.memberList.addResult(searchEntry)) {
                int msgID = 1311172;
                String message = MessageHandler.getMessage(msgID, String.valueOf(searchEntry.getDN()), String.valueOf(this.memberList.getDynamicGroupDN()));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
            }
            return;
        }
    }

    public void handleInternalSearchReference(InternalSearchOperation searchOperation, SearchResultReference searchReference) {
    }
}

