/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.DigestMD5SASLMechanismHandlerCfg;
import org.opends.server.admin.std.server.SASLMechanismHandlerCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.IdentityMapper;
import org.opends.server.api.SASLMechanismHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.BindOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.extensions.DigestMD5StateInfo;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LockManager;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;
import org.opends.server.util.Base64;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DigestMD5SASLMechanismHandler
extends SASLMechanismHandler<DigestMD5SASLMechanismHandlerCfg>
implements ConfigurationChangeListener<DigestMD5SASLMechanismHandlerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DigestMD5SASLMechanismHandlerCfg currentConfig;
    private DN configEntryDN;
    private IdentityMapper identityMapper;
    private MessageDigest md5Digest;
    private ReentrantLock digestLock;
    private SecureRandom randomGenerator;

    @Override
    public void initializeSASLMechanismHandler(DigestMD5SASLMechanismHandlerCfg configuration) throws ConfigException, InitializationException {
        configuration.addDigestMD5ChangeListener(this);
        this.currentConfig = configuration;
        this.configEntryDN = configuration.dn();
        this.digestLock = new ReentrantLock();
        this.randomGenerator = new SecureRandom();
        try {
            this.md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 1310912;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new InitializationException(msgID, message, e);
        }
        DN identityMapperDN = configuration.getIdentityMapperDN();
        this.identityMapper = DirectoryServer.getIdentityMapper(identityMapperDN);
        if (this.identityMapper == null) {
            int msgID = 1245501;
            String message = MessageHandler.getMessage(msgID, String.valueOf(identityMapperDN), String.valueOf(this.configEntryDN));
            throw new ConfigException(msgID, message);
        }
        DirectoryServer.registerSASLMechanismHandler("DIGEST-MD5", this);
    }

    @Override
    public void finalizeSASLMechanismHandler() {
        this.currentConfig.removeDigestMD5ChangeListener(this);
        DirectoryServer.deregisterSASLMechanismHandler("DIGEST-MD5");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void processSASLBind(BindOperation bindOperation) {
        byte[] responseAuth;
        String message;
        List<ByteString> clearPasswords;
        Entry authZEntry;
        Entry userEntry;
        String responseAuthzID;
        String responseCharset;
        byte[] responseDigest;
        String responseDigestURI;
        String responseQoP;
        String responseNonceCountStr;
        String responseCNonce;
        String responseNonce;
        String responseRealm;
        String responseUserName;
        DigestMD5StateInfo stateInfo;
        block99: {
            AuthenticationInfo tempAuthInfo;
            InternalClientConnection tempConn;
            String lowerAuthzID;
            int msgID;
            IdentityMapper identityMapper;
            block100: {
                DN authzDN;
                DN userDN;
                String message2;
                int msgID2;
                String message3;
                DigestMD5SASLMechanismHandlerCfg config = this.currentConfig;
                identityMapper = this.identityMapper;
                String realm = config.getRealm();
                ASN1OctetString clientCredentials = bindOperation.getSASLCredentials();
                ClientConnection clientConnection = bindOperation.getClientConnection();
                if (clientCredentials == null || clientCredentials.value().length == 0) {
                    StringBuilder challengeBuffer = new StringBuilder();
                    if (realm == null) {
                        Map<DN, Backend> suffixes = DirectoryServer.getPublicNamingContexts();
                        if (!suffixes.isEmpty()) {
                            Iterator<DN> iterator = suffixes.keySet().iterator();
                            challengeBuffer.append("realm=\"");
                            challengeBuffer.append(iterator.next().toNormalizedString());
                            challengeBuffer.append("\"");
                            while (iterator.hasNext()) {
                                challengeBuffer.append(",realm=\"");
                                challengeBuffer.append(iterator.next().toNormalizedString());
                                challengeBuffer.append("\"");
                            }
                        }
                    } else {
                        challengeBuffer.append("realm=\"");
                        challengeBuffer.append(realm);
                        challengeBuffer.append("\"");
                    }
                    String nonce = this.generateNonce();
                    if (challengeBuffer.length() > 0) {
                        challengeBuffer.append(",");
                    }
                    challengeBuffer.append("nonce=\"");
                    challengeBuffer.append(nonce);
                    challengeBuffer.append("\"");
                    challengeBuffer.append(",qop=\"auth\"");
                    challengeBuffer.append(",charset=utf-8");
                    challengeBuffer.append(",algorithm=md5-sess");
                    ASN1OctetString challenge = new ASN1OctetString(challengeBuffer.toString());
                    if (challenge.value().length >= 2048) {
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        int msgID3 = 1179848;
                        String message4 = MessageHandler.getMessage(msgID3, challenge.value().length);
                        bindOperation.setAuthFailureReason(msgID3, message4);
                        ErrorLogger.logError(ErrorLogCategory.EXTENSIONS, ErrorLogSeverity.SEVERE_WARNING, message4, msgID3);
                        return;
                    }
                    DigestMD5StateInfo stateInfo2 = new DigestMD5StateInfo(nonce, "00000000");
                    clientConnection.setSASLAuthStateInfo(stateInfo2);
                    bindOperation.setResultCode(ResultCode.SASL_BIND_IN_PROGRESS);
                    bindOperation.setServerSASLCredentials(challenge);
                    return;
                }
                Object saslStateInfo = clientConnection.getSASLAuthStateInfo();
                if (saslStateInfo == null) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int msgID4 = 1245385;
                    String message5 = MessageHandler.getMessage(msgID4);
                    bindOperation.setAuthFailureReason(msgID4, message5);
                    return;
                }
                if (!(saslStateInfo instanceof DigestMD5StateInfo)) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int msgID5 = 1245386;
                    String message6 = MessageHandler.getMessage(msgID5);
                    bindOperation.setAuthFailureReason(msgID5, message6);
                    return;
                }
                stateInfo = (DigestMD5StateInfo)saslStateInfo;
                responseUserName = null;
                responseRealm = null;
                responseNonce = null;
                responseCNonce = null;
                int responseNonceCount = -1;
                responseNonceCountStr = null;
                responseQoP = "auth";
                responseDigestURI = null;
                responseDigest = null;
                responseCharset = "ISO-8859-1";
                responseAuthzID = null;
                byte[] credBytes = clientCredentials.value();
                String credString = null;
                String lowerCreds = null;
                try {
                    credString = new String(credBytes, responseCharset);
                    lowerCreds = StaticUtils.toLowerCase(credString);
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    ErrorLogger.logError(ErrorLogCategory.EXTENSIONS, ErrorLogSeverity.SEVERE_WARNING, 1179851, responseCharset, StaticUtils.getExceptionMessage(e));
                }
                if (credString == null || lowerCreds.indexOf("charset=utf-8") >= 0) {
                    try {
                        credString = new String(credBytes, "UTF-8");
                        lowerCreds = StaticUtils.toLowerCase(credString);
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        int msgID6 = 1179852;
                        String message7 = MessageHandler.getMessage(msgID6, StaticUtils.getExceptionMessage(e));
                        bindOperation.setAuthFailureReason(msgID6, message7);
                        return;
                    }
                }
                int pos = 0;
                int length = credString.length();
                while (pos < length) {
                    String tokenValue;
                    int equalPos = credString.indexOf(61, pos + 1);
                    if (equalPos < 0) {
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        int msgID7 = 1245389;
                        String message8 = MessageHandler.getMessage(msgID7, pos);
                        bindOperation.setAuthFailureReason(msgID7, message8);
                        return;
                    }
                    String tokenName = lowerCreds.substring(pos, equalPos);
                    try {
                        StringBuilder valueBuffer = new StringBuilder();
                        pos = this.readToken(credString, equalPos + 1, length, valueBuffer);
                        tokenValue = valueBuffer.toString();
                    }
                    catch (DirectoryException de) {
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        bindOperation.setAuthFailureReason(de.getMessageID(), de.getErrorMessage());
                        return;
                    }
                    if (tokenName.equals("charset")) {
                        if (tokenValue.equalsIgnoreCase("utf-8")) continue;
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        int msgID8 = 1245390;
                        message3 = MessageHandler.getMessage(msgID8, tokenValue);
                        bindOperation.setAuthFailureReason(msgID8, message3);
                        return;
                    }
                    if (tokenName.equals("username")) {
                        responseUserName = tokenValue;
                        continue;
                    }
                    if (tokenName.equals("realm")) {
                        responseRealm = tokenValue;
                        if (realm == null || responseRealm.equals(realm)) continue;
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        int msgID9 = 1245392;
                        message3 = MessageHandler.getMessage(msgID9, responseRealm);
                        bindOperation.setAuthFailureReason(msgID9, message3);
                        return;
                    }
                    if (tokenName.equals("nonce")) {
                        responseNonce = tokenValue;
                        String requestNonce = stateInfo.getNonce();
                        if (responseNonce.equals(requestNonce)) continue;
                        int msgID10 = 1310929;
                        String message9 = MessageHandler.getMessage(msgID10);
                        clientConnection.disconnect(DisconnectReason.SECURITY_PROBLEM, false, msgID10, message9);
                        return;
                    }
                    if (tokenName.equals("cnonce")) {
                        responseCNonce = tokenValue;
                        continue;
                    }
                    if (tokenName.equals("nc")) {
                        int storedNonce;
                        try {
                            responseNonceCountStr = tokenValue;
                            responseNonceCount = Integer.parseInt(responseNonceCountStr, 16);
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            int msgID11 = 1245394;
                            String message10 = MessageHandler.getMessage(msgID11, tokenValue);
                            bindOperation.setAuthFailureReason(msgID11, message10);
                            return;
                        }
                        try {
                            storedNonce = Integer.parseInt(stateInfo.getNonceCount(), 16);
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            int msgID12 = 1310931;
                            String message11 = MessageHandler.getMessage(msgID12, StaticUtils.getExceptionMessage(e));
                            bindOperation.setAuthFailureReason(msgID12, message11);
                            return;
                        }
                        if (responseNonceCount == storedNonce + 1) continue;
                        int msgID13 = 1310932;
                        String message12 = MessageHandler.getMessage(msgID13);
                        clientConnection.disconnect(DisconnectReason.SECURITY_PROBLEM, false, msgID13, message12);
                        return;
                    }
                    if (tokenName.equals("qop")) {
                        responseQoP = tokenValue;
                        if (responseQoP.equals("auth")) continue;
                        if (responseQoP.equals("auth-int")) {
                            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            int msgID14 = 1245397;
                            message3 = MessageHandler.getMessage(msgID14);
                            bindOperation.setAuthFailureReason(msgID14, message3);
                            return;
                        }
                        if (responseQoP.equals("auth-conf")) {
                            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            int msgID15 = 1245398;
                            message3 = MessageHandler.getMessage(msgID15);
                            bindOperation.setAuthFailureReason(msgID15, message3);
                            return;
                        }
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        int msgID16 = 1245399;
                        message3 = MessageHandler.getMessage(msgID16, responseQoP);
                        bindOperation.setAuthFailureReason(msgID16, message3);
                        return;
                    }
                    if (tokenName.equals("digest-uri")) {
                        String expectedDigestURI;
                        responseDigestURI = tokenValue;
                        String serverFQDN = config.getServerFqdn();
                        if (serverFQDN == null || serverFQDN.length() <= 0 || (expectedDigestURI = "ldap/" + serverFQDN).equalsIgnoreCase(responseDigestURI)) continue;
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        int msgID17 = 1245713;
                        String message13 = MessageHandler.getMessage(msgID17, responseDigestURI, expectedDigestURI);
                        bindOperation.setAuthFailureReason(msgID17, message13);
                        return;
                    }
                    if (tokenName.equals("response")) {
                        try {
                            responseDigest = StaticUtils.hexStringToByteArray(tokenValue);
                            continue;
                        }
                        catch (ParseException pe) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, pe);
                            }
                            int msgID18 = 1245400;
                            String message14 = MessageHandler.getMessage(msgID18, StaticUtils.getExceptionMessage(pe));
                            bindOperation.setAuthFailureReason(msgID18, message14);
                            return;
                        }
                    }
                    if (tokenName.equals("authzid")) {
                        responseAuthzID = tokenValue;
                        continue;
                    }
                    if (tokenName.equals("maxbuf") || tokenName.equals("cipher")) continue;
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int msgID19 = 1245401;
                    message3 = MessageHandler.getMessage(msgID19, tokenName);
                    bindOperation.setAuthFailureReason(msgID19, message3);
                    return;
                }
                if (responseUserName == null || responseUserName.length() == 0) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    msgID2 = 1245402;
                    message2 = MessageHandler.getMessage(msgID2);
                    bindOperation.setAuthFailureReason(msgID2, message2);
                    return;
                }
                if (responseNonce == null) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    msgID2 = 1245403;
                    message2 = MessageHandler.getMessage(msgID2);
                    bindOperation.setAuthFailureReason(msgID2, message2);
                    return;
                }
                if (responseCNonce == null) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    msgID2 = 1245404;
                    message2 = MessageHandler.getMessage(msgID2);
                    bindOperation.setAuthFailureReason(msgID2, message2);
                    return;
                }
                if (responseNonceCount < 0) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    msgID2 = 1245405;
                    message2 = MessageHandler.getMessage(msgID2);
                    bindOperation.setAuthFailureReason(msgID2, message2);
                    return;
                }
                if (responseDigestURI == null) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    msgID2 = 1245406;
                    message2 = MessageHandler.getMessage(msgID2);
                    bindOperation.setAuthFailureReason(msgID2, message2);
                    return;
                }
                if (responseDigest == null) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    msgID2 = 1245407;
                    message2 = MessageHandler.getMessage(msgID2);
                    bindOperation.setAuthFailureReason(msgID2, message2);
                    return;
                }
                if (responseRealm == null) {
                    responseRealm = "";
                }
                userEntry = null;
                String lowerUserName = StaticUtils.toLowerCase(responseUserName);
                if (!lowerUserName.startsWith("dn:")) {
                    String userName = responseUserName;
                    if (lowerUserName.startsWith("u:")) {
                        if (lowerUserName.equals("u:")) {
                            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            int msgID20 = 1245412;
                            message3 = MessageHandler.getMessage(msgID20);
                            bindOperation.setAuthFailureReason(msgID20, message3);
                            return;
                        }
                        userName = responseUserName.substring(2);
                    }
                    try {
                        userEntry = identityMapper.getEntryForID(userName);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        int msgID21 = 1245503;
                        String message15 = MessageHandler.getMessage(msgID21, String.valueOf(responseUserName), de.getErrorMessage());
                        bindOperation.setAuthFailureReason(msgID21, message15);
                        return;
                    }
                }
                try {
                    userDN = DN.decode(responseUserName.substring(3));
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int msgID22 = 1245408;
                    String message16 = MessageHandler.getMessage(msgID22, responseUserName, de.getErrorMessage());
                    bindOperation.setAuthFailureReason(msgID22, message16);
                    return;
                }
                if (userDN.isNullDN()) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int msgID23 = 1245409;
                    message3 = MessageHandler.getMessage(msgID23);
                    bindOperation.setAuthFailureReason(msgID23, message3);
                    return;
                }
                DN rootDN = DirectoryServer.getActualRootBindDN(userDN);
                if (rootDN != null) {
                    userDN = rootDN;
                }
                Lock readLock = null;
                for (int i = 0; i < 3 && (readLock = LockManager.lockRead(userDN)) == null; ++i) {
                }
                if (readLock == null) {
                    bindOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                    msgID = 1048802;
                    String message17 = MessageHandler.getMessage(msgID, String.valueOf(userDN));
                    bindOperation.setAuthFailureReason(msgID, message17);
                    return;
                }
                try {
                    userEntry = DirectoryServer.getEntry(userDN);
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int msgID24 = 1245411;
                    String message18 = MessageHandler.getMessage(msgID24, String.valueOf(userDN), de.getErrorMessage());
                    bindOperation.setAuthFailureReason(msgID24, message18);
                    return;
                }
                finally {
                    LockManager.unlock(userDN, readLock);
                }
                if (userEntry == null) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int msgID25 = 1245415;
                    String message19 = MessageHandler.getMessage(msgID25, responseUserName);
                    bindOperation.setAuthFailureReason(msgID25, message19);
                    return;
                }
                bindOperation.setSASLAuthUserEntry(userEntry);
                authZEntry = userEntry;
                if (responseAuthzID == null) break block99;
                if (responseAuthzID.length() == 0) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int msgID26 = 1245577;
                    message3 = MessageHandler.getMessage(msgID26);
                    bindOperation.setAuthFailureReason(msgID26, message3);
                    return;
                }
                if (responseAuthzID.equals(responseUserName)) break block99;
                lowerAuthzID = StaticUtils.toLowerCase(responseAuthzID);
                if (!lowerAuthzID.startsWith("dn:")) break block100;
                try {
                    authzDN = DN.decode(responseAuthzID.substring(3));
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int msgID27 = 1245578;
                    String message20 = MessageHandler.getMessage(msgID27, responseAuthzID, de.getErrorMessage());
                    bindOperation.setAuthFailureReason(msgID27, message20);
                    return;
                }
                DN actualAuthzDN = DirectoryServer.getActualRootBindDN(authzDN);
                if (actualAuthzDN != null) {
                    authzDN = actualAuthzDN;
                }
                if (authzDN.equals(userEntry.getDN())) break block99;
                AuthenticationInfo tempAuthInfo2 = new AuthenticationInfo(userEntry, DirectoryServer.isRootDN(userEntry.getDN()));
                InternalClientConnection tempConn2 = new InternalClientConnection(tempAuthInfo2);
                if (!tempConn2.hasPrivilege(Privilege.PROXIED_AUTH, bindOperation)) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int msgID28 = 1245579;
                    String message21 = MessageHandler.getMessage(msgID28, String.valueOf(userEntry.getDN()));
                    bindOperation.setAuthFailureReason(msgID28, message21);
                    return;
                }
                if (authzDN.isNullDN()) {
                    authZEntry = null;
                    break block99;
                } else {
                    try {
                        authZEntry = DirectoryServer.getEntry(authzDN);
                        if (authZEntry == null) {
                            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            int msgID29 = 1245580;
                            String message22 = MessageHandler.getMessage(msgID29, String.valueOf(authzDN));
                            bindOperation.setAuthFailureReason(msgID29, message22);
                            return;
                        }
                        break block99;
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        int msgID30 = 1245581;
                        String message23 = MessageHandler.getMessage(msgID30, String.valueOf(authzDN), de.getErrorMessage());
                        bindOperation.setAuthFailureReason(msgID30, message23);
                        return;
                    }
                }
            }
            String idStr = lowerAuthzID.startsWith("u:") ? responseAuthzID.substring(2) : responseAuthzID;
            if (idStr.length() == 0) {
                authZEntry = null;
            } else {
                try {
                    authZEntry = identityMapper.getEntryForID(idStr);
                    if (authZEntry == null) {
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        msgID = 1245582;
                        String message24 = MessageHandler.getMessage(msgID, responseAuthzID);
                        bindOperation.setAuthFailureReason(msgID, message24);
                        return;
                    }
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int msgID31 = 1245583;
                    String message25 = MessageHandler.getMessage(msgID31, responseAuthzID, de.getErrorMessage());
                    bindOperation.setAuthFailureReason(msgID31, message25);
                    return;
                }
            }
            if (!(authZEntry != null && authZEntry.getDN().equals(userEntry.getDN()) || (tempConn = new InternalClientConnection(tempAuthInfo = new AuthenticationInfo(userEntry, DirectoryServer.isRootDN(userEntry.getDN())))).hasPrivilege(Privilege.PROXIED_AUTH, bindOperation))) {
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                int msgID32 = 1245579;
                String message26 = MessageHandler.getMessage(msgID32, String.valueOf(userEntry.getDN()));
                bindOperation.setAuthFailureReason(msgID32, message26);
                return;
            }
        }
        try {
            PasswordPolicyState pwPolicyState = new PasswordPolicyState(userEntry, false, false);
            clearPasswords = pwPolicyState.getClearPasswords();
            if (clearPasswords == null || clearPasswords.isEmpty()) {
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                int msgID = 1245420;
                message = MessageHandler.getMessage(msgID, String.valueOf(userEntry.getDN()));
                bindOperation.setAuthFailureReason(msgID, message);
                return;
            }
        }
        catch (Exception e) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int msgID = 1245560;
            message = MessageHandler.getMessage(msgID, String.valueOf(userEntry.getDN()), String.valueOf(e));
            bindOperation.setAuthFailureReason(msgID, message);
            return;
        }
        boolean matchFound = false;
        byte[] passwordBytes = null;
        for (ByteString clearPassword : clearPasswords) {
            byte[] generatedDigest;
            try {
                generatedDigest = this.generateResponseDigest(responseUserName, responseAuthzID, clearPassword.value(), responseRealm, responseNonce, responseCNonce, responseNonceCountStr, responseDigestURI, responseQoP, responseCharset);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                ErrorLogger.logError(ErrorLogCategory.EXTENSIONS, ErrorLogSeverity.SEVERE_WARNING, 1179885, StaticUtils.getExceptionMessage(e));
                continue;
            }
            if (!Arrays.equals(responseDigest, generatedDigest)) continue;
            matchFound = true;
            passwordBytes = clearPassword.value();
            break;
        }
        if (!matchFound) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int msgID = 1245419;
            String message27 = MessageHandler.getMessage(msgID);
            bindOperation.setAuthFailureReason(msgID, message27);
            return;
        }
        try {
            responseAuth = this.generateResponseAuthDigest(responseUserName, responseAuthzID, passwordBytes, responseRealm, responseNonce, responseCNonce, responseNonceCountStr, responseDigestURI, responseQoP, responseCharset);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int msgID = 1310958;
            String message28 = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            bindOperation.setAuthFailureReason(msgID, message28);
            return;
        }
        ASN1OctetString responseAuthStr = new ASN1OctetString("rspauth=" + this.getHexString(responseAuth));
        stateInfo.setNonceCount(responseNonceCountStr);
        bindOperation.setResultCode(ResultCode.SUCCESS);
        bindOperation.setServerSASLCredentials(responseAuthStr);
        AuthenticationInfo authInfo = new AuthenticationInfo(userEntry, authZEntry, "DIGEST-MD5", DirectoryServer.isRootDN(userEntry.getDN()));
        bindOperation.setAuthenticationInfo(authInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateNonce() {
        byte[] nonceBytes = new byte[16];
        this.digestLock.lock();
        try {
            this.randomGenerator.nextBytes(nonceBytes);
        }
        finally {
            this.digestLock.unlock();
        }
        return Base64.encode(nonceBytes);
    }

    private int readToken(String credentials, int startPos, int length, StringBuilder token) throws DirectoryException {
        char c;
        if (startPos >= length) {
            return startPos;
        }
        boolean isEscaped = false;
        boolean isQuoted = false;
        int pos = startPos;
        if ((c = credentials.charAt(pos++)) == ',') {
            return pos;
        }
        if (c == '\"') {
            isQuoted = true;
        } else if (c == '\\') {
            isEscaped = true;
        } else {
            token.append(c);
        }
        while (pos < length) {
            c = credentials.charAt(pos++);
            if (isEscaped) {
                token.append(c);
                isEscaped = false;
                continue;
            }
            if (c == ',') {
                if (!isQuoted) break;
                token.append(c);
                continue;
            }
            if (c == '\"') {
                if (isQuoted) {
                    char c2;
                    if (pos >= length || (c2 = credentials.charAt(pos++)) == ',') break;
                    int msgID = 1245423;
                    String message = MessageHandler.getMessage(msgID, pos - 2);
                    throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message, msgID);
                }
                token.append(c);
                continue;
            }
            if (c == '\\') {
                isEscaped = true;
                continue;
            }
            token.append(c);
        }
        return pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateResponseDigest(String userName, String authzID, byte[] password, String realm, String nonce, String cnonce, String nonceCount, String digestURI, String qop, String charset) throws UnsupportedEncodingException {
        this.digestLock.lock();
        try {
            StringBuilder a1String1 = new StringBuilder();
            a1String1.append(userName);
            a1String1.append(':');
            a1String1.append(realm);
            a1String1.append(':');
            byte[] a1Bytes1a = a1String1.toString().getBytes(charset);
            byte[] a1Bytes1 = new byte[a1Bytes1a.length + password.length];
            System.arraycopy(a1Bytes1a, 0, a1Bytes1, 0, a1Bytes1a.length);
            System.arraycopy(password, 0, a1Bytes1, a1Bytes1a.length, password.length);
            byte[] urpHash = this.md5Digest.digest(a1Bytes1);
            StringBuilder a1String2 = new StringBuilder();
            a1String2.append(':');
            a1String2.append(nonce);
            a1String2.append(':');
            a1String2.append(cnonce);
            if (authzID != null) {
                a1String2.append(':');
                a1String2.append(authzID);
            }
            byte[] a1Bytes2a = a1String2.toString().getBytes(charset);
            byte[] a1Bytes2 = new byte[urpHash.length + a1Bytes2a.length];
            System.arraycopy(urpHash, 0, a1Bytes2, 0, urpHash.length);
            System.arraycopy(a1Bytes2a, 0, a1Bytes2, urpHash.length, a1Bytes2a.length);
            byte[] a1Hash = this.md5Digest.digest(a1Bytes2);
            byte[] a2Bytes = ("AUTHENTICATE:" + digestURI).getBytes(charset);
            byte[] a2Hash = this.md5Digest.digest(a2Bytes);
            String a1HashHex = this.getHexString(a1Hash);
            String a2HashHex = this.getHexString(a2Hash);
            StringBuilder kdString = new StringBuilder();
            kdString.append(a1HashHex);
            kdString.append(':');
            kdString.append(nonce);
            kdString.append(':');
            kdString.append(nonceCount);
            kdString.append(':');
            kdString.append(cnonce);
            kdString.append(':');
            kdString.append(qop);
            kdString.append(':');
            kdString.append(a2HashHex);
            byte[] byArray = this.md5Digest.digest(kdString.toString().getBytes(charset));
            return byArray;
        }
        finally {
            this.digestLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateResponseAuthDigest(String userName, String authzID, byte[] password, String realm, String nonce, String cnonce, String nonceCount, String digestURI, String qop, String charset) throws UnsupportedEncodingException {
        this.digestLock.lock();
        try {
            StringBuilder a1String1 = new StringBuilder();
            a1String1.append(userName);
            a1String1.append(':');
            a1String1.append(realm);
            a1String1.append(':');
            byte[] a1Bytes1a = a1String1.toString().getBytes(charset);
            byte[] a1Bytes1 = new byte[a1Bytes1a.length + password.length];
            System.arraycopy(a1Bytes1a, 0, a1Bytes1, 0, a1Bytes1a.length);
            System.arraycopy(password, 0, a1Bytes1, a1Bytes1a.length, password.length);
            byte[] urpHash = this.md5Digest.digest(a1Bytes1);
            StringBuilder a1String2 = new StringBuilder();
            a1String2.append(':');
            a1String2.append(nonce);
            a1String2.append(':');
            a1String2.append(cnonce);
            if (authzID != null) {
                a1String2.append(':');
                a1String2.append(authzID);
            }
            byte[] a1Bytes2a = a1String2.toString().getBytes(charset);
            byte[] a1Bytes2 = new byte[urpHash.length + a1Bytes2a.length];
            System.arraycopy(urpHash, 0, a1Bytes2, 0, urpHash.length);
            System.arraycopy(a1Bytes2a, 0, a1Bytes2, urpHash.length, a1Bytes2a.length);
            byte[] a1Hash = this.md5Digest.digest(a1Bytes2);
            String a2String = ":" + digestURI;
            if (qop.equals("auth-int") || qop.equals("auth-conf")) {
                a2String = a2String + ":00000000000000000000000000000000";
            }
            byte[] a2Bytes = a2String.getBytes(charset);
            byte[] a2Hash = this.md5Digest.digest(a2Bytes);
            String a1HashHex = this.getHexString(a1Hash);
            String a2HashHex = this.getHexString(a2Hash);
            StringBuilder kdString = new StringBuilder();
            kdString.append(a1HashHex);
            kdString.append(':');
            kdString.append(nonce);
            kdString.append(':');
            kdString.append(nonceCount);
            kdString.append(':');
            kdString.append(cnonce);
            kdString.append(':');
            kdString.append(qop);
            kdString.append(':');
            kdString.append(a2HashHex);
            byte[] byArray = this.md5Digest.digest(kdString.toString().getBytes(charset));
            return byArray;
        }
        finally {
            this.digestLock.unlock();
        }
    }

    private String getHexString(byte[] byteArray) {
        StringBuilder buffer = new StringBuilder(2 * byteArray.length);
        for (byte b : byteArray) {
            buffer.append(StaticUtils.byteToLowerHex(b));
        }
        return buffer.toString();
    }

    @Override
    public boolean isPasswordBased(String mechanism) {
        return true;
    }

    @Override
    public boolean isSecure(String mechanism) {
        return true;
    }

    @Override
    public boolean isConfigurationAcceptable(SASLMechanismHandlerCfg configuration, List<String> unacceptableReasons) {
        DigestMD5SASLMechanismHandlerCfg config = (DigestMD5SASLMechanismHandlerCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(DigestMD5SASLMechanismHandlerCfg configuration, List<String> unacceptableReasons) {
        boolean configAcceptable = true;
        DN cfgEntryDN = configuration.dn();
        DN identityMapperDN = configuration.getIdentityMapperDN();
        IdentityMapper newIdentityMapper = DirectoryServer.getIdentityMapper(identityMapperDN);
        if (newIdentityMapper == null) {
            int msgID = 1245501;
            unacceptableReasons.add(MessageHandler.getMessage(msgID, String.valueOf(identityMapperDN), String.valueOf(cfgEntryDN)));
            configAcceptable = false;
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(DigestMD5SASLMechanismHandlerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        DN identityMapperDN = configuration.getIdentityMapperDN();
        IdentityMapper newIdentityMapper = DirectoryServer.getIdentityMapper(identityMapperDN);
        if (newIdentityMapper == null) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
            }
            int msgID = 1245501;
            messages.add(MessageHandler.getMessage(msgID, String.valueOf(identityMapperDN), String.valueOf(this.configEntryDN)));
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.identityMapper = newIdentityMapper;
            this.currentConfig = configuration;
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

