/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.CharacterSetPasswordValidatorCfg;
import org.opends.server.admin.std.server.PasswordValidatorCfg;
import org.opends.server.api.PasswordValidator;
import org.opends.server.config.ConfigException;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.Entry;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterSetPasswordValidator
extends PasswordValidator<CharacterSetPasswordValidatorCfg>
implements ConfigurationChangeListener<CharacterSetPasswordValidatorCfg> {
    private CharacterSetPasswordValidatorCfg currentConfig;
    private HashMap<String, Integer> characterSets;

    @Override
    public void initializePasswordValidator(CharacterSetPasswordValidatorCfg configuration) throws ConfigException {
        configuration.addCharacterSetChangeListener(this);
        this.currentConfig = configuration;
        this.characterSets = this.processCharacterSets(configuration);
    }

    @Override
    public void finalizePasswordValidator() {
        this.currentConfig.removeCharacterSetChangeListener(this);
    }

    @Override
    public boolean passwordIsAcceptable(ByteString newPassword, Set<ByteString> currentPasswords, Operation operation, Entry userEntry, StringBuilder invalidReason) {
        CharacterSetPasswordValidatorCfg config = this.currentConfig;
        HashMap<String, Integer> characterSets = this.characterSets;
        String password = newPassword.stringValue();
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (int i = 0; i < password.length(); ++i) {
            char c = password.charAt(i);
            boolean found = false;
            for (String characterSet : characterSets.keySet()) {
                if (characterSet.indexOf(c) < 0) continue;
                Integer count = (Integer)counts.get(characterSet);
                if (count == null) {
                    counts.put(characterSet, 1);
                } else {
                    counts.put(characterSet, count + 1);
                }
                found = true;
                break;
            }
            if (found || config.isAllowUnclassifiedCharacters()) continue;
            int msgID = 1245648;
            invalidReason.append(MessageHandler.getMessage(msgID, String.valueOf(c)));
            return false;
        }
        for (String characterSet : characterSets.keySet()) {
            int minimumCount = characterSets.get(characterSet);
            Integer passwordCount = (Integer)counts.get(characterSet);
            if (passwordCount != null && passwordCount >= minimumCount) continue;
            int msgID = 1245649;
            invalidReason.append(MessageHandler.getMessage(msgID, characterSet, minimumCount));
            return false;
        }
        return true;
    }

    private HashMap<String, Integer> processCharacterSets(CharacterSetPasswordValidatorCfg configuration) throws ConfigException {
        HashMap<String, Integer> characterSets = new HashMap<String, Integer>();
        HashSet<Character> usedCharacters = new HashSet<Character>();
        for (String definition : configuration.getCharacterSet()) {
            int minCount;
            String message;
            int msgID;
            int colonPos = definition.indexOf(58);
            if (colonPos <= 0) {
                msgID = 1245650;
                message = MessageHandler.getMessage(msgID, definition);
                throw new ConfigException(msgID, message);
            }
            if (colonPos == definition.length() - 1) {
                msgID = 1245651;
                message = MessageHandler.getMessage(msgID, definition);
                throw new ConfigException(msgID, message);
            }
            try {
                minCount = Integer.parseInt(definition.substring(0, colonPos));
            }
            catch (Exception e) {
                int msgID2 = 1245652;
                String message2 = MessageHandler.getMessage(msgID2, definition);
                throw new ConfigException(msgID2, message2);
            }
            if (minCount <= 0) {
                int msgID3 = 1245652;
                String message3 = MessageHandler.getMessage(msgID3, definition);
                throw new ConfigException(msgID3, message3);
            }
            String characterSet = definition.substring(colonPos + 1);
            for (int i = 0; i < characterSet.length(); ++i) {
                char c = characterSet.charAt(i);
                if (usedCharacters.contains(Character.valueOf(c))) {
                    int msgID4 = 1245653;
                    String message4 = MessageHandler.getMessage(msgID4, definition, String.valueOf(c));
                    throw new ConfigException(msgID4, message4);
                }
                usedCharacters.add(Character.valueOf(c));
            }
            characterSets.put(characterSet, minCount);
        }
        return characterSets;
    }

    @Override
    public boolean isConfigurationAcceptable(PasswordValidatorCfg configuration, List<String> unacceptableReasons) {
        CharacterSetPasswordValidatorCfg config = (CharacterSetPasswordValidatorCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(CharacterSetPasswordValidatorCfg configuration, List<String> unacceptableReasons) {
        try {
            this.processCharacterSets(configuration);
        }
        catch (ConfigException ce) {
            unacceptableReasons.add(ce.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(CharacterSetPasswordValidatorCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        try {
            this.characterSets = this.processCharacterSets(configuration);
            this.currentConfig = configuration;
        }
        catch (Exception e) {
            resultCode = DirectoryConfig.getServerErrorResultCode();
            messages.add(StaticUtils.getExceptionMessage(e));
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

