/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.TrustManagerCfgDefn;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.admin.std.server.TrustManagerCfg;
import org.opends.server.api.TrustManagerProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrustManagerProviderConfigManager
implements ConfigurationChangeListener<TrustManagerCfg>,
ConfigurationAddListener<TrustManagerCfg>,
ConfigurationDeleteListener<TrustManagerCfg> {
    private ConcurrentHashMap<DN, TrustManagerProvider> providers = new ConcurrentHashMap();

    public void initializeTrustManagerProviders() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addTrustManagerAddListener(this);
        rootConfiguration.addTrustManagerDeleteListener(this);
        for (String name : rootConfiguration.listTrustManagers()) {
            TrustManagerCfg providerConfig = rootConfiguration.getTrustManager(name);
            providerConfig.addChangeListener(this);
            if (!providerConfig.isEnabled()) continue;
            String className = providerConfig.getJavaImplementationClass();
            try {
                TrustManagerProvider provider = this.loadProvider(className, providerConfig, true);
                this.providers.put(providerConfig.dn(), provider);
                DirectoryServer.registerTrustManagerProvider(providerConfig.dn(), provider);
            }
            catch (InitializationException ie) {
                ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, ie.getMessage(), ie.getMessageID());
            }
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(TrustManagerCfg configuration, List<String> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaImplementationClass();
            try {
                this.loadProvider(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessage());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(TrustManagerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        configuration.addChangeListener(this);
        if (!configuration.isEnabled()) {
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        TrustManagerProvider provider = null;
        String className = configuration.getJavaImplementationClass();
        try {
            provider = this.loadProvider(className, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessage());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.providers.put(configuration.dn(), provider);
            DirectoryServer.registerTrustManagerProvider(configuration.dn(), provider);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(TrustManagerCfg configuration, List<String> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(TrustManagerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        DirectoryServer.deregisterTrustManagerProvider(configuration.dn());
        TrustManagerProvider provider = this.providers.remove(configuration.dn());
        if (provider != null) {
            provider.finalizeTrustManagerProvider();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(TrustManagerCfg configuration, List<String> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaImplementationClass();
            try {
                this.loadProvider(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessage());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(TrustManagerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        TrustManagerProvider existingProvider = this.providers.get(configuration.dn());
        if (!configuration.isEnabled()) {
            if (existingProvider != null) {
                DirectoryServer.deregisterTrustManagerProvider(configuration.dn());
                TrustManagerProvider provider = this.providers.remove(configuration.dn());
                if (provider != null) {
                    provider.finalizeTrustManagerProvider();
                }
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        String className = configuration.getJavaImplementationClass();
        if (existingProvider != null) {
            if (!className.equals(existingProvider.getClass().getName())) {
                adminActionRequired = true;
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        TrustManagerProvider provider = null;
        try {
            provider = this.loadProvider(className, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessage());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.providers.put(configuration.dn(), provider);
            DirectoryServer.registerTrustManagerProvider(configuration.dn(), provider);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private TrustManagerProvider loadProvider(String className, TrustManagerCfg configuration, boolean initialize) throws InitializationException {
        try {
            TrustManagerCfgDefn definition = TrustManagerCfgDefn.getInstance();
            ClassPropertyDefinition propertyDefinition = definition.getJavaImplementationClassPropertyDefinition();
            Class<TrustManagerProvider> providerClass = propertyDefinition.loadClass(className, TrustManagerProvider.class);
            TrustManagerProvider provider = providerClass.newInstance();
            if (initialize) {
                Method method = provider.getClass().getMethod("initializeTrustManagerProvider", configuration.definition().getServerConfigurationClass());
                method.invoke((Object)provider, configuration);
            } else {
                Method method = provider.getClass().getMethod("isConfigurationAcceptable", TrustManagerCfg.class, List.class);
                ArrayList unacceptableReasons = new ArrayList();
                Boolean acceptable = (Boolean)method.invoke((Object)provider, configuration, unacceptableReasons);
                if (!acceptable.booleanValue()) {
                    StringBuilder buffer = new StringBuilder();
                    if (!unacceptableReasons.isEmpty()) {
                        Iterator iterator = unacceptableReasons.iterator();
                        buffer.append((String)iterator.next());
                        while (iterator.hasNext()) {
                            buffer.append(".  ");
                            buffer.append((String)iterator.next());
                        }
                    }
                    int msgID = 3343016;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(configuration.dn()), buffer.toString());
                    throw new InitializationException(msgID, message);
                }
            }
            return provider;
        }
        catch (Exception e) {
            int msgID = 3342976;
            String message = MessageHandler.getMessage(msgID, className, String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(msgID, message, e);
        }
    }
}

